// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_ConcurrentStatement.hh"
#include "IIR_DesignatorList.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_Attribute.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


extern symbol_table *cgen_sym_tab_ptr;

IIRScram_SignalInterfaceDeclaration::IIRScram_SignalInterfaceDeclaration() {
  register int i;
  implemented_attributes_in_constructor = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_state = new IIR_Boolean[numSignalAttributes];
  implemented_attributes_in_initstate = new IIR_Boolean[numSignalAttributes];
  for(i = 0; i < numSignalAttributes; i++) {
    implemented_attributes_in_constructor[i] = FALSE;
    implemented_attributes_in_state[i] = FALSE;
    implemented_attributes_in_initstate[i] = FALSE;
  }
  _my_clone = NULL;
  _driver_addition_flag = FALSE;
}


IIRScram_SignalInterfaceDeclaration::~IIRScram_SignalInterfaceDeclaration() {
  delete [] implemented_attributes_in_constructor;
  delete [] implemented_attributes_in_state;
  delete [] implemented_attributes_in_initstate;
}

void 
IIRScram_SignalInterfaceDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " signal ";
  _publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_mode(_vhdl_out);
  _publish_vhdl_subtype_indication(_vhdl_out);
  _publish_vhdl_signal_kind(_vhdl_out);
  _publish_vhdl_expression(_vhdl_out);
}

IIR_SignalKind
IIRScram_SignalInterfaceDeclaration::_get_signal_kind(){
  return get_signal_kind();
}

void
IIRScram_SignalInterfaceDeclaration::_publish_cc_object_name( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_SignalInterfaceDeclaration::_publish_cc_elaborate" );
  _get_declarator()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_info";
}

void
IIRScram_SignalInterfaceDeclaration::_publish_cc_elaborate( published_file &_cc_out ){
  _publish_cc_object_name( _cc_out );
}


const string
IIRScram_SignalInterfaceDeclaration::_get_cc_type_name(){
  return get_subtype()->_get_cc_type_name();
}


IIRScram_Declaration::declaration_type 
IIRScram_SignalInterfaceDeclaration::_get_type(){
  return INTERFACE_SIGNAL;
}


void
IIRScram_SignalInterfaceDeclaration::_publish_cc_sigdest( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalInterfaceDeclaration::_publish_cc_sigdest" );
  
  ASSERT( cgen_sym_tab_ptr != NULL );
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );

  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  // _cc_out << "state.current->" << *get_declarator();
  _cc_out << "sate.current->";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}


void 
IIRScram_SignalInterfaceDeclaration::_publish_cc_decl( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalInterfaceDeclaration::_publish_cc_decl" );
  
  if(_is_implicit_declaration()) {
    _get_attribute_name()->_publish_cc_necessary_decl_in_state( _cc_out );
  }
  else {
    IIR_ObjectDeclaration::_publish_cc_decl( _cc_out );
  }
}

void
IIRScram_SignalInterfaceDeclaration::_publish_cc_data( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalInterfaceDeclaration::_publish_cc_data" );
  
  _cc_out << "getState()->";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}


void 
IIRScram_SignalInterfaceDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_SignalInterfaceDeclaration::_publish_cc_value" );
  ASSERT( get_declarator()->get_kind() == IIR_IDENTIFIER );

  if ((cgen_sym_tab_ptr != NULL) && (!cgen_sym_tab_ptr->in_scope(this))) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  IIRScram_Declaration::_set_scoping_prefix();
  IIRScram::_publish_cc_prefix_string( _cc_out );
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  IIRScram_Declaration::_reset_scoping_prefix();
}



void
IIRScram_SignalInterfaceDeclaration::_publish_cc_wait_data( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_SignalInterfaceDeclaration::_publish_cc_wait_data" );
  
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "s->";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}

const string
IIRScram_SignalInterfaceDeclaration::_get_cc_object_type() {
  return "SIGNAL";
}

IIR*
IIRScram_SignalInterfaceDeclaration::_clone() {
  if (_my_clone == NULL) {
    _my_clone = new IIR_SignalInterfaceDeclaration();
    IIRScram_Declaration::_clone(_my_clone);
    _my_clone->_set_driver_addition_flag(_have_added_driver());
    _my_clone->set_subtype(get_subtype());
    _my_clone->set_value(get_value());
    _my_clone->set_signal_kind(get_signal_kind());
    _my_clone->attributes = attributes;
  }
  return _my_clone;
}

void 
IIRScram_SignalInterfaceDeclaration::_type_check( IIRScram_InterfaceDeclaration::_InterfaceListType list_type ){
  IIR_InterfaceDeclaration::_type_check();

  if( get_subtype()->_is_access_type() == TRUE || get_subtype()->_is_file_type() == TRUE ){
    ostringstream err;
    err << "Signal interface declaration |" << *get_declarator() << "| must have a subtype "
	<< "indication that defines a subtype that is neither an access type or a file type.";
    report_error( this, err.str() );
  }

  if(list_type == IIRScram_InterfaceDeclaration::PARAMETER_INTERFACE_LIST && get_value() != NULL){
    ostringstream err;
    err << "Formal signal parameter |" << *get_declarator() << "| may not have a default "
	<< "value specified.";
    report_error( this, err.str() );
  }
}

visitor_return_type *IIRScram_SignalInterfaceDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_SignalInterfaceDeclaration(this, arg);
};
