
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LibraryClause.cc,v 1.2 1999/03/09 20:55:19 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_LibraryClause.hh"
#include "IIR_Identifier.hh"
#include "IIR_DesignFile.hh"
#include "IIR_LibraryDeclaration.hh"
#include "IIR_SimpleName.hh"
#include "symbol_table.hh"
#include "set.hh"
#include "error_func.hh"

IIRScram_LibraryClause::~IIRScram_LibraryClause(){}

void 
IIRScram_LibraryClause::_publish_vhdl(ostream &_vhdl_out) {
  _vhdl_out << " library ";
  get_logical_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_LibraryClause::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << " library ";
  get_logical_name()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";
}

void 
IIRScram_LibraryClause::_type_check(){
  // Right now we're going to wedge a new library declaration into
  // the symbol table.  This is probably not what should happen
  // after libraries work.
  IIR_Boolean is_std_lib = FALSE;
  IIR *logical_name = get_logical_name();
  ASSERT( logical_name->_is_text_literal() == TRUE );

  IIR_TextLiteral *as_literal = (IIR_TextLiteral *)logical_name;
  
  if( IIR_TextLiteral::_cmp( as_literal, "std" ) != 0 ){  
    // store use list for later use in makefile publishing
    IIR_DesignFile::use_list.append(as_literal->_convert_to_c_string());
  }
  else{
    is_std_lib = TRUE;
  }

  // Calling this method in this manner will cause the library to be found
  // and be added to the symbol table if needed.  
  IIR_LibraryDeclaration *lib_decl = _get_library_manager()->find_library( as_literal );
  if( lib_decl == NULL ){
    ostrstream err;
    err << "Could not locate a library directory corresponding to logical library name |" 
	<< *logical_name << "|.  Perhaps you need to create it with the option "
	<< "-design-library-name" << ends;
    report_error( logical_name, err );
  }
  else{
    if( is_std_lib == FALSE ){
      copy_location( this, lib_decl );
      lib_decl->_add_declaration();    
    }
  }

  _set_library_declaration( lib_decl );  
}





