// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_EnumerationLiteralList.cc,v 1.2 1999/03/09 20:49:52 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_EnumerationLiteralList.hh"
#include "IIR_Declaration.hh"
#include "IIR_EnumerationLiteral.hh"

IIRBase_EnumerationLiteralList::IIRBase_EnumerationLiteralList() {}
IIRBase_EnumerationLiteralList::~IIRBase_EnumerationLiteralList() {}


IIR_EnumerationLiteral* 
IIRBase_EnumerationLiteralList::first(){
  IIR_Declaration *retval = IIR_DeclarationList::first();

  ASSERT( retval == NULL || retval->get_kind() == IIR_ENUMERATION_LITERAL );

  return (IIR_EnumerationLiteral *)retval;
}

IIR_EnumerationLiteral* 
IIRBase_EnumerationLiteralList::last(){
  IIR_Declaration *retval = IIR_DeclarationList::last();

  ASSERT( retval == NULL || retval->get_kind() == IIR_ENUMERATION_LITERAL );

  return (IIR_EnumerationLiteral *)retval;
}


IIR_EnumerationLiteral * 
IIRBase_EnumerationLiteralList::successor( IIR_EnumerationLiteral *lit ) { 
  ASSERT( lit->get_kind() == IIR_ENUMERATION_LITERAL );

  IIR_Declaration *retval = IIR_DeclarationList::successor( lit );

  ASSERT( retval == NULL || retval->get_kind() == IIR_ENUMERATION_LITERAL );

  return (IIR_EnumerationLiteral *)retval;
}


IIR_EnumerationLiteral * 
IIRBase_EnumerationLiteralList::predecessor( IIR_EnumerationLiteral *lit ) { 
  ASSERT( lit->get_kind() == IIR_ENUMERATION_LITERAL );

  IIR_Declaration *retval = IIR_DeclarationList::predecessor( lit );

  ASSERT( retval == NULL || retval->get_kind() == IIR_ENUMERATION_LITERAL );

  return (IIR_EnumerationLiteral *)retval;
}

