
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase.cc,v 1.2 1999/03/09 20:48:21 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase.hh"
#include "IIR_Identifier.hh"
#include "IIR_DesignFile.hh"
#include "savant.hh"
#include "error_func.hh"

IIRBase::IIRBase() {
  _my_design_file = NULL;
  iir_line_number = -1;

#ifdef EXTRA_LOCATERS
  iir_column_offset = -1;
  iir_character_offset = -1;
#endif

#ifdef SCHEMATIC_INFO
  iir_sheet_name = NULL;  
  iir_x_coordinate = -1;
  iir_y_coordinate = -1;
#endif
}

void 
IIRBase::set_file_name( IIR_Identifier *file_name ){
  _my_design_file = new IIR_DesignFile();
  _my_design_file->set_name( file_name );
}

IIR_Identifier *
IIRBase::get_file_name(){
  if( _my_design_file == NULL ){
    return NULL;
  }
  else{
    return _my_design_file->get_name();
  }
}


IIRBase::~IIRBase() {}
