// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <tcl.h>

#include "colorbartruecolor.h"
#include "util.h"

ColorbarTrueColor::ColorbarTrueColor(Tcl_Interp* i,Tk_Canvas c,Tk_Item* item) 
  : ColorbarBase(i,c,item), Colorbar(i,c,item), ColorbarTrue(i,c,item)
{
  colorCount = 0;
}

int ColorbarTrueColor::initColormap()
{
  colorCount = (((ColorbarBaseOptions*)options)->colors);

  colorIndex = new unsigned short[colorCount];
  for (int i=0; i<colorCount; i++)
    colorIndex[i] = i;
  colorCells = new unsigned char[colorCount*3];

  return TCL_OK;
}

void ColorbarTrueColor::updateColorCells()
{
  // fill rgb table
  // note: its filled bgr to match XImage

  if (cmaps.current())
    for(int i=0, j=colorCount-1; i<colorCount; i++, j--) {
      int index = invert ? calcContrastBias(j) : calcContrastBias(i);
      colorCells[i*3] = cmaps.current()->getBlueChar(index, colorCount);
      colorCells[i*3+1] = cmaps.current()->getGreenChar(index, colorCount);
      colorCells[i*3+2] = cmaps.current()->getRedChar(index, colorCount);
    }

  ctags.head();
  while (ctags.current()) {
    for (int ii=ctags.current()->start(); ii<ctags.current()->stop(); ii++) {
      colorCells[ii*3] = ctags.current()->colorBlue();
      colorCells[ii*3+1] = ctags.current()->colorGreen();
      colorCells[ii*3+2] = ctags.current()->colorRed();
    }
    ctags.next();
  }
}
