// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __framepseudo8_h__
#define __framepseudo8_h__

#include "frame.h"

class FramePseudoColor8 : public Frame {
private:
  void updateColorScale();
  void fillXImage(XImage*, int, int, int, int, double* (FitsImage::*)());
  void fillXImageMosaic(XImage*, int, int, int, int, double* (FitsImage::*)());
  void fillXImageMosaicFast(XImage*, int, int, int, int, 
			    double* (FitsImage::*)());
  void rotateMotion();

  void psLevel2Head(PSColorSpace, int, int);
  void psLevel2Single(PSColorSpace, int, int, float);
  void psLevel2Mosaic(PSColorSpace, int, int, float);
  void psLevel2MosaicFast(PSColorSpace, int, int, float);

public:
  FramePseudoColor8(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  ~FramePseudoColor8();

  void colormapCmd(int, float, float, int, unsigned short*, 
		   unsigned char*, int);
  void colormapBeginCmd() {}
  void colormapBeginCmd(const Vector&) {}
  void colormapMotionCmd(int id, float b, float c, int i, unsigned short*,
			 unsigned char* ptr, int cnt) {}
  void colormapEndCmd(int id, float b, float c, int i, unsigned short* index, 
		      unsigned char* cells, int cnt)
    {colormapCmd(id,b,c,i,index,cells,cnt);}

  void bgColorCmd(const char*);
};

#endif
