// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __baseline_h__
#define __baseline_h__

#include "marker.h"

class BaseLine : public Marker {
protected:
  Vector p1;
  Vector p2;

public:
  BaseLine(const BaseLine&);
  BaseLine(FrameBase* p, const Vector& ptr1, const Vector& ptr2,
	   const char* clr, int wth, const char* fnt, const char* txt,
	   unsigned short prop, const char* cmt, 
	   const List<Tag>& tg, const List<CallBack>& cb);

  virtual void updateCoords(const Matrix&);

  void move(const Vector&);
  void moveTo(const Vector&);
  virtual void edit(const Vector&, int);

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  const Vector& getP1() {return p1;}
  const Vector& getP2() {return p2;}
  virtual void setPoints(const Vector&, const Vector&);

  // special composite funtionality
  void setComposite(const Matrix&, double);
};

#endif
