#! /bin/sh

# functions

doit () {
    echo "Generating $6 $7 $8 $9 in ${10}"
    xpaset -p ds9 regions format $1
    xpaset -p ds9 regions system $2
    xpaset -p ds9 regions sky $3
    xpaset -p ds9 regions skyformat $4
    xpaset -p ds9 regions load $5

    xpaset -p ds9 regions format $6
    xpaset -p ds9 regions system $7
    xpaset -p ds9 regions sky $8
    xpaset -p ds9 regions skyformat $9
    xpaset -p ds9 regions save ${10}

    xpaset -p ds9 regions deleteall
}

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ../ds9&

    i=1
    while [ "$i" -le 30 ]
    do
        sleep 2
        if [ `xpaaccess ds9` = yes ]
        then
	    break
        fi

        i=`expr $i + 1`
    done
fi

echo "Loading Data..."
xpaset -p ds9 file img16.fits
echo "DONE"

if [ "$1" = "ds9" ]; then
echo
echo "DS9 Format..."
doit ds9 image fk5 degrees ds9.image.reg ds9 physical fk5 degrees ds9.physical.reg 
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk4 degrees ds9.fk4.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk4 sexagesimal ds9.fk4.hms.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk5 degrees ds9.fk5.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk5 sexagesimal ds9.fk5.hms.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs icrs degrees ds9.icrs.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs icrs sexagesimal ds9.icrs.hms.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs galactic degrees ds9.galactic.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs galactic sexagesimal ds9.galactic.hms.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs ecliptic degrees ds9.ecliptic.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs ecliptic sexagesimal ds9.ecliptic.hms.reg
fi

if [ "$1" = "ds9strip" ]; then
echo
xpaset -p ds9 regions strip yes

echo "DS9 strip Format..."
doit ds9 image fk5 degrees ds9.image.reg ds9 image fk5 degrees ds9.image.strip.reg 
doit ds9 image fk5 degrees ds9.image.reg ds9 physical fk5 degrees ds9.physical.strip.reg 
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk4 degrees ds9.fk4.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk4 sexagesimal ds9.fk4.hms.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk5 degrees ds9.fk5.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs fk5 sexagesimal ds9.fk5.hms.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs icrs degrees ds9.icrs.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs icrs sexagesimal ds9.icrs.hms.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs galactic degrees ds9.galactic.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs galactic sexagesimal ds9.galactic.hms.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs ecliptic degrees ds9.ecliptic.strip.reg
doit ds9 image fk5 degrees ds9.image.reg ds9 wcs ecliptic sexagesimal ds9.ecliptic.hms.strip.reg

xpaset -p ds9 regions strip yes
fi

if [ "$1" = "ciao" ]; then
echo
echo "DS9 Format..."
doit ds9 image fk5 degrees ds9.image.reg ciao physical fk5 degrees ciao.physical.reg 
doit ds9 image fk5 degrees ds9.image.reg ciao wcs fk5 sexagesimal ciao.fk5.reg 
fi

if [ "$1" = "saotng" ]; then
echo
echo "SAOtng Format..."
doit ds9 image fk5 degrees ds9.image.reg saotng image fk5 degrees saotng.image.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs fk4 degrees saotng.fk4.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs fk4 sexagesimal saotng.fk4.hms.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs fk5 degrees saotng.fk5.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs fk5 sexagesimal saotng.fk5.hms.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs icrs degrees saotng.icrs.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs icrs sexagesimal saotng.icrs.hms.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs galactic degrees saotng.galactic.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs galactic sexagesimal saotng.galactic.hms.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs ecliptic degrees saotng.ecliptic.reg
doit ds9 image fk5 degrees ds9.image.reg saotng wcs ecliptic sexagesimal saotng.ecliptic.hms.reg
fi

if [ "$1" = "pros" ]; then
echo
echo "IRAF Pros Format..."
doit ds9 image fk5 degrees ds9.image.reg pros image fk5 degrees pros.image.reg
doit ds9 image fk5 degrees ds9.image.reg pros physical fk5 degrees pros.physical.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs fk4 degrees pros.fk4.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs fk4 sexagesimal pros.fk4.hms.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs fk5 degrees pros.fk5.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs fk5 sexagesimal pros.fk5.hms.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs galactic degrees pros.galactic.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs galactic sexagesimal pros.galactic.hms.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs ecliptic degrees pros.ecliptic.reg
doit ds9 image fk5 degrees ds9.image.reg pros wcs ecliptic sexagesimal pros.ecliptic.hms.reg
fi

if [ "$1" = "xy" ]; then
echo
echo "X Y Format..."
doit ds9 image fk5 degrees ds9.image.reg xy image fk5 degrees xy.image.reg
doit ds9 image fk5 degrees ds9.image.reg xy physical fk5 degrees xy.physical.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs fk4 degrees xy.fk4.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs fk4 sexagesimal xy.fk4.hms.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs fk5 degrees xy.fk5.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs fk5 sexagesimal xy.fk5.hms.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs icrs degrees xy.icrs.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs icrs sexagesimal xy.icrs.hms.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs galactic degrees xy.galactic.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs galactic sexagesimal xy.galactic.hms.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs ecliptic degrees xy.ecliptic.reg
doit ds9 image fk5 degrees ds9.image.reg xy wcs ecliptic sexagesimal xy.ecliptic.hms.reg
fi

if [ "$1" = "mosaic" ]; then
echo
echo "Loading Mosaic Data..."
xpaset -p ds9 frame clear
xpaset -p ds9 file mosaicimage mosaicimage.fits
echo "DONE"

echo
echo "DS9 Mosaic Format..."
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 physical fk5 degrees ds9.mosaic.physical.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs fk4 degrees ds9.mosaic.fk4.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs fk4 sexagesimal ds9.mosaic.fk4.hms.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs fk5 degrees ds9.mosaic.fk5.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs fk5 sexagesimal ds9.mosaic.fk5.hms.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs icrs degrees ds9.mosaic.icrs.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs icrs sexagesimal ds9.mosaic.icrs.hms.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs galactic degrees ds9.mosaic.galactic.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs galactic sexagesimal ds9.mosaic.galactic.hms.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs ecliptic degrees ds9.mosaic.ecliptic.reg
doit ds9 image fk5 degrees ds9.mosaic.image.reg ds9 wcs ecliptic sexagesimal ds9.mosaic.ecliptic.hms.reg
fi

if [ "$1" = "linear" ]; then
echo
echo "Loading Linear Data..."
xpaset -p ds9 scale minmax
xpaset -p ds9 frame clear
xpaset -p ds9 file mosaicimage ds9_8amp_2x2.fits
echo "DONE"

echo
echo "DS9 Linear Format..."
doit ds9 wcs fk5 degrees ds9.linear.wcs.reg ds9 wcsa fk5 degrees ds9.linear.wcsa.reg
doit ds9 wcs fk5 degrees ds9.linear.wcs.reg ds9 wcsc fk5 degrees ds9.linear.wcsc.reg
doit ds9 wcs fk5 degrees ds9.linear.wcs.reg ds9 wcsd fk5 degrees ds9.linear.wcsd.reg
doit ds9 wcs fk5 degrees ds9.linear.wcs.reg ds9 wcsi fk5 degrees ds9.linear.wcsi.reg
doit ds9 wcs fk5 degrees ds9.linear.wcs.reg ds9 wcsp fk5 degrees ds9.linear.wcsp.reg
fi

xpaset -p ds9 quit
