#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc SmoothUpdate {} {
    global smooth
    global current

    SetWatchCursor
    if {$current(frame) != {}} {
	if {$smooth(view) && [$current(frame) has fits]} {
	    $current(frame) smooth $smooth(function) $smooth(radius)
	} else {
	    $current(frame) smooth delete
	}
    }

    UpdateContourMenu
    UpdateContourDialog
    UpdateGraphXAxis
    UpdateScaleDialog
    UnsetWatchCursor
}

proc SmoothDialog {} {
    global ds9
    global smooth
    global menu

    # see if we already have a window visible

    if [winfo exist $smooth(top)] {
	raise $smooth(top)
	return
    }

    set w $smooth(top)
    set title "Smoothing Parameters"

    # create the window

    toplevel $w -colormap $ds9(main)
    wm title $w $title
    wm iconname $w $title
    wm group $w $ds9(top)
    wm protocol $w WM_DELETE_WINDOW SmoothDestroyDialog

    $w configure -menu $smooth(mb)

    menu $smooth(mb) -tearoff 0
    $smooth(mb) add cascade -label File -menu $smooth(mb).file
    $smooth(mb) add cascade -label Edit -menu $smooth(mb).edit

    menu $smooth(mb).file -tearoff 0 -selectcolor $menu(selectcolor)
    $smooth(mb).file add command -label "Apply" -command SmoothApplyDialog
    $smooth(mb).file add command -label "Clear" -command SmoothClearDialog
    $smooth(mb).file add separator
    $smooth(mb).file add command -label "Close" -command SmoothDestroyDialog

    menu $smooth(mb).edit -tearoff 0 -selectcolor $menu(selectcolor)
    $smooth(mb).edit add command -label "Cut" -state disabled
    $smooth(mb).edit add command -label "Copy" -state disabled
    $smooth(mb).edit add command -label "Paste" -state disabled
    $smooth(mb).edit add command -label "Clear" -state disabled

    frame $w.params
    frame $w.buttons -relief groove -borderwidth 2
    pack $w.params $w.buttons -fill x -ipadx 4 -ipady 4

    # Params
    frame $w.params.a -relief groove -borderwidth 2
    frame $w.params.b -relief groove -borderwidth 2
    pack $w.params.a $w.params.b -side top \
	-fill both -expand true -ipadx 4

    frame $w.params.a.a
    pack $w.params.a.a -anchor w -ipadx 4 -ipady 4

    label $w.params.a.a.title -text "Function "
    radiobutton $w.params.a.a.boxcar -text Boxcar \
	-variable smooth(function) -value boxcar \
	-selectcolor $menu(selectcolor)
    radiobutton $w.params.a.a.tophat -text Tophat \
	-variable smooth(function) -value tophat \
	-selectcolor $menu(selectcolor)
    radiobutton $w.params.a.a.gaussian -text Gaussian \
	-variable smooth(function) -value gaussian \
	-selectcolor $menu(selectcolor)
    grid $w.params.a.a.title $w.params.a.a.boxcar -sticky w
    grid x $w.params.a.a.tophat -sticky w
    grid x $w.params.a.a.gaussian -sticky w
    
    scale $w.params.b.slider  -from 1 -to 20 -length 300 \
	-label "Kernel Radius" \
	-variable smooth(radius) \
	-orient horizontal \
	-tickinterval 2 -showvalue false -resolution 1
    entry $w.params.b.value -textvariable smooth(radius) -width 7 
    pack $w.params.b.slider $w.params.b.value -side left -padx 4

    # buttons
    button $w.buttons.apply -text "Apply" -command SmoothApplyDialog
    button $w.buttons.clear -text "Clear" -command SmoothClearDialog
    button $w.buttons.close -text "Close" -command SmoothDestroyDialog
    pack $w.buttons.apply $w.buttons.clear $w.buttons.close \
	-side left -padx 10 -expand true

    UpdateSmoothDialog
}

proc SmoothApplyDialog {} {
    global smooth

    set smooth(view) 1
    SmoothUpdate
}

proc SmoothDestroyDialog {} {
    global smooth

    if {[winfo exist $smooth(top)]} {
	destroy $smooth(top)
	destroy $smooth(mb)
    }
}

proc SmoothClearDialog {} {
    global smooth

    set smooth(view) 0
    SmoothUpdate
}

proc UpdateSmoothMenu {} {
    global smooth
    global current

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateSmoothMenu"
    }

    if {($current(frame) != {}) && [$current(frame) has fits]} {
	set smooth(view) [$current(frame) has smooth]
	set smooth(function) [$current(frame) get smooth function]
	set smooth(radius) [$current(frame) get smooth radius]
    } else {
	set smooth(view) 0
	set smooth(function) gaussian
	set smooth(radius) 3
    }
}

proc UpdateSmoothDialog {} {
    global smooth
    global current

    global debug
    if {$debug(tcl,update)} {
	puts "UpdateSmoothDialog"
    }

    if {[winfo exist $smooth(top)] && $current(frame) != {}} {
    }
}

proc ProcessSmoothCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global smooth

    switch -- [string tolower [lindex $var $i]] {
	radius {
	    incr i
	    set smooth(radius) [lindex $var $i]
	    SmoothUpdate
	}
	function {
	    incr i
	    set smooth(function) [lindex $var $i]
	    SmoothUpdate
	}
	default {
	    set smooth(view) [FromYesNo [lindex $var $i]]
	    SmoothUpdate
	}
    }
}
