#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc InitPanner {} {
    global ds9

    # other bindings
    BindEventsPanner

    bind $ds9(panner) <Tab> [list NextFrame]
    bind $ds9(panner) <Shift-Tab> [list PrevFrame]

    bind $ds9(panner) <Enter> [list focus $ds9(panner)]
    bind $ds9(panner) <Leave> [list focus {}]

    # freeze
    bind $ds9(panner) <f> {ToggleFreeze}
}

proc FreezePanner {} {
    UnBindEventsPanner
}

proc UnFreezePanner {} {
    BindEventsPanner
}

proc BindEventsPanner {} {
    global ds9

    $ds9(panner) bind panner <Enter> [list EnterPanner %x %y]
    $ds9(panner) bind panner <Leave> [list LeavePanner]
    $ds9(panner) bind panner <Motion> [list MotionPanner %x %y]
    $ds9(panner) bind panner <Button-1> [list Button1Panner %x %y]
    $ds9(panner) bind panner <B1-Motion> [list Motion1Panner %x %y]
    $ds9(panner) bind panner <ButtonRelease-1> [list Release1Panner %x %y]
    $ds9(panner) bind panner <ButtonRelease-2> [list Release2Panner %x %y]

    $ds9(panner) bind panner <Up> [list ArrowKeyPanner 0 -1]
    $ds9(panner) bind panner <Down> [list ArrowKeyPanner 0 1]
    $ds9(panner) bind panner <Left> [list ArrowKeyPanner -1 0]
    $ds9(panner) bind panner <Right> [list ArrowKeyPanner 1 0]
}

proc UnBindEventsPanner {} {
    global ds9

    $ds9(panner) bind panner <Enter> {}
    $ds9(panner) bind panner <Leave> {}
    $ds9(panner) bind panner <Motion> {}
    $ds9(panner) bind panner <Button-1> {}
    $ds9(panner) bind panner <B1-Motion> {}
    $ds9(panner) bind panner <ButtonRelease-1> {}
    $ds9(panner) bind panner <ButtonRelease-2> {}

    $ds9(panner) bind panner <Up> {}
    $ds9(panner) bind panner <Down> {}
    $ds9(panner) bind panner <Left> {}
    $ds9(panner) bind panner <Right> {}
}

proc EnterPanner {x y} {
    global ds9
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "EnterPanner"
    }

    focus $ds9(panner)
    $ds9(panner) focus panner

    if {$current(frame) != {}} {
	EnterInfoBox $current(frame) $x $y panner
	UpdatePixelTable $current(frame) $x $y panner
	UpdateGraph $current(frame) $x $y panner
    }
}

proc LeavePanner {} {
    global ds9

    global debug
    if {$debug(tcl,events)} {
	puts "LeavePanner"
    }

    panner highlite off
    $ds9(panner) focus {}
    focus {}

    LeaveInfoBox
    ClearPixelTable
    ClearGraphData
}

proc MotionPanner {x y} {
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "MotionPanner"
    }

    panner highlite $x $y
    if {$current(frame) != ""} {
	MotionInfoBox $current(frame) $x $y panner
	UpdatePixelTable $current(frame) $x $y panner
	UpdateGraph $current(frame) $x $y panner
    }
}

proc Button1Panner {x y} {
    global ds9

    global debug
    if {$debug(tcl,events)} {
	puts "Button1Panner"
    }

    panner pan begin $x $y
}

proc Motion1Panner {x y} {
    global ds9

    global debug
    if {$debug(tcl,events)} {
	puts "Motion1Panner"
    }

    panner pan motion $x $y
}

proc Release1Panner {x y} {
    global ds9
    global current

    global debug
    if {$debug(tcl,events)} {
	puts "Release1Panner"
    }

    if {$current(frame) != ""} {
	SetWatchCursor
	panner pan end $x $y
	$current(frame) pan bbox [panner get bbox]
	UpdateGraphXAxis
	UpdatePanZoomDialog
	UnsetWatchCursor
    }
}

proc Release2Panner {x y} {
    global ds9
    global current

    if {$current(frame) != ""} {
	SetWatchCursor
	panner pan to $x $y
	$current(frame) pan bbox [panner get bbox]
	UpdateGraphXAxis
	UpdatePanZoomDialog
	UnsetWatchCursor
    }
}

proc ArrowKeyPanner {x y} {
    panner warp $x $y
}

proc ChangeImageCompass {} {
    global panner
    
    panner image compass $panner(compass,image)
}

proc ChangeWCSCompass {} {
    global ds9
    global panner

    panner wcs compass $panner(compass,wcs)
    foreach f $ds9(frames) {
	$f panner wcs $panner(compass,wcs,system) $panner(compass,wcs,sky)
    }
}
