#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ButtonButton {button text cmd} {
    button $button \
	-text $text \
	-command $cmd \
	-takefocus 0 \
	-bd 1 \
	-height 1 \
	-padx 2 -pady 2

    pack $button -side left -fill x -expand true
}

proc RadioButton {button text var value cmd} {
    radiobutton $button \
	-text $text \
	-variable $var \
	-value $value \
	-command $cmd \
	-indicatoron false \
	-selectcolor "" \
	-takefocus 0 \
	-bd 1 \
	-height 1 \
	-padx 2 -pady 3

    pack $button -side left -fill x -expand true
}

proc CheckButton {button text var cmd} {
    checkbutton $button \
	-text $text \
	-variable $var \
	-command $cmd \
	-indicatoron false \
	-selectcolor "" \
	-takefocus 0 \
	-bd 1 \
	-height 1 \
	-padx 2 -pady 3

    pack $button -side left -fill x -expand true
}

proc CreateButtons {} {
    global ds9
    global buttons

    set ds9(buttons) [frame $ds9(main).buttons]

    # Major buttons

    frame $ds9(buttons).major
    pack $ds9(buttons).major -side top -fill x -expand true

    RadioButton $ds9(buttons).major.file $buttons(file) \
	buttons(majorCurrent) $ds9(buttons).file MajorButton
    RadioButton $ds9(buttons).major.edit $buttons(edit) \
	buttons(majorCurrent) $ds9(buttons).edit MajorButton
    RadioButton $ds9(buttons).major.view $buttons(view) \
	buttons(majorCurrent) $ds9(buttons).view MajorButton
    RadioButton $ds9(buttons).major.frame $buttons(frame) \
	buttons(majorCurrent) $ds9(buttons).frame MajorButton
    RadioButton $ds9(buttons).major.bin $buttons(bin) \
	buttons(majorCurrent) $ds9(buttons).bin MajorButton
    RadioButton $ds9(buttons).major.zoom $buttons(zoom) \
	buttons(majorCurrent) $ds9(buttons).zoom MajorButton
    RadioButton $ds9(buttons).major.scale $buttons(scale) \
	buttons(majorCurrent) $ds9(buttons).scale MajorButton
    RadioButton $ds9(buttons).major.color1 $buttons(color) \
	buttons(majorCurrent) $ds9(buttons).color1 MajorButton
    RadioButton $ds9(buttons).major.region $buttons(region) \
	buttons(majorCurrent) $ds9(buttons).region1 MajorButton
    RadioButton $ds9(buttons).major.wcs1 $buttons(wcs) \
	buttons(majorCurrent) $ds9(buttons).wcs1 MajorButton

    FileButtons
    EditButtons
    ViewButtons
    FrameButtons
    BinButtons
    ZoomButtons
    ScaleButtons
    ColorButtons
    RegionButtons
    WCSButtons

    set buttons(majorPrev) ""
    set buttons(majorCurrent) $ds9(buttons).file
    MajorButton
}

proc MajorButton {} {
    global buttons

    pack forget $buttons(majorPrev)
    pack $buttons(majorCurrent) -side top -fill x -expand true
    set buttons(majorPrev) $buttons(majorCurrent)
}

proc FileButtons {} {
    global ds9
    global buttons

    frame $ds9(buttons).file

    ButtonButton $ds9(buttons).file.about $buttons(file,about) AboutBox
    ButtonButton $ds9(buttons).file.open $buttons(file,open) OpenFits
    ButtonButton $ds9(buttons).file.saveimage $buttons(file,saveimage) \
	SaveImageDialog
    ButtonButton $ds9(buttons).file.savefits $buttons(file,savefits) \
	SaveFitsDialog
    ButtonButton $ds9(buttons).file.savempeg $buttons(file,savempeg) \
	SaveMPEGDialog
    ButtonButton $ds9(buttons).file.header $buttons(file,header) \
	DisplayHeaderMenu
    ButtonButton $ds9(buttons).file.src $buttons(file,source) OpenSource
    ButtonButton $ds9(buttons).file.print $buttons(file,print) Print
    ButtonButton $ds9(buttons).file.page $buttons(file,page) PageSetupDialog
    ButtonButton $ds9(buttons).file.exit $buttons(file,exit) QuitDS9
}

proc ViewButtons {} {
    global ds9
    global buttons
    global view

    frame $ds9(buttons).view
    CheckButton $ds9(buttons).view.info "info" view(info) UpdateView
    CheckButton $ds9(buttons).view.panner "panner" view(panner) UpdateView
    CheckButton $ds9(buttons).view.magnifier "magnifier" view(magnifier) UpdateView
    CheckButton $ds9(buttons).view.buttons "buttons" view(buttons) UpdateView
    CheckButton $ds9(buttons).view.colorbar "colorbar" view(colorbar,next) UpdateView
    CheckButton $ds9(buttons).view.graphhorz "horizontal graph" view(graph,horz) UpdateView
    CheckButton $ds9(buttons).view.graphvert "vertical graph" view(graph,vert) UpdateView
}

proc EditButtons {} {
    global ds9
    global buttons

    frame $ds9(buttons).edit
    ButtonButton $ds9(buttons).edit.undo $buttons(edit,undo) UndoFrame
    ButtonButton $ds9(buttons).edit.cut $buttons(edit,cut) CutFrame
    ButtonButton $ds9(buttons).edit.copy $buttons(edit,copy) CopyFrame
    ButtonButton $ds9(buttons).edit.paste $buttons(edit,paste) PasteFrame
    RadioButton $ds9(buttons).edit.default $buttons(edit,default) \
	ds9(mode) none ChangeMode
    RadioButton $ds9(buttons).edit.pointer $buttons(edit,pointer) \
	ds9(mode) pointer ChangeMode
    RadioButton $ds9(buttons).edit.crosshair $buttons(edit,crosshair) \
	ds9(mode) crosshair ChangeMode
    RadioButton $ds9(buttons).edit.colorbar $buttons(edit,colorbar) \
	ds9(mode) colorbar ChangeMode
    RadioButton $ds9(buttons).edit.pan $buttons(edit,pan) \
	ds9(mode) pan ChangeMode
    RadioButton $ds9(buttons).edit.zoom $buttons(edit,zoom) \
	ds9(mode) zoom ChangeMode
    RadioButton $ds9(buttons).edit.rotate $buttons(edit,rotate) \
	ds9(mode) rotate ChangeMode
    RadioButton $ds9(buttons).edit.catalog $buttons(edit,catalog) \
	ds9(mode) catalog ChangeMode
    RadioButton $ds9(buttons).edit.examine $buttons(edit,examine) \
	ds9(mode) examine ChangeMode
}

proc FrameButtons {} {
    global ds9
    global buttons

    frame $ds9(buttons).frame
    ButtonButton $ds9(buttons).frame.new $buttons(frame,new) CreateFrame
    ButtonButton $ds9(buttons).frame.newrgb $buttons(frame,newrgb) \
	CreateRGBFrame
    ButtonButton $ds9(buttons).frame.delete $buttons(frame,delete) \
	DeleteFrameMenu
    ButtonButton $ds9(buttons).frame.deleteall $buttons(frame,deleteall) \
	DeleteAllFramesMenu
    ButtonButton $ds9(buttons).frame.clear $buttons(frame,clear) \
	ClearCurrentFrame
    ButtonButton $ds9(buttons).frame.reset $buttons(frame,reset) \
	ResetCurrentFrame
    RadioButton $ds9(buttons).frame.single $buttons(frame,single) \
	ds9(display,user) single DisplayMode
    RadioButton $ds9(buttons).frame.tile $buttons(frame,tile) \
	ds9(display,user) tile DisplayMode
    RadioButton $ds9(buttons).frame.blink $buttons(frame,blink) \
	ds9(display,user) blink DisplayMode
    ButtonButton $ds9(buttons).frame.first $buttons(frame,first) FirstFrame
    ButtonButton $ds9(buttons).frame.prev $buttons(frame,prev) PrevFrame
    ButtonButton $ds9(buttons).frame.next $buttons(frame,next) NextFrame
    ButtonButton $ds9(buttons).frame.last $buttons(frame,last) LastFrame
}

proc BinButtons {} {
    global ds9
    global buttons

    frame $ds9(buttons).bin
    ButtonButton $ds9(buttons).bin.in $buttons(bin,in) "Bin .5 .5"
    ButtonButton $ds9(buttons).bin.out $buttons(bin,out) "Bin 2 2"
    RadioButton $ds9(buttons).bin.b1 $buttons(bin,block1) \
	bin(factor) { 1 1 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b2 $buttons(bin,block2) \
	bin(factor) { 2 2 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b4 $buttons(bin,block4) \
	bin(factor) { 4 4 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b8 $buttons(bin,block8) \
	bin(factor) { 8 8 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b16 $buttons(bin,block16) \
	bin(factor) { 16 16 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b32 $buttons(bin,block32) \
	bin(factor) { 32 32 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b64 $buttons(bin,block64) \
	bin(factor) { 64 64 } ChangeBinFactor
    RadioButton $ds9(buttons).bin.b128 $buttons(bin,block128) \
	bin(factor) { 128 128 } ChangeBinFactor
}

proc ZoomButtons {} {
    global ds9
    global buttons
    global wcs

    frame $ds9(buttons).zoom
    ButtonButton $ds9(buttons).zoom.center center CenterCurrentFrame
    CheckButton $ds9(buttons).zoom.align "align wcs" wcs(align) AlignWCSFrame
    ButtonButton $ds9(buttons).zoom.in in "Zoom 2 2"
    ButtonButton $ds9(buttons).zoom.out out "Zoom .5 .5"
    ButtonButton $ds9(buttons).zoom.fit "to fit" ZoomToFit
    RadioButton $ds9(buttons).zoom.none none current(orient) none ChangeOrient
    RadioButton $ds9(buttons).zoom.x x current(orient) x ChangeOrient
    RadioButton $ds9(buttons).zoom.y y current(orient) y ChangeOrient
    RadioButton $ds9(buttons).zoom.xy xy current(orient) xy ChangeOrient
}

proc ScaleButtons {} {
    global ds9
    global buttons
    global scale

    frame $ds9(buttons).scale
    RadioButton $ds9(buttons).scale.linear "linear" \
	scale(type) linear ChangeScale
    RadioButton $ds9(buttons).scale.log "log" \
	scale(type) log ChangeScale
    RadioButton $ds9(buttons).scale.squared "squared" \
	scale(type) squared ChangeScale
    RadioButton $ds9(buttons).scale.sqrt "sqrt" \
	scale(type) sqrt ChangeScale
    RadioButton $ds9(buttons).scale.histogram "hist equ" \
	scale(type) histequ ChangeScale
    RadioButton $ds9(buttons).scale.minmax "minmax" \
	scale(mode) minmax ChangeScaleMode
    RadioButton $ds9(buttons).scale.minmax1 "99.5%" \
	scale(mode) 99.5 ChangeScaleMode
    RadioButton $ds9(buttons).scale.minmax2 "99%" \
	scale(mode) 99 ChangeScaleMode
    RadioButton $ds9(buttons).scale.minmax3 "98%" \
	scale(mode) 98 ChangeScaleMode
    RadioButton $ds9(buttons).scale.minmax4 "95%" \
	scale(mode) 95 ChangeScaleMode
    RadioButton $ds9(buttons).scale.minmax5 "90%" \
	scale(mode) 90 ChangeScaleMode
    RadioButton $ds9(buttons).scale.zscale "zscale" \
	scale(mode) zscale ChangeScaleMode
    RadioButton $ds9(buttons).scale.user "user" \
	scale(mode) user ChangeScaleMode
}

proc ColorButtons {} {
    global ds9
    global buttons
    global colorbar

    set ids [colorbar list id]

    frame $ds9(buttons).color1
    for {set i 0} {$i<9} {incr i} {
	set id [lindex $ids $i]
	set title [colorbar get name $id]
	set name [string tolower $title]
	RadioButton $ds9(buttons).color1.$i $name \
	    colorbar(map) $title "ChangeColormapID $id"
    }
    RadioButton $ds9(buttons).color1.more "more..." buttons(majorCurrent) \
	$ds9(buttons).color2 MajorButton

    frame $ds9(buttons).color2
    for {set i 9} {$i<18} {incr i} {
	set id [lindex $ids $i]
	set title [colorbar get name $id]
	set name [string tolower $title]
	RadioButton $ds9(buttons).color2.$i $name \
	    colorbar(map) $title "ChangeColormapID $id"
    }
    RadioButton $ds9(buttons).color2.more "more..." buttons(majorCurrent) \
	$ds9(buttons).color3 MajorButton

    frame $ds9(buttons).color3
    CheckButton $ds9(buttons).color3.invert invert \
	colorbar(invert) InvertColorbar
    ButtonButton $ds9(buttons).color3.reset reset ResetColormap
    RadioButton $ds9(buttons).color3.more "more..." buttons(majorCurrent) \
	$ds9(buttons).color1 MajorButton
}

proc RegionButtons {} {
    global ds9
    global buttons

    frame $ds9(buttons).region1
    ButtonButton $ds9(buttons).region1.info info MarkerInfo
    ButtonButton $ds9(buttons).region1.front front MarkerFront
    ButtonButton $ds9(buttons).region1.back back MarkerBack
    ButtonButton $ds9(buttons).region1.all all MarkerSelectAll
    ButtonButton $ds9(buttons).region1.none none MarkerUnselectAll
    ButtonButton $ds9(buttons).region1.invert invert MarkerSelectInvert
    ButtonButton $ds9(buttons).region1.delete del MarkerDeleteSelect
    ButtonButton $ds9(buttons).region1.deleteall {del all} MarkerDeleteAllMenu
    ButtonButton $ds9(buttons).region1.newgrp newgrp GroupCreate
    ButtonButton $ds9(buttons).region1.grps grps GroupDialog
    ButtonButton $ds9(buttons).region1.list list MarkerDisplay
    ButtonButton $ds9(buttons).region1.load load MarkerOpen
    ButtonButton $ds9(buttons).region1.save save MarkerSave
    RadioButton $ds9(buttons).region1.more "more..." buttons(majorCurrent) \
	$ds9(buttons).region2 MajorButton
    
    frame $ds9(buttons).region2
    RadioButton $ds9(buttons).region2.circle circle marker(shape) circle ""
    RadioButton $ds9(buttons).region2.ellipse ellipse marker(shape) ellipse ""
    RadioButton $ds9(buttons).region2.box box marker(shape) box ""
    RadioButton $ds9(buttons).region2.polygon poly marker(shape) polygon ""
    RadioButton $ds9(buttons).region2.line line marker(shape) line ""
    RadioButton $ds9(buttons).region2.vector vector marker(shape) vector ""
    RadioButton $ds9(buttons).region2.text text marker(shape) text ""
    RadioButton $ds9(buttons).region2.ruler ruler marker(shape) ruler ""
    RadioButton $ds9(buttons).region2.compass compass marker(shape) compass ""
    RadioButton $ds9(buttons).region2.projection proj \
	marker(shape) projection ""
    RadioButton $ds9(buttons).region2.point point \
	marker(shape) "circle point" ""
    RadioButton $ds9(buttons).region2.more "more..." buttons(majorCurrent) \
	$ds9(buttons).region3 MajorButton

    frame $ds9(buttons).region3
    RadioButton $ds9(buttons).region3.annulus annulus marker(shape) annulus ""
    RadioButton $ds9(buttons).region3.ellispsannulus "ellipse annulus" \
	marker(shape) ellipseannulus ""
    RadioButton $ds9(buttons).region3.boxannulus "box annulus" \
	marker(shape) boxannulus ""
    RadioButton $ds9(buttons).region3.panda panda marker(shape) panda ""
    RadioButton $ds9(buttons).region3.epanda epanda marker(shape) epanda ""
    RadioButton $ds9(buttons).region3.bpanda bpanda marker(shape) bpanda ""
    RadioButton $ds9(buttons).region3.more "more..." buttons(majorCurrent) \
	$ds9(buttons).region4 MajorButton

    frame $ds9(buttons).region4
    RadioButton $ds9(buttons).region4.ds9 ds9 marker(format) ds9 ""
    RadioButton $ds9(buttons).region4.ciao ciao marker(format) ciao ""
    RadioButton $ds9(buttons).region4.saotng saotng marker(format) saotng ""
    RadioButton $ds9(buttons).region4.saoimage saoimage marker(format) saoimage ""
    RadioButton $ds9(buttons).region4.pros pros marker(format) pros ""
    RadioButton $ds9(buttons).region4.xy xy marker(format) xy ""
    RadioButton $ds9(buttons).region4.more "more..." buttons(majorCurrent) \
	$ds9(buttons).region5 MajorButton

    frame $ds9(buttons).region5
    RadioButton $ds9(buttons).region5.wcs wcs marker(system) wcs ""
    RadioButton $ds9(buttons).region5.physical physical marker(system) physical ""
    RadioButton $ds9(buttons).region5.image image marker(system) image ""
    RadioButton $ds9(buttons).region5.fk4 fk4 marker(sky) fk4 ""
    RadioButton $ds9(buttons).region5.fk5 fk5 marker(sky) fk5 ""
    RadioButton $ds9(buttons).region5.icrs icrs marker(sky) icrs ""
    RadioButton $ds9(buttons).region5.galactic galactic marker(sky) galactic ""
    RadioButton $ds9(buttons).region5.ecliptic ecliptic marker(sky) ecliptic ""
    RadioButton $ds9(buttons).region5.more "more..." buttons(majorCurrent) \
	$ds9(buttons).region1 MajorButton
}

proc WCSButtons {} {
    global ds9
    global buttons
    global wcs

    frame $ds9(buttons).wcs1
    RadioButton $ds9(buttons).wcs1.fk4 fk4 wcs(sky) fk4 UpdateWCS
    RadioButton $ds9(buttons).wcs1.fk5 fk5 wcs(sky) fk5 UpdateWCS
    RadioButton $ds9(buttons).wcs1.icrs icrs wcs(sky) icrs UpdateWCS
    RadioButton $ds9(buttons).wcs1.galactic galactic wcs(sky) galactic \
	UpdateWCS
    RadioButton $ds9(buttons).wcs1.ecliptic ecliptic wcs(sky) ecliptic \
	UpdateWCS
    RadioButton $ds9(buttons).wcs1.degrees deg wcs(skyformat) degrees \
	UpdateWCS
    RadioButton $ds9(buttons).wcs1.sexagesimal sexagesimal wcs(skyformat) \
	sexagesimal UpdateWCS
    RadioButton $ds9(buttons).wcs1.more "more..." buttons(majorCurrent) \
	$ds9(buttons).wcs2 MajorButton

    frame $ds9(buttons).wcs2
    RadioButton $ds9(buttons).wcs2.wcs WCS wcs(system) wcs UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsA WCSA wcs(system) wcsA UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsB WCSB wcs(system) wcsB UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsC WCSC wcs(system) wcsC UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsD WCSD wcs(system) wcsD UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsE WCSE wcs(system) wcsE UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsF WCSF wcs(system) wcsF UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsG WCSG wcs(system) wcsG UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsH WCSH wcs(system) wcsH UpdateWCS
    RadioButton $ds9(buttons).wcs2.wcsI WCSI wcs(system) wcsI UpdateWCS
    RadioButton $ds9(buttons).wcs2.more "more..." buttons(majorCurrent) \
	$ds9(buttons).wcs3 MajorButton

    frame $ds9(buttons).wcs3
    RadioButton $ds9(buttons).wcs3.wcsJ WCSJ wcs(system) wcsJ UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsK WCSK wcs(system) wcsK UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsL WCSL wcs(system) wcsL UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsM WCSM wcs(system) wcsM UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsN WCSN wcs(system) wcsN UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsO WCSO wcs(system) wcsO UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsP WCSP wcs(system) wcsP UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsQ WCSQ wcs(system) wcsQ UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsR WCSR wcs(system) wcsR UpdateWCS
    RadioButton $ds9(buttons).wcs3.wcsS WCSS wcs(system) wcsS UpdateWCS
    RadioButton $ds9(buttons).wcs3.more "more..." buttons(majorCurrent) \
	$ds9(buttons).wcs4 MajorButton

    frame $ds9(buttons).wcs4
    RadioButton $ds9(buttons).wcs4.wcsT WCST wcs(system) wcsT UpdateWCS
    RadioButton $ds9(buttons).wcs4.wcsU WCSU wcs(system) wcsU UpdateWCS
    RadioButton $ds9(buttons).wcs4.wcsV WCSV wcs(system) wcsV UpdateWCS
    RadioButton $ds9(buttons).wcs4.wcsW WCSW wcs(system) wcsW UpdateWCS
    RadioButton $ds9(buttons).wcs4.wcsX WCSX wcs(system) wcsX UpdateWCS
    RadioButton $ds9(buttons).wcs4.wcsY WCSY wcs(system) wcsY UpdateWCS
    RadioButton $ds9(buttons).wcs4.wcsZ WCSZ wcs(system) wcsZ UpdateWCS
    RadioButton $ds9(buttons).wcs4.more "more..." buttons(majorCurrent) \
	$ds9(buttons).wcs1 MajorButton
}
