/* winutil.c - window/dialog related helper functions
 *
 * Copyright (C) 2002  Jochen Voss.  */

static const  char  rcsid[] = "$Id: winutil.c,v 1.1 2002/02/22 19:03:21 voss Rel $";

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "sandcommon.h"


/**********************************************************************
 * callback functions
 */

void
window_show_cb (GtkObject *obj, gpointer data)
/* A wrapper for 'main_loop_ref'.
 * This may be used as a "show" signal handler.  */
{
  main_loop_ref ();
}

void
window_destroy_cb (GtkObject *obj, gpointer data)
/* A wrapper for 'main_loop_unref'.
 * This may be used as a "destroy" signal handler.  */
{
  main_loop_unref ();
}

gint
window_close_cb (GtkObject *obj, gpointer data)
/* A wrapper for 'main_loop_unref'.
 * This may be used as a "close" signal handler
 * for GnomeDialog objects.  */
{
  main_loop_unref ();
  return  0;
}

/**********************************************************************
 * dialog helpers
 */

void
display_error_message (const char *str, GtkWindow *parent)
/* Create a modal dialog to display the error message STR.
 * If PARENT is non-null, create a parented dialog.  */
{
  GtkWidget *dialog;
  
  if (parent) {
    dialog = gnome_error_dialog_parented (str, parent);
  } else {
    dialog = gnome_error_dialog (str);
  }
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

  main_loop_ref ();
  gtk_signal_connect (GTK_OBJECT (dialog),
		      "close",
		      GTK_SIGNAL_FUNC (window_close_cb),
		      NULL);
  gtk_widget_show (dialog);
  gdk_beep ();
}

gint
ask_yes_no_question (const char *str, GtkWindow *parent)
/* Display a modal dialog with question STR.
 * Return 0, if the user clicks YES,
 *        1, if the user clicks NO, and
 *       -1, if the user closes the dialog.  */
{
  GtkWidget *dialog;

  dialog = gnome_message_box_new (str, GNOME_MESSAGE_BOX_QUESTION,
				  GNOME_STOCK_BUTTON_YES,
				  GNOME_STOCK_BUTTON_NO,
				  NULL);
  if (parent)  gnome_dialog_set_parent (GNOME_DIALOG(dialog), parent);
  gtk_widget_show_all (dialog);
  return  gnome_dialog_run (GNOME_DIALOG (dialog));
}
