/*--------------------------------*-C-*---------------------------------*
 * File:	scrollbar.c
 *----------------------------------------------------------------------*
 * $Id: scrollbar.c,v 1.41 2001/07/27 06:38:37 gcw Exp $
 *
 * Copyright (c) 1997,1998 mj olesen <olesen@me.QueensU.CA>
 * Copyright (c) 1998      Alfredo K. Kojima <kojima@windowmaker.org>
 *				- N*XTstep like scrollbars
 * Copyright (c) 1999-2001 Geoff Wing <gcw@pobox.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------*/

#include "../config.h"		/* NECESSARY */
#include "rxvt.h"		/* NECESSARY */
#include "scrollbar.intpro"	/* PROTOS for internal routines */

/*----------------------------------------------------------------------*/

/* EXTPROTO */
int
rxvt_scrollbar_mapping(rxvt_t *r, int map)
{
    int             change = 0;
#ifdef HAVE_SCROLLBARS

    if (map && !scrollbar_visible(r)) {
	scrollbar_setNone();
	if (r->scrollBar.win) {
	    XMapWindow(r->Xdisplay, r->scrollBar.win);
	    change = 1;
	}
    } else if (!map && scrollbar_visible(r)) {
	r->scrollBar.state = 0;
	XUnmapWindow(r->Xdisplay, r->scrollBar.win);
	change = 1;
    }
#endif
    return change;
}

/* EXTPROTO */
void
rxvt_map_scrollBar(rxvt_t *r, int map)
{
#ifdef HAVE_SCROLLBARS
    if (rxvt_scrollbar_mapping(r, map)) {
	rxvt_resize_all_windows(r, 0, 0, 0);
	rxvt_scr_touch(r, True);
    }
#endif
}

/* EXTPROTO */
void
rxvt_Resize_scrollBar(rxvt_t *r)
{
#ifdef HAVE_SCROLLBARS

#define R_SCROLLBEG_XTERM	0
#define R_SCROLLEND_XTERM	r->szHint.height
#define R_SCROLLBEG_NEXT	0
#define R_SCROLLEND_NEXT	r->szHint.height - (SB_BUTTON_TOTAL_HEIGHT + \
						    SB_PADDING)
#define R_SCROLLBEG_RXVT	(SB_WIDTH_RXVT + 1) + r->sb_shadow
#define R_SCROLLEND_RXVT	r->szHint.height - R_SCROLLBEG_RXVT - \
				    (2 * r->sb_shadow)

#if defined(XTERM_SCROLLBAR)
    if (r->scrollBar.style == R_SB_XTERM) {
	r->scrollBar.beg = R_SCROLLBEG_XTERM;
	r->scrollBar.end = R_SCROLLEND_XTERM;
	r->scrollBar.update = rxvt_scrollbar_show_xterm;
    }
#endif
#if defined(NEXT_SCROLLBAR)
    if (r->scrollBar.style == R_SB_NEXT) {
	r->scrollBar.beg = R_SCROLLBEG_NEXT;
	r->scrollBar.end = R_SCROLLEND_NEXT;
	r->scrollBar.update = rxvt_scrollbar_show_next;
    }
#endif
#if defined(RXVT_SCROLLBAR)
    if (r->scrollBar.style == R_SB_RXVT) {
	r->scrollBar.beg = R_SCROLLBEG_RXVT;
	r->scrollBar.end = R_SCROLLEND_RXVT;
	r->scrollBar.update = rxvt_scrollbar_show_rxvt;
    }
#endif
    rxvt_scrollbar_show(r, 1);
#endif
}

/* EXTPROTO */
int
rxvt_scrollbar_show(rxvt_t *r, int update)
{
    int             ret = 0;
#ifdef HAVE_SCROLLBARS
    int             top, bot, len, adj;

    if (!scrollbar_visible(r))
	return 0;

    if (update) {
	top = (r->TermWin.nscrolled - r->TermWin.view_start);
	bot = top + (r->TermWin.nrow - 1);
	len = max((r->TermWin.nscrolled + (r->TermWin.nrow - 1)), 1);
	adj = (((bot - top) * scrollbar_size()) % len) > 0 ? 1 : 0;

	r->scrollBar.top = (r->scrollBar.beg + (top * scrollbar_size()) / len);
	r->h->scrollbar_len = ((bot - top) * scrollbar_size()) / len +
			      scrollbar_minheight() + adj;
	r->scrollBar.bot = (r->scrollBar.top + r->h->scrollbar_len);
	/* no change */
	if (r->scrollBar.top == r->h->last_top
	    && r->scrollBar.bot == r->h->last_bot
	    && (r->scrollBar.state == r->h->last_state || !scrollbar_isUpDn()))
	    return 0;
    }

    ret = r->scrollBar.update(r, update, r->h->last_top, r->h->last_bot,
			      r->h->scrollbar_len);

    r->h->last_top = r->scrollBar.top;
    r->h->last_bot = r->scrollBar.bot;
    r->h->last_state = r->scrollBar.state;

#endif
    return ret;
}
/*----------------------- end-of-file (C source) -----------------------*/
