#include <rumba/baseManifold.h>
#include <rumba/manifoldFile.h>
#include <rumba/arghandler.h>
#include <rumba/util.hpp>
#include <rumba/parse.h>
#include <rumba/matrixio.h>
#include <iostream>
#include <cstdlib>
#include <algorithm>

using std::cout;
using std::endl;

using RUMBA::Argument;

Argument myArgs [] = {
	Argument ( "lower", RUMBA::NUMERIC, 'l', 0 ),
	Argument ("upper", RUMBA::NUMERIC, 'u', 0 ),
	Argument()
};

void help_message()
{	
	std::cerr << "Usage: volume-normalize\n"
	   	"[-i|--infile] infile [-o|--outfile] outfile\n"
		"[[--lower|-l] lower] (default: 0)\n"
		"[[--upper|-u] upper]  (default: 100)\n" << std::endl;
}



int main(int argc, char** argv)
{
	RUMBA::ArgHandler::setRequiredDefaultArg("infile");
	RUMBA::ArgHandler::setRequiredDefaultArg("outfile");
	bool help;
	double tmp1,tmp2;
	double lower = 0, upper = 100;
	try 
	{
		RUMBA::ArgHandler argh(argc,argv,myArgs);
		std::string infile, outfile;

		help = argh.arg ("help");

		if ( help )
		{
			help_message();
			exit(0);
		}

		argh.arg("infile", infile );
		argh.arg("outfile", outfile );
		argh.arg("lower",lower);
		argh.arg("upper",upper );
//		argh.arg("savestats",savestats);


	
		RUMBA::ManifoldFile* inManifold;
		RUMBA::BaseManifold* volume;
		RUMBA::ManifoldFile* outManifold;


		RUMBA::Manifold<double> stats;

		inManifold= RUMBA::ManifoldFile::construct(infile.c_str());
		if (!inManifold)
		{
			cout << "Fatal: can't identify file type" << endl;
			exit (1);
		}

		outManifold = RUMBA::ManifoldFile::construct ( outfile, std::ios::out, inManifold );

		for ( int i = 0; i < inManifold->timepoints(); ++i )
		{
			volume = inManifold->get 
				( 
					RUMBA::intPoint(0,0,0,i),
					RUMBA::intPoint(
						inManifold->width(),
						inManifold->height(),
						inManifold->depth(),
						1
					)
				);
			
			RUMBA::normalize ( lower, upper, volume );
			outManifold->put ( volume, RUMBA::intPoint(0,0,0,i));

			delete volume;
		}

		delete inManifold;
		delete outManifold;

	}

    catch (RUMBA::MissingArgumentException& s)
    {
		cout << "Error, missing required argument: " << s.error() << endl;
		help_message();
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cout << "Duplicate argument: " << s.error() << endl;
		help_message();
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cout << "Error: " << s.error() << endl;
		help_message();
	}
	catch ( RUMBA::Exception & e)
	{
		cout << "Fatal exception " << e.error() << endl;	
	}

	return 0;
}
