#include <gauss.h>
#include <cmath>
using namespace std;


const double Gauss::PI=4*atan(1);
const double Gauss::div_sqrt2pi = 1/std::sqrt(2.0* (4.0*std::atan(1.0)) );	



double Gauss::gauss(double x)
{
	return exp(-x*x/2)*div_sqrt2pi;
}


double Gauss::integral_gauss(double x)
{
	// outside this range, the accuracy falls apart pretty quickly
	if (x>5.5) return 0.5;
	if (x<-5.5) return -0.5;

	const double epsilon = 1e-15;
	const double div_sqrt2pi = 1/std::sqrt(2.0* (4.0*std::atan(1.0)) );	
	int n = 0;
	double sum = 0;
	double t = x;
	while ( fabs(t) > epsilon )
	{
		sum += t;
		++n;
		t *= ( -x*x * (2*n-1) / ( 2*n* (2*n+1 ) ) ); 
	}
	return sum * div_sqrt2pi;
}



