#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/parse.h>
#include <rumba/loadVols.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrix.hpp>
#include <rumba/matrixio.h>

#include "iohack.h"

using namespace RUMBA;

void usage()
{
	cerr << "Usage: matrix-multiply -i infile1 infile2 -o outfile\n";
}

/********** If we had special args, here would be the place for them...
Argument myArgs [] = {
	Argument()
};
*********** But we don't...*******************************************/

int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setMultiDefaultArg("infile");
	vector<Splodge> v;	
	std::string outfile , sortMethod;
	void ( *theSortFunction ) ( vector<string> & );

	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		v =  argh.multiarg( "infile" );
		argh.arg ( "outfile" , outfile );

		theSortFunction = doNothing;
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		cout << "Invalid argument: " << s.error() << endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cout << "Duplicate argument: " << s.error() << endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cout << "Error: " << s.error() << endl;
	}
	catch (Exception& s)
	{
		cout << "Exception:" << s.error() << endl;
	}

// main loop for matrix multiplication


	ManifoldMatrix product = readHack( v.front().asString() );
	writeManifoldMatrix(product,std::cout);
	for ( vector<Splodge>::iterator it = v.begin()+1; it != v.end() ; ++it ) 
	{
	writeManifoldMatrix(readHack( it->asString() ),std::cout);

	product =  product * readHack( it->asString() ) ;


		writeManifoldMatrix ( product , std::cout );
	}

//	ManifoldMatrix product ( readHack( v[0].asString()) * readHack(v[1].asString()))    ;

	cout << "***" << endl;
	writeHack( product , outfile.c_str() );
	cout << "***" << endl;

}
