#include "t_dist.h"
#include <iostream>
#include <cmath>


using namespace RUMBA;
using namespace std;

int COUNT = 0;
int PASS = 0;
int FAIL = 0;

double point_8[20] = 
{ 
	3.078, 1.886, 1.638, 1.533, 1.476, 1.440, 1.415, 1.397, 1.383, 1.372,
	1.363, 1.356, 1.350, 1.345, 1.341, 1.337, 1.333, 1.330, 1.328, 1.325
};

double point_9[20] = 
{
	6.314, 2.920, 2.353, 2.132, 2.015, 1.943, 1.895, 1.860, 1.833, 1.812,
	1.796, 1.782, 1.771, 1.761, 1.753, 1.746, 1.740, 1.734, 1.729, 1.725
};	

void test_ttest(double* x, double p)
{
	bool ok=true;
	for ( int i = 1; i <= 20; ++i )
	{
		if ( fabs ( t_to_p ( x[i-1], i )  - p ) > 1e-3 ) 
		{
			cerr <<   "t(" << x[i-1] << "," << i << ") :  FAIL" << endl;
			ok=false;
		}
		++COUNT;
		if (ok) 
			++ PASS; 
		else 
			++FAIL;
	}
}

int main()
{
	test_ttest(point_8,0.8);
	test_ttest(point_9,0.9);

	std::cout << "t test: " << COUNT << " passed " << PASS << " failed: " 
		<< FAIL << std::endl;

}




