#include <iostream>
#include <vector>
#include <list>
#include <map>

#include <rumba/arghandler.h>
#include <rumba/exception.h>
#include <rumba/manifoldFile.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: log-transform -i infile -o outfile\n";
}

int main(int argc,char** argv)
{
	std::string infile , outfile;
	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );

		RUMBA::ManifoldFile* mf = RUMBA::ManifoldFile::construct(infile.c_str());
		if (!mf)
			throw RUMBA::Exception("Couldn't read data set");
		intPoint p = mf->extent();
		p.t()=1;

		for ( int i = 0; i < mf->timepoints(); ++i )
		{
			BaseManifold* M = mf->get ( intPoint(0,0,0,i), p );
			if ( !M ) throw RUMBA::Exception ("Could not read data set");
			for ( int j = 0; j < M->size(); ++j )
				M->setElementDouble ( j, M->getElementDouble(j));
			mf->put ( M, intPoint(0,0,0,i) );
			delete M;
		}
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Fatal exception:" << s.error() << std::endl;
	}

}
