#include "givens.h"

using namespace RUMBA;
Givens RUMBA::get_givens(double a, double b)
{
	double tau=0;
	double c=1,s=0;
	if ( b == 0 )
		return Givens(1,0);

	if ( fabs(b) > fabs(a) )
	{
		tau = -a/b;
		s = -1 / std::sqrt( 1 + tau * tau );
		c = tau * s;
	}
	else
	{
		tau = -b/a;
		c = 1 / std::sqrt( 1 + tau * tau );
		s = c * tau;
	}
	return Givens(c,s);
}

Givens RUMBA::get_givens2(double a, double b)
{
	return get_givens(-b,a);
}

void RUMBA::apply_left_givens
( 
 ManifoldMatrix& A, 
 unsigned int p, 
 unsigned int q, 
 double c, 
 double s
 )
{
	double tau1,tau2;
	for ( int j = 0; j < A.cols(); ++j )
	{
		tau1 = A.element(p,j);
		tau2 = A.element(q,j);
		A.element(p,j) = c*tau1 - s * tau2;
		A.element(q,j) = s*tau1 + c * tau2;
	}
}

void RUMBA::apply_left_givens(ManifoldMatrix& A, const Givens& g)
{
	apply_left_givens(A,g.row(),g.col(),g.c(),g.s());
}

void RUMBA::apply_right_givens
(
 ManifoldMatrix& A,
 unsigned int p,
 unsigned int q,
 double c,
 double s
 )
{
	double tau1, tau2;
	for (int j = 0; j < A.rows(); ++j )
	{
		tau1 = A.element(j,p);
		tau2 = A.element(j,q);
		A.element(j,p) = c*tau1 - s * tau2;
		A.element(j,q) = s * tau1 + c * tau2;
	}
}

void RUMBA::apply_right_givens(ManifoldMatrix& A, const Givens& g)
{
	apply_right_givens(A,g.row(),g.col(),g.c(),g.s());
}


// post-multiplies applies a list of givens transforms. Each transform
// goes on the right, ie  left * G1 * G2 * .....
void RUMBA::multiply 
( ManifoldMatrix& left, const std::list<Givens>& right , bool inv)
{
	if (inv)
		for (std::list<Givens>::const_reverse_iterator it = right.rbegin();
			it != right.rend(); ++it )
			apply_right_givens(left, it->inv());
	else
		for (std::list<Givens>::const_iterator it = right.begin();
			it != right.end(); ++it )
			apply_right_givens( left, *it );
}

// pre-multiplies applies a list of givens transforms. Each transform
// goes on the left, ie Gn * ... * G2 * G1 * right  
void RUMBA::multiply 
( const std::list<Givens>& left, ManifoldMatrix& right, bool inv)
{
	if (inv)
		for (std::list<Givens>::const_reverse_iterator it = left.rbegin();
			it != left.rend(); ++it )
			apply_left_givens ( right, it->inv() );
	else
		for (std::list<Givens>::const_iterator it = left.begin();
				it != left.end(); ++it )
			apply_left_givens ( right, *it );
}


