#include <siemens_iohandler.h>
#include <rumba/constants.h>
#include <rumba/iohandler.h>

#include <stdexcept>

using RUMBA::SiemensIOHandler;
using RUMBA::SIEMENS_HEADER_SIZE;

char SiemensIOHandler::find_orientation(char top, char back)
{
	if ( (top == 'A'  || top == 'P') && ( back == 'H' || back == 'F' ) )
		return '0';
	if ( (top == 'H'  || top == 'F') && ( back == 'A' || back == 'P' ) )
		return '1';
	if ( (top == 'H'  || top == 'F') && ( back == 'L' || back == 'R' ) )
		return '2';
	return '0';
}

int SiemensIOHandler::curpos ( int topLeft, int x, int y )
{
	return topLeft + x + (Width*y); 
}

/*
MaxMinFunctor<short> writeAnalyzeData (ifstream& in, ofstream& out)
{
	int imageTopLeft;
	MaxMinFunctor<short> f;
	for (int image=0;image<Depth;image++)
	{
		imageTopLeft = getTopLeft (image);
		for (int y = 0; y<Height; y++)
			for (int x = 0; x<Width; x++) {
				// need to multiply flatToMosaic() by 2 data are two bytes wide
				in.seekg( 2 * 
						flatToMosaic
						( 
						 curpos (imageTopLeft,x,y,Width ) )
						+ SIEMENS_HEADER_SIZE
						);
				short val = GetShort(in,INENDIAN);
				f(val); // register the value with the functor.
				PutShort ( out,val,OUTENDIAN );
			}
	}
	return(f);
}

*/

void SiemensIOHandler
::seekg(int x, std::ios::seekdir pos  )
{
#ifdef DEBUG
	log.logName() << "SiemensIOHandler: seekg:  request for " << x << "\n";
#endif
	int imageTopLeft;
//	int image = x / Depth;
	int image = x / ( Width * Height );
	int sz = Width * Height * Depth;
	if ( pos == std::ios::end )
		x = sz - x;
	else if ( pos != std::ios::beg )
		throw std::domain_error ("Stream position argument out of range");

	imageTopLeft = getTopLeft (image);
#ifdef DEBUG
	log.logName() << "imageTopLeft is: " << imageTopLeft << "\n";

	log.logName() << "Jumping to: " << 
//		( 2 * flatToMosaic(imageTopLeft + x%Depth) + SIEMENS_HEADER_SIZE) << endl;
		( 2 * flatToMosaic(imageTopLeft + x%(Width * Height)) + SIEMENS_HEADER_SIZE) << "\n";
#endif
	Stream.seekg 
//		( 2 * flatToMosaic(imageTopLeft + x%Depth) + SIEMENS_HEADER_SIZE);
		( 2 * flatToMosaic(imageTopLeft + x%(Width*Height)) + SIEMENS_HEADER_SIZE);

}

void SiemensIOHandler
::seekp(int x, std::ios::seekdir pos  )
{
	int imageTopLeft;
	int image = x / (Width * Height);
	int sz = Width * Height * Depth;
	if ( pos == std::ios::end )
		x = sz - x;
	else if ( pos != std::ios::beg )
		throw std::domain_error ("Stream position argument out of range");

	imageTopLeft = getTopLeft (image);
	Stream.seekp 
		( 2 * flatToMosaic(imageTopLeft + x%(Width*Height)) + SIEMENS_HEADER_SIZE);
}

int 
SiemensIOHandler
::getTopLeft (int image)
{
	int imageSize = Width * Height;
	switch (SliceOrder)
	{
		case 1: // ascending
			return ( ( image ) * imageSize );
			break; 
		case 2: // descending
			return ( ( Depth - (image + 1) ) * imageSize );	
			break;
		case 4: // interleaved
			return ( ( image%2 * ((Depth+1)/2) + image/2 ) * imageSize );
			break;
		default:
			throw RUMBA::Exception("SliceOrder not recognised in SiemensIOHandler");
	}
}


int 
SiemensIOHandler
::getTopRight (int image)
{
	return getTopLeft(image) + Width -1;
}

int 
SiemensIOHandler
::getBottomLeft (int image)
{
	return getTopLeft(image+1)-Width;
}

int 
SiemensIOHandler
::getBottomRight (int image)
{
	return getTopLeft(image + 1) -1;
}


int SiemensIOHandler::mosaicX ( int x, int z )
{
	return ( z % nTilesWide ) * Width + x;
}

int SiemensIOHandler::mosaicY ( int y, int z )
{
	return ( z / nTilesWide ) * Height + y;
}

int SiemensIOHandler::flatToMosaic (int n)
{
	// first get cartesian co-ords
	int x = n%Width;
	int y = (n/Width)%Height;
	int z = (n/(Width*Height))%Depth;

	// co-ordinates in mosaic terms
	int mx = mosaicX (x,z );
	int my = mosaicY (y,z );

	// now flatten them
	return mx + my*Width*nTilesWide;
}


