#ifndef RUMBA_NUMERICS_H
#define RUMBA_NUMERICS_H

/**  	\file numerics.h 
  * 	\brief a documented file 
  */



#include <vector>
#include <complex>

/**
  * The RUMBA namespace
  */
namespace RUMBA
{

/**
 * \fn double RUMBA::gamma_log(double t) 
 * Returns the natural log of the gamma function evaluated at t.
 * It turns out that this is more often used in implementing 
 * numerical computations than the gamma function
 */
double gamma_log(double t);

double gamma(double t);

//! gamma probability distribution function.
double incomplete_gamma ( double x, double a  ); 

//! in-place fft
void fft (std::vector<std::complex<double> >& v);


/** 
  * hrf function. scale1 and scale2 are inverse-stretch factors on X-axis,
  * shape1 and shape2 are the gamma function shape parameters, x is the
  * evaluation point
  */
double hrf ( double x, double scale1, double scale2, double shape1, double shape2 );


}
#endif
