module RSpec
  module Core
    class ProjectInitializer
      def initialize(arg=nil)
        @arg = arg
      end

      def run
        warn "The --configure option no longer needs any arguments, so #{@arg} was ignored." if @arg
        create_spec_helper_file
        create_dot_rspec_file
        delete_if_confirmed("autotest/discover.rb", <<-MESSAGE)
  RSpec registers its own discover.rb with Autotest, so autotest/discover.rb is
  no longer needed.
        MESSAGE

        delete_if_confirmed("lib/tasks/rspec.rake", <<-MESSAGE)
  If the file in lib/tasks/rspec.rake is the one generated by rspec-rails-1x,
  you can get rid of it, as it is no longer needed with rspec-2.
        MESSAGE
      end

      def create_dot_rspec_file
        if File.exist?('.rspec')
          report_exists('.rspec')
        else
          report_creating('.rspec')
          File.open('.rspec','w') do |f|
            f.write <<-CONTENT
--color
--format progress
CONTENT
          end
        end
      end

      def create_spec_helper_file
        if File.exist?('spec/spec_helper.rb')
          report_exists("spec/spec_helper.rb")
        else
          report_creating("spec/spec_helper.rb")
          FileUtils.mkdir_p('spec')
          File.open('spec/spec_helper.rb','w') do |f|
            f.write <<-CONTENT
# This file was generated by the `rspec --init` command. Conventionally, all
# specs live under a `spec` directory, which RSpec adds to the `$LOAD_PATH`.
# Require this file using `require "spec_helper.rb"` to ensure that it is only
# loaded once.
#
# See http://rubydoc.info/gems/rspec-core/RSpec/Core/Configuration
RSpec.configure do |config|
  config.treat_symbols_as_metadata_keys_with_true_values = true
  config.run_all_when_everything_filtered = true
  config.filter_run :focus
end
CONTENT
          end
        end
      end

      def delete_if_confirmed(path, message)
        if File.exist?(path)
          puts
          puts message
          puts
          puts "  delete   #{path}? [y/n]"
          FileUtils.rm_rf(path) if gets =~ /y/i
        end
      end

      def report_exists(file)
        puts "   exist   #{file}"
      end

      def report_creating(file)
        puts "  create   #{file}"
      end

    end
  end
end
