/*
*  Rubrica
*  file: search_int.c
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "search.h"
#include "search_cb.h"
#include "search_int.h"
#include "prefer.h"
#include "prefer_cb.h"
#include "prefer_configure.h"
#include "ui.h"
#include "rubrica_type.h"
#include "main.h"
#include "utils.h"

GtkWidget *search_list;
GtkWidget *search_text;
GtkWidget *text_history;
GtkWidget *label_result;
GtkWidget *search_on_menu;

RubricaOptionType search_on_option[] = {
  {"", N_("Card"),          SEARCH_CARD},
  {"", N_("First Name"),    SEARCH_FIRST_NAME},
  {"", N_("Last Name"),     SEARCH_LAST_NAME},
  {"", N_("Profession"),    SEARCH_PROFESSION},
  {"", N_("City"),          SEARCH_CITY},
  {"", N_("Country"),       SEARCH_COUNTRY},
  {"", N_("Web Address"),   SEARCH_WEB_ADDRESS},
  {"", N_("Email Address"), SEARCH_EMAIL_ADDRESS},
  {"", N_("Telephone"),     SEARCH_TELEPHONE},
  {"", N_("Company"),       SEARCH_COMPANY},
  {"", N_("Categories"),    SEARCH_CATEGORIES},
  {NULL, NULL}
};


GtkWidget*
create_search_dialog (GConfClient *client)
{
  GtkWidget *app;  

  GtkWidget *view;
  GtkListStore *model;
  GtkTreeSelection *selection;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;

  GtkWidget *search_dialog;
  GtkWidget *dialog_vbox;

  GtkWidget *case_check;
  GtkWidget *type_check;

  GtkWidget *scroll_result;

  GtkWidget *search_frame;
  GtkWidget *result_frame;

  GtkWidget *search_box;
  GtkWidget *where_box;

  GtkWidget *hbox;
  GtkWidget *result_box;
  GtkWidget *result_label_box;

  GtkWidget *search_label;
  GtkWidget *label_item;
  
  GtkWidget *search_on_label;

  gchar *column_title;
  gint search_item;
  gint col;

  app = rubrica_get_app();
  
  search_dialog = gtk_dialog_new();
  gtk_dialog_add_buttons(GTK_DIALOG(search_dialog), 
			 GTK_STOCK_FIND, GTK_RESPONSE_ACCEPT,
			 GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
  gtk_window_set_title(GTK_WINDOW(search_dialog), _("Rubrica search"));
  gtk_window_set_resizable (GTK_WINDOW (search_dialog), FALSE);
  
  gtk_dialog_set_has_separator (GTK_DIALOG(search_dialog), TRUE);
  gtk_window_set_position (GTK_WINDOW (search_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (search_dialog), FALSE, FALSE, FALSE);
  g_object_set_data (G_OBJECT (app), "search_dialog", search_dialog);

  dialog_vbox = GTK_DIALOG (search_dialog)->vbox;
  gtk_widget_show (dialog_vbox);

  search_frame = rubrica_ui_frame_new(_("Rubrica search"));
  gtk_box_pack_start (GTK_BOX (dialog_vbox), search_frame, TRUE, TRUE, 0); 
  gtk_container_set_border_width (GTK_CONTAINER (search_frame), 3);

  search_box = rubrica_ui_default_box_new(VBOX);
  gtk_container_add (GTK_CONTAINER (search_frame), search_box);

  /*     What search
  */
  hbox = rubrica_ui_default_box_new(HBOX);
  gtk_box_pack_start (GTK_BOX (search_box), hbox, FALSE, FALSE, 5);
  
  search_label = rubrica_ui_label_new(_("Se_arch"));
  gtk_box_pack_start (GTK_BOX (hbox), search_label, FALSE, FALSE, 5);

  text_history = gnome_entry_new ("search_history");
  g_object_set_data (G_OBJECT (search_dialog), "text_history", text_history);
  gtk_box_pack_start (GTK_BOX (hbox), text_history, TRUE, TRUE, 5);
  gtk_widget_show (text_history);

  search_text = gnome_entry_gtk_entry (GNOME_ENTRY (text_history));
  g_object_set_data(G_OBJECT (search_dialog), "search_text", search_text);
  gtk_widget_show (search_text);
		       
  gtk_label_set_mnemonic_widget(GTK_LABEL(search_label), search_text);

  /* where search
   */
  where_box = rubrica_ui_default_box_new(HBOX);
  gtk_box_pack_start (GTK_BOX (search_box), where_box, FALSE, FALSE, 5);

  search_on_label = rubrica_ui_label_new(_("Search is _performed in:"));
  gtk_box_pack_start(GTK_BOX(where_box), search_on_label, FALSE, FALSE, 5);
  
  search_on_menu = rubrica_ui_option_menu_new(search_on_option);
  gtk_box_pack_start(GTK_BOX(where_box), search_on_menu, FALSE, FALSE, 5);

  gtk_label_set_mnemonic_widget(GTK_LABEL(search_on_label), search_on_menu);
  rubrica_search_configure_search(client, RUBRICA_KEY_SEARCH_TYPE);

  search_item = gtk_option_menu_get_history(GTK_OPTION_MENU(search_on_menu));
  column_title = g_strdup(search_on_option[search_item].label);

  /* check button
     search case sensitive
  */
  case_check = rubrica_ui_pack_in_box_check_button_new(search_box, 
						       _("Case _sensitive"));
  type_check = rubrica_ui_pack_in_box_check_button_new(search_box,
						       _("Find inco_mplete "
							 "string"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (case_check), 
				rubrica_preferences_get_search_case()); 

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (type_check), 
				rubrica_preferences_get_search_mode());

  g_object_set_data(G_OBJECT(search_dialog), "case_check", case_check);
  g_object_set_data(G_OBJECT(search_dialog), "mode_check", type_check);

  /*    I risultati della ricerca
	Search results
  */
  result_frame = rubrica_ui_frame_new (_("Results"));
  gtk_box_pack_start(GTK_BOX (dialog_vbox), result_frame, TRUE, TRUE, 5);

  result_box = rubrica_ui_box_new(VBOX, FALSE, 2, 0);
  gtk_container_add(GTK_CONTAINER(result_frame), result_box);

  scroll_result = rubrica_ui_scrolled_window_new();
  gtk_widget_set_usize (scroll_result, 1, 150);
  gtk_box_pack_start(GTK_BOX(result_box), scroll_result, TRUE, TRUE, 0);

  /*      Model/View
   */
  model = gtk_list_store_new(SEARCH_RESULT_COLUMNS, 
			     G_TYPE_STRING, 
			     G_TYPE_STRING, 
			     G_TYPE_STRING);
  view  = gtk_tree_view_new_with_model(GTK_TREE_MODEL(model));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
  g_object_set_data(G_OBJECT(search_dialog), "view", view);

  gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);
  gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(view), TRUE);
  
  renderer = gtk_cell_renderer_text_new();
  gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view), -1, 
					      _("Card"), renderer, "text", 
					      SEARCH_RESULT_CARD, NULL);    

  renderer = gtk_cell_renderer_text_new();
  col = gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view), -1, 
						    column_title, renderer, 
						    "text", 
						    SEARCH_RESULT_FOUND, NULL);
  column = gtk_tree_view_get_column(GTK_TREE_VIEW(view), col-1);
  g_object_unref(model);
  g_free(column_title);

  gtk_container_add(GTK_CONTAINER(scroll_result), view);
  gtk_widget_show(view);

  /* inserire qui la stringa 
   */
  result_label_box = rubrica_ui_box_new(HBOX, FALSE, 0, 2);
  gtk_box_pack_start (GTK_BOX (result_box), result_label_box, FALSE, FALSE, 2);

  label_result = rubrica_ui_label_new(_("Item(s) found:"));
  gtk_box_pack_start (GTK_BOX (result_label_box), label_result,
		      FALSE, FALSE, 2);
  
  label_item = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (result_label_box), label_item, TRUE, TRUE, 2);
  g_object_set_data(G_OBJECT(search_dialog), "found", label_item);
  gtk_widget_show(label_item);


  /*    Callbacks
   */
  g_signal_connect(G_OBJECT (search_on_menu), "changed", 
		   G_CALLBACK (on_option_menu_changed), 
		   RUBRICA_KEY_SEARCH_TYPE); 
  g_signal_connect(G_OBJECT (search_on_menu), "changed", 
		   G_CALLBACK (on_update_search_column), column);
  
  gtk_signal_connect(GTK_OBJECT(search_dialog), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
		     (gpointer) search_dialog);
  
  g_signal_connect(G_OBJECT(selection), "changed", 
		   G_CALLBACK(rubrica_search_row_selected), view);

  return search_dialog;
}

  
void rubrica_search_configure_search(GConfClient *client, gchar *key)
{
  GConfValue *value;
  gint val = 0;

  value = gconf_client_get(client, key, NULL);

  if (value == NULL || value->type != GCONF_VALUE_INT)
    value = gconf_client_get_default_from_schema(client, key, NULL); 
  
  if(value)
    val = gconf_client_get_int(client, key, NULL); 
    
  gtk_option_menu_set_history(GTK_OPTION_MENU(search_on_menu), val);    
}


void rubrica_search_dialog_clean(void)
{
}

gchar *rubrica_search_get_option_label(gint pos)
{
  gint len = rubrica_utils_option_len(search_on_option);

  if (pos > len)
    return NULL;

  return search_on_option[pos].label;
}

GtkWidget *rubrica_search_get_search_list(void)
{
  return (GtkWidget *) search_list;
}

GtkWidget *rubrica_search_get_search_text(void)
{
  return (GtkWidget *) text_history;
}

void rubrica_search_set_label_result(gchar *str)
{
  gtk_label_set_text(GTK_LABEL(label_result), str);	
}
