/*
*  Rubrica
*  file: file.h
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __RUBRICA_FILE_H
#define __RUBRICA_FILE_H

#include <libxml/tree.h>
#include <libxml/parser.h>

#include "rubrica_type.h"
#include "rubrica.h"
#include "dialog.h"


xmlDocPtr rubrica_file_open_doc(gchar *filename);
gint rubrica_file_get_fileformat(xmlDocPtr doc);
gchar *rubrica_file_get_version(xmlDocPtr doc);
gchar *rubrica_file_get_document_tpye(xmlDocPtr doc);
gboolean rubrica_file_is_rubrica_doc(xmlDocPtr doc, gchar *filename);

gboolean rubrica_file_import_old_file(gchar* fname);

gboolean rubrica_file_file_has_rub_extension(gchar *fn);
void rubrica_file_do_backup(Rubrica *rubrica, gchar *old_file_name);
void rubrica_file_do_bak_backup(Rubrica *rubrica, gchar *filename);


void rubrica_file_save(Rubrica *rubrica);
void rubrica_file_save_as(Rubrica *rubrica);

void rubrica_file_write_file(GtkWidget *button, gpointer data);
void rubrica_file_build_xmlnode(xmlNodePtr xmlnode, RubricaItem *);
gboolean rubrica_file_write_xmlfile(Rubrica *rubrica, gchar *fname);
  
void rubrica_file_start_with_file(gchar *file);
void rubrica_file_load_file(void);
void rubrica_file_open_file(GtkWidget *w, gpointer data);
gboolean rubrica_file_load_xmlfile(gchar *filename, RubricaErrorType *err);
gboolean rubrica_file_real_load_xmlfile(Rubrica *rubrica, gchar *filename, 
					 RubricaErrorType *err);

void rubrica_file_parse_doc(Rubrica *rubrica, xmlDocPtr doc, 
			    RubricaErrorType *err);

void rubrica_file_load_from_xmlnode(Rubrica *rubrica, xmlNodePtr xmlnode);


#endif 
