
(define (relabel-monotones base-name monotones label-table)
  (let loop ((i 0) 
	     (m monotones) 
	     (r '()))
    (if (null? m)
	(reverse r)
	(let ((new-label (format #f "~a_~d" base-name i)))
	  (table-insert! label-table (caar m) new-label)
	  (loop (add1 i)
		(cdr m)
		(cons (cons new-label (cdar m)) r))))))

(define (vinsns->monotones* name vinsns)
  (let loop ((accum '()) (i vinsns))
    (if (null? i)
	(list (cons name (reverse accum)))
	(if (eq? (caar i) 'label)
	    (cons (cons name (reverse accum))
		  (vinsns->monotones* (cadar i) (cdr i)))
	    (loop (cons (car i) accum) (cdr i))))))
