/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: myname.c,v 1.2 2000/08/13 10:40:32 mbp Exp $
 * 
 * Copyright (C) 2000 by Martin Pool <mbp@humbug.org.au>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * myname.c -- Update the externally-visible process name to show
 * what we're doing.
 *
 * Unfortunately this is a bit nonportable; so at the moment it only
 * works on Linux.  Sadly even there we can only write over the
 * existing buffer and not extend it.  So the total length is limited
 * by the length of the inital command line.  :-(  Also, the buffer
 * must be NUL-filled.
 *
 * I guess one solution would be to re-exec ourselves with a big blank
 * argument, but this is kind of overkill.  Perhaps the wrapper
 * scripts should do it?
 *
 * We should probably have a configure-time test to work out the right
 * way to do this, but it's hard.
 */

#include "config.h"
#include "sysheaders.h"
#include "rproxy.h"
#include "myname.h"

                                        /*
                                         | Q: What do you get if you
                                         | cross the Atlantic with the
                                         | Titanic?
                                         */


/* This holds our argv[0] so we can use it both for logging, and also
 * so we can modify it. */
static char *argv0, *argv1;
static int argv_space;

/* Before we can make this work we must duplicate all strings we
 * wish to save from the arguments. */


void
rp_my_name(int argc, char **argv)
{
    argv0 = argv[0];
    argv1 = argv[1];

    /* find the end of the last argument, then clobber from argv[0] up
     * to there. */
    argv_space = strchr(argv[argc-1], '\0') - argv[1];
    hs_bzero(argv[1], argv_space);
}


/*
 * Set a publicly visible name for this process to show up in
 * process listings.  To be nice, we accept a printf format.
 */
void
rp_process_name(char const *fmt, ...)
{
    int bytes;
    
    /* XXX: I wish I knew what the limit was on this string. */
    va_list ap;
    va_start(ap, fmt);
    bytes = vsnprintf(argv1, argv_space, fmt, ap);
    va_end(ap);

    /* return value is the number of bytes excluding the trailing NUL;
     * and we need to fill argv_space bytes. */

    /* XXX: Is the return value accurate on all platforms?  Perhaps we
     * should test this? */
    if (bytes < argv_space) {
        bzero(argv1 + bytes, argv_space - bytes);
    }
}


                                        /*
                                         | A: Halfway.
                                         */
