/*				       	-*- c-file-style: "bsd" -*-
 * rproxy -- dynamic caching and delta update in HTTP
 * $Id: header.h,v 1.5 2000/08/16 10:08:58 mbp Exp $
 * 
 * Copyright (C) 1999, 2000 by Martin Pool
 * Copyright (C) 1999 by tridge@samba.org
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


struct header_list;
typedef struct header_list header_set_t;

header_set_t   *header_set_new(void);

void header_add(header_set_t * , char const *label,
                           char const *content);

void header_add_split(header_set_t * , char const *label,
                      char const *content);

int             header_load(header_set_t * headers, FILE * f);
char           *header_content(header_set_t * headers, char const *label);
int             header_ival(header_set_t * headers, char const *label);
int             header_send(header_set_t * headers, FILE * f);
void            header_clear(header_set_t * headers);
void            header_remove(header_set_t * headers, char const *label);
void            header_remove_list(header_set_t * headers, char const *label,

				   char const *content);
void            header_add_list(header_set_t * headers, char const *label,

				char const *content);
void            header_set(header_set_t * headers, char const *label,

			   char const *val);
int             header_send_as_line(header_set_t const *headers, FILE * f);

int             header_list_contains_token(header_set_t * headers, char const *label, 
					   char const *token);
char * header_content_all(header_set_t *headers, char const *label);
