#ifndef ROOTPORTAL_H
#define ROOTPORTAL_H

#include "common.h"

#ifdef ENABLE_CONFIGURATOR
#include "config/configuration.h"
#endif

#include "datasetmap.h"
#include "moduleinfo.h"
#include "module_tree.h"
#include "base_node.h"

#include <fstream>

using namespace std;

class StartupCancelled
{
public:
        StartupCancelled(int value) : returnCode(value) {};
        int returnCode;
};

class RootPortal
{
public:
        RootPortal(int argc, char* argv[]) throw (StartupCancelled);
        ~RootPortal();
        void service();
        void preShutdown();
        void saveConfig();
        void load_settings();
        void save_settings();
        void configure() {
#ifdef ENABLE_CONFIGURATOR
                configurator->displayConfigurator();
#else
                cerr << "Configurator support not enabled during build\n";
#endif
        }        

        void set_load_configurator_default(bool def) {
                load_configurator_default = def;
        }
                        
        bool get_load_configurator_default() {
                return load_configurator_default;
        }               

private:
        bool load_configurator_default;
        string getPluginDir();
        bool fileExists(const string& name);
        void displayWelcomeMessage();
#ifdef ENABLE_CONFIGURATOR
        Configuration* configurator;
#endif

        int getLock(const string& displayName);
        void releaseLock();

        string writeConfig; // where to write back the configuration
};

extern RootPortal* rootPortal;
extern ofstream output_command_file;
extern bool slave_mode;

#endif
