#include "modifier.h"
#include "../../module_registry.h"

DataSetMap *Modifier::moduleInfo = 0;

Module* modifier_constructor()
{
        return new Modifier();
}

const DataSetMap& Modifier::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Makes changes to data passing through it"));
                moduleInfo->set("supported_vars", DataSet("filter_var,filter,replace_var,replace"));
                moduleInfo->set("supported_var_types", DataSet("childoutput,table,childoutput,table"));
                moduleInfo->set("supported_var_defaults", DataSet("textline,,textline,"));
                moduleInfo->set("overridable", DataSet("false,false,false,false"));
                moduleInfo->set("table_filter_col_names", DataSet("regex"));
                moduleInfo->set("table_filter_col_types", DataSet("string"));
                moduleInfo->set("table_replace_col_names", DataSet("regex,replace with"));
                moduleInfo->set("table_replace_col_types", DataSet("string,string"));
                moduleInfo->set("output_variables", DataSet("CHILD_VARS"));
        }
        return *moduleInfo;
}

#ifdef BUILDIN_MODIFIER
extern "C" int modifier_plugin_startup()
#else
extern "C" int plugin_startup()
#endif
{
        ModuleRegistry::instance()->add_module("Modifier", &modifier_constructor, Modifier::get_module_info_instance());
        return 0;
}

#ifdef BUILDIN_MODIFIER
extern "C" void modifier_plugin_shutdown()
#else
extern "C" void plugin_shutdown()
#endif
{
        ModuleRegistry::instance()->remove_module("Modifier");
        Modifier::destroy_module_info();
}

// maximum matches that will be replaced
#define MAX_MATCHES 20

Modifier::Modifier()
        : groupUpdate(false),
          filtered(false)
{
}

Modifier::~Modifier()
{
        clearFilter();
        clearReplace();
        rpdbgmsg(getName() << " module destroyed");
}

void Modifier::clearFilter()
{
        for (vector<regex_t>::iterator i = filter.begin(); i != filter.end(); ++i)
                regfree(&(*i));
        filter.clear();
}

void Modifier::clearReplace()
{
        for (vector<regex_t>::iterator i = replace.begin(); i != replace.end(); ++i)
                regfree(&(*i));
        replaceWith.clear();
        replace.clear();
}

void Modifier::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "replace_var") {
                replaceVar = data.toString();
        } else if (keyName == "replace") {
                clearReplace();
                if (data.count() > 0) {
                        for (int i = 0; i < data.count(); i += 2) {
                                if (i + 1 != data.count()) {
                                        string rep = data.getString(i);
                                        string repWith = data.getString(i + 1);
                                        regex_t preg;
                                        if (regcomp(&preg, rep.c_str(), REG_EXTENDED)) {
                                                cerr << "error compiling regular expression: \"" << rep << "\"" << endl;
                                        } else {
                                                replace.push_back(preg);
                                                replaceWith.push_back(repWith);
                                        }
                                }
                        }
                }
        } else if (keyName == "filter_var") {
                filterVar = data.toString();
        } else if (keyName == "filter") {
                clearFilter();
                if (data.count() > 0) {
                        for (int i = 0; i < data.count(); i++) {
                                string value = data.getString(i);
                                regex_t preg;
                                if (regcomp(&preg, value.c_str(), REG_NOSUB || REG_EXTENDED))
                                        cerr << "error compiling regular expression: \"" << value << "\"" << endl;
                                else
                                        filter.push_back(preg);
                        }
                }
        } else if (keyName == replaceVar) {
                string text;
                env.getExpanded(text, keyName);
                string newText;
                if (doReplace(text, newText))
                        addToOutput(keyName, DataSet(newText));
                else
                        addToOutput(keyName, data);                
        } else {
                addToOutput(keyName, data);
        }
        
        if (keyName == filterVar) {
                string text;
                env.getExpanded(text, keyName);
                for (int i = 0; i < filter.size(); i++) {
                        if (!regexec(&filter[i], text.c_str(), 0, 0, 0)) {
                                filtered = true;
                        }
                }
        }
        
        if (!groupUpdate) {
                if (filtered)
                        clearOutput();
                else
                        sendOutput();
                filtered = false;
        }
}

void Modifier::outputReceived(const DataSetMap& output)
{
        groupUpdate = true;
        Module::outputReceived(output);
        groupUpdate = false;
        
        if (filtered)
                clearOutput();
        else
                sendOutput();
        filtered = false;
}

        
// set bits in the range start-end of mask to true
void Modifier::setMask(bool* mask, int start, int end)
{
        for (int i = start; i <= end; i++)
                mask[i] = true;
}

// return true only if all the bits of mask in the range start-end are false
bool Modifier::checkMask(const bool* mask, int start, int end)
{
        for (int i = start; i <= end; i++)
                if (mask[i] == true)
                        return false;
        return true;
}

// return the item number 'n' in indexes that is the smallest
// stn >=  cpos.  or -1 if none where found
int Modifier::nextIndex(vector<int>& indexes, int cpos)
{
        int n = -1; // current index of the next index
        int val = 0; // value at the current index
        for (int i = 0; i < indexes.size(); i++) {
                if ((n == -1 || indexes[i] < val) && indexes[i] >= cpos) {
                        val = indexes[i];
                        n = i;
                }
        }
        return n;
}

// returns true if a replace was done
bool Modifier::doReplace(const string& original, string& modified)
{
        int olength = original.length();
        
        regmatch_t pmatch[MAX_MATCHES];
        bool matched = false;
        bool *mask = new bool[olength];

        vector<int> so; // start offset
        vector<int> eo; // end offset
        vector<string> repWith;

        for (int i = 0; i < olength; i++)
                mask[i] = false;

        for (int j = 0; j < replace.size(); j++) {
                string replaceText = replaceWith[j];
                bool thisMatch = regexec(&(replace[j]), original.c_str(), MAX_MATCHES, pmatch, 0) == 0;
                if (thisMatch) {
                        for (int i = 0; i < MAX_MATCHES; i++) {
                                if (pmatch[i].rm_so != -1) {
                                        if (checkMask(mask, pmatch[i].rm_so, pmatch[i].rm_eo - 1)) {
                                                so.push_back(pmatch[i].rm_so);
                                                eo.push_back(pmatch[i].rm_eo);
                                                repWith.push_back(replaceText);
                                                setMask(mask, pmatch[i].rm_so, pmatch[i].rm_eo - 1);
                                        }
                                }
                        }
                        matched = true;
                }
        }

        if (matched) {
                modified = "";
                int cpos = 0;
                int nextReplaceIndex = nextIndex(so, cpos);
                while (cpos < olength) {
                        int nval = -1;
                        if (nextReplaceIndex != -1)
                                nval = so[nextReplaceIndex];
                        if (cpos ==  nval) {
                                modified += repWith[nextReplaceIndex];
                                cpos += eo[nextReplaceIndex] - so[nextReplaceIndex];
                                nextReplaceIndex = nextIndex(so, cpos);
                        } else {
                                modified += original[cpos];
                                cpos++;
                        }
                }
        }

        delete[] mask;
        
        return matched;
}
