#include "moduleinfo.h"

void ModuleInfo::checkModuleInfo() const
{
        bool allOkay = true;
        
        if (!modInf.validIndex("name")) {
                cerr << "module info doesn't define 'name' field" << endl;
                allOkay = false;
        } else {
                string modName = modInf["name"].toString();
                
                if (!modInf.validIndex("supported_vars")) {
                        cerr << modName << " module info doesn't define 'supported_vars' fields" << endl;
                        allOkay = false;
                }
                if (!modInf.validIndex("supported_var_types")) {
                        cerr << modName << " module info doesn't define 'supported_var_types' fields" << endl;
                        allOkay = false;
                }
                if (!modInf.validIndex("supported_var_defaults")) {
                        cerr << modName << " module info doesn't define 'supported_var_defaults' fields" << endl;
                        allOkay = false;
                }
                if (!modInf.validIndex("overridable")) {
                        cerr << modName << " module info doesn't define 'overridable' fields" << endl;
                        allOkay = false;
                }
                if (!modInf.validIndex("description")) {
                        cerr << modName << " module info doesn't define 'description' field" << endl;
                        allOkay = false;
                }

                if (allOkay) {
                        const DataSet& supported_vars = modInf["supported_vars"];
                        const DataSet& supported_var_types = modInf["supported_var_types"];
                        const DataSet& supported_var_defaults = modInf["supported_var_defaults"];
                        const DataSet& overridable = modInf["overridable"];
                        
                        if (supported_vars.count() != supported_var_types.count()
                            || supported_vars.count() != supported_var_defaults.count()
                            || supported_vars.count() != overridable.count()) {
                                cerr << "error in module description (" << modInf.getString("name", 0, "") << "):"
                                     <<  " vars = " << supported_vars.count()
                                     <<  " types = " << supported_var_types.count()
                                     <<  " defaults = " << supported_var_defaults.count()
                                     <<  " overridable = " << overridable.count() << endl;
                                allOkay = false;
                        }
                }
        }
        if (!allOkay) {
                cerr << "A problem was detected with one or more plugins.\n"
                     << "Continuing anyway, but expect possible crash later on.\n"
                     << "You should check your plugins to make sure they are not out of date.\n"
                     << "Use --verbose option to see which plugins are being loaded from where\n";
        }
}

void ModuleInfo::set(ModuleConstructor c, const DataSetMap& modInf_)
{
        modInf = modInf_;
        constructor_ = c;
}
