/* some bits of code borrowed from GNOME (http://www.gnome.org/) */

#include "preferences.h"
#include "../root-portal.h"

#include <gnome.h>
#include <gtk/gtk.h>
#include <iostream>
using namespace std;

static GtkWidget *property_box = NULL;
static GtkWidget *load_configurator_checkbox = NULL;

static void property_apply(GtkWidget *w, int page)
{
        rootPortal->set_load_configurator_default(
                gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(load_configurator_checkbox)));
}

static void prefs_change(GtkToggleButton *togglebutton, gpointer user_data)
{
        gnome_property_box_changed(GNOME_PROPERTY_BOX(property_box));
}

void show_preferences_dialog(GtkWidget *parent)
{
        if (property_box == NULL) {
                property_box = gnome_property_box_new();
                gnome_dialog_set_parent(GNOME_DIALOG(property_box), GTK_WINDOW(parent));
                gtk_signal_connect(GTK_OBJECT(property_box), "apply",
                                   GTK_SIGNAL_FUNC(property_apply), NULL);
                gnome_dialog_close_hides(GNOME_DIALOG(property_box), true);
                load_configurator_checkbox = gtk_check_button_new_with_label("Load configurator by default (override with -n or -c)");
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(load_configurator_checkbox),
                                             rootPortal->get_load_configurator_default());
                gtk_signal_connect(GTK_OBJECT(load_configurator_checkbox), "toggled", GTK_SIGNAL_FUNC(&prefs_change), NULL);
                GtkWidget *label = gtk_label_new("Startup");
                GtkWidget *vbox = gtk_vbox_new(false, 0);
                gnome_property_box_append_page(GNOME_PROPERTY_BOX(property_box), vbox, label);
                gtk_box_pack_start(GTK_BOX(vbox), load_configurator_checkbox, true, true, 0);
        }

        if (property_box != NULL && !GTK_WIDGET_VISIBLE(property_box)) {
                gtk_widget_show_all(property_box);
        }
}

