#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include "module_tree_display.h"
#include "modulemodifier.h"
#include "../module_tree.h"

#ifdef WITH_GNOME
#include <gnome.h>
#endif

#ifdef WITH_GTK
#include <gtk/gtk.h>
#endif

#include <vector>
using namespace std;

class ModuleModifier;
class Path;

class CallbackData
{
public:
        CallbackData(Configuration* t_, const string& d_)
                : t(t_), data(d_) {};
        Configuration* t;
        string data;
};

class Configuration : public ModuleTreeListener
{
public:
        Configuration();
        ~Configuration();
        void displayConfigurator();
        void closeConfigurator();
        void moduleFocus(const Path& mod);

        void closeModule(const Path& mod);

        void display_about();
        void display_preferences();
        
        void return_message(const DataSet& msg, const Path& path);

        void set_appbar_string(const string& msg);
private:
        void set_window_icon(GtkWidget* win);
private:        
        GtkWidget* window;
        GtkWidget* vbox;
        GtkWidget* paned;
        bool configuratorActive;
        ModuleTreeDisplay modtree_display;
        GtkWidget* moduleBook;
        ModuleModifier* focusedModule;
        GtkWidget* appbar;

        vector<ModuleModifier*> modmodif;
};

#endif
