/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */

/* gpcp++.cc
 *    c++ wrapper library for gpcp
 *
 * $Id: gpcp++.cc,v 1.2 2001/03/27 23:00:46 remi Exp $
 *
 * Copyright (C) 2000, 2001 Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#include "gpcp++.h"

GPCP::GPCP(char *filename, Options *options)
{
    GPCP_RegisterOptions(options);
    GPCP_ReadFile(filename, &cdata);
    GPCP_PrintData(cdata);
}

GPCP::~GPCP()
{
    GPCP_FreeData(&cdata);
}

int GPCP::get(char *varname, string& str)
{
    char *s;
    if (GPCP_GetValue(varname, &s) == -1)
        return -1;
    str = string(s);
    free(s);
    return 0;
}

int GPCP::get(char *varname, float& val)
{
    if (GPCP_GetValue(varname, &val) == -1)
        return -1;
    return 0;
}

int GPCP::get(char *varname, int& val)
{
    if (GPCP_GetValue(varname, &val) == -1)
        return -1;
    return 0;
}

int GPCP::get(char *varname, bool& val)
{
    short a;
    if (GPCP_GetValue(varname, &a) == -1)
        return -1;
    if (a) val = true;
    else val = false;
    return 0;
}
