/* -*- Mode: C; c-file-style: "k&r"; -*-*/

/* parser.c
 *    file parser
 *
 * $Id: err.c,v 1.3 2001/03/30 20:37:23 antoine Exp $
 *
 * Copyright (C) 2000,
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *     Remi Lefebvre <remi@step.polymtl.ca>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "err.h"

struct errors
{
    int gpcp_errno;
    char message[256];
} error_table[] = {
    {OK,                 ""},
    {ERR_OPEN,           "Can't open file"},
    {ERR_EOF,            ""},
    {OPT_NOT_REGISTERED, "Options not registered"},
    {SYNTAX_ERR,         "Syntax error"},
    {KEYWORD_EXPECTED,   "Keyword expected"},
    {EQUAL_EXPECTED,     "Equality sign expected"},
    {VALUE_EXPECTED,     "Value expected"},
    {PREMATURE_EOF,      "Premature EOF"},
    {CLOSEPAR_EXPECTED,  "Closing parenthesis or comma expected"},
    {INVALID_POS,        "Invalid position"},
    {INVALID_TYPE,       "Invalid type"},
    {INVALID_KEYWORD,    "Invalid keyword"},
    {OVERFLOW,           "Token too large"},
    {BAD_PARENT,         "Invalid parent"}
};

int error (int gpcp_errno, int line, char *msg)
{
    fprintf (stderr, "GPCP: %s (line %d) - %s\n",
             error_table[gpcp_errno].message, line, msg);
    return gpcp_errno;
}





