# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Module", "Object", "class")
aClass.addSubclasses(%w{Class})
aClass.addFragment(Paragraph.new("A <code>Module</code> is a collection of methods and constants. The methods in a module may be instance methods or module methods. Instance methods appear as methods in a class when the module is included, module methods do not. Conversely, module methods may be called without creating an encapsulating object, while instance methods may not. See <code>Module\#module_function</code> on page 350.\n"))
aClass.addFragment(Paragraph.new("In the descriptions that follow, the parameter <i>aSymbol</i> refers to a symbol, which is either a quoted string or a <code>Symbol</code> (such as <code>:name</code>).\n"))
aClass.addFragment(Verbatim.new("module Mod\n  include Math\n  CONST = 1\n  def meth\n    \#  ...\n  end\nend\nMod.type               \#=> Module\nMod.constants          \#=> [\"CONST\", \"E\", \"PI\"]\nMod.instance_methods   \#=> [\"meth\"]\n"))
m0002 = MethodDesc.new("constants", "class", "Module.constants -> <i>anArray</i>")
m0002.addFragment(Paragraph.new("Returns an array of the names of all constants defined in the system. This list includes the names of all modules and classes.\n"))
m0002.addFragment(Verbatim.new("p Module.constants.sort[1..5]"))
m0002.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0002.addFragment(Verbatim.new("[\"ARGV\", \"ArgumentError\", \"Array\", \"Bignum\", \"Binding\"]"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("nesting", "class", "Module.nesting -> <i>anArray</i>")
m0003.addFragment(Paragraph.new("Returns the list of <code>Modules</code> nested at the point of call.\n"))
m0003.addFragment(Verbatim.new("module M1\n  module M2\n    $a = Module.nesting\n  end\nend\n$a           \#=> [M1::M2, M1]\n$a[0].name   \#=> \"M1::M2\"\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("new", "class", "Module.new -> <i>aModule</i>")
m0004.addFragment(Paragraph.new("Creates a new anonymous module.\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("<,<=,>,>=", "instance", "<i>mod</i> <code><em>relop</em></code> <i>aModule</i> -> <code>true</code> or <code>false</code>")
m0005.addFragment(Paragraph.new("Hierarchy Query---One module is considered <em>greater than</em> another if it is included in (or is a parent class of) the other module. The other operators are defined accordingly. If there is no relationship between the modules, returns false for all operators.\n"))
m0005.addFragment(Verbatim.new("module Mixin\nend\n\nmodule Parent\n  include Mixin\nend\n\nmodule Unrelated\nend\n\nParent > Mixin       \#=> false\nParent < Mixin       \#=> true\nParent <= Parent     \#=> true\nParent < Unrelated   \#=> false\nParent > Unrelated   \#=> false\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("<=>", "instance", "<i>mod</i> <=> <i>aModule</i> -> -1, 0, +1")
m0006.addFragment(Paragraph.new("Comparison---Returns -1 if <i>mod</i> includes <i>aModule</i>, 0 if <i>mod</i> is the same as <i>aModule</i>, and +1 if <i>mod</i> is included by <i>aModule</i> or if <i>mod</i> has no relationship with <i>aModule</i>.\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("===", "instance", "<i>mod</i> === <i>anObject</i> -> <code>true</code> or <code>false</code>")
m0007.addFragment(Paragraph.new("Case Equality---Returns <code>true</code> if <i>anObject</i> is an instance of <i>mod</i> or one of <i>mod</i>'s descendents. Of limited use for modules, but can be used in <code>case</code> statements to classify objects by class.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("ancestors", "instance", "<i>mod</i>.ancestors -> <i>anArray</i>")
m0008.addFragment(Paragraph.new("Returns a list of modules included in <i>mod</i> (including <i>mod</i> itself).\n"))
m0008.addFragment(Verbatim.new("module Mod\n  include Math\n  include Comparable\nend\n\nMod.ancestors    \#=> [Mod, Comparable, Math]\nMath.ancestors   \#=> [Math]\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("class_eval", "instance", "<i>mod</i>.class_eval( <i>aString</i> ) -> <i>anObject</i><br></br><i>mod</i>.class_eval {| | block } -> <i>anObject</i>")
m0009.addFragment(Paragraph.new("Synonym for <code>Module.module_eval</code>.\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("class_variables", "instance", "<i>mod</i>.class_variables -> <i>anArray</i>")
m0010.addFragment(Paragraph.new("Returns an array of the names of class variables in <i>mod</i> and the ancestors of <i>mod</i>.\n"))
m0010.addFragment(Verbatim.new("class One\n  @@var1 = 1\nend\nclass Two < One\n  @@var2 = 2\nend\nOne.class_variables   \#=> [\"@@var1\"]\nTwo.class_variables   \#=> [\"@@var2\", \"@@var1\"]\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("clone", "instance", "<i>mod</i>.clone -> <i>aModule</i>")
m0011.addFragment(Paragraph.new("Creates a new copy of a module.\n"))
m0011.addFragment(Verbatim.new("m = Math.clone   \#=> Math\nm.constants      \#=> [\"PI\", \"E\"]\nm == Math        \#=> false\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("const_defined?", "instance", "<i>mod</i>.const_defined?( <i>aSymbol</i> ) -> <code>true</code> or <code>false</code>")
m0012.addFragment(Paragraph.new("Returns <code>true</code> if a constant with the given name is defined by <i>mod</i>.\n"))
m0012.addFragment(Verbatim.new("Math.const_defined? \"PI\"   \#=> true\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("const_get", "instance", "<i>mod</i>.const_get( <i>aSymbol</i> ) -> <i>anObject</i>")
m0013.addFragment(Paragraph.new("Returns the value of the named constant in <i>mod</i>.\n"))
m0013.addFragment(Verbatim.new("Math.const_get :PI   \#=> 3.141592654\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("const_set", "instance", "<i>mod</i>.const_set( <i>aSymbol</i>, <i>anObject</i> ) -> <i>anObject</i>")
m0014.addFragment(Paragraph.new("Sets the named constant to the given object, returning that object. Creates a new constant if no constant with the given name previously existed.\n"))
m0014.addFragment(Verbatim.new("Math.const_set(\"HIGH_SCHOOL_PI\", 22.0/7.0)   \#=> 3.142857143\nMath::HIGH_SCHOOL_PI - Math::PI              \#=> 0.001264489267\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("constants", "instance", "<i>mod</i>.constants -> <i>anArray</i>")
m0015.addFragment(Paragraph.new("Returns an array of the names of the constants accessible in <i>mod</i>. This includes the names of constants in any included modules (example at start of section).\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("included_modules", "instance", "<i>mod</i>.included_modules -> <i>anArray</i>")
m0016.addFragment(Paragraph.new("Returns the list of modules included in <i>mod</i>.\n"))
m0016.addFragment(Verbatim.new("module Mixin\nend\n\nmodule Outer\n  include Mixin\nend\n\nMixin.included_modules   \#=> []\nOuter.included_modules   \#=> [Mixin]\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("instance_methods", "instance", "<i>mod</i>.instance_methods( <i>includeSuper</i>=<code>false</code> ) -> <i>anArray</i>")
m0017.addFragment(Paragraph.new("Returns an array containing the names of public instance methods in the receiver. For a module, these are the public methods; for a class, they are the instance (not singleton) methods. With no argument, or with an argument that is <code>false</code>, the instance methods in <i>mod</i> are returned, otherwise the methods in <i>mod</i> and <i>mod</i>'s superclasses are returned.\n"))
m0017.addFragment(Verbatim.new("module A\n  def method1()  end\nend\nclass B\n  def method2()  end\nend\nclass C < B\n  def method3()  end\nend"))
m0017.addFragment(Verbatim.new("A.instance_methods                \#=> [\"method1\"]\nB.instance_methods                \#=> [\"method2\"]\nC.instance_methods                \#=> [\"method3\"]\nC.instance_methods(true).length   \#=> 39\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("method_defined?", "instance", "<i>mod</i>.method_defined?( <i>aSymbol</i> ) -> <code>true</code> or <code>false</code>")
m0018.addFragment(Paragraph.new("Returns <code>true</code> if the named method is defined by <i>mod</i> (or its included modules and, if <i>mod</i> is a class, its ancestors).\n"))
m0018.addFragment(Verbatim.new("module A\n  def method1()  end\nend\nclass B\n  def method2()  end\nend\nclass C < B\n  include A\n  def method3()  end\nend\n\nA.method_defined? :method1    \#=> true\nC.method_defined? \"method1\"   \#=> true\nC.method_defined? \"method2\"   \#=> true\nC.method_defined? \"method3\"   \#=> true\nC.method_defined? \"method4\"   \#=> false\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("module_eval", "instance", "<i>mod</i>.module_eval( <i>aString</i> ) -> <i>anObject</i><br></br><i>mod</i>.module_eval {| | block } -> <i>anObject</i>")
m0019.addFragment(Paragraph.new("Evaluates the string or block in the context of <i>mod</i>. This can be used to add methods to a class. <code>module_eval</code> returns the result of evaluating its argument.\n"))
m0019.addFragment(Verbatim.new("class Thing\nend\na = %q{def hello() \"Hello there!\" end}\nThing.module_eval(a)   \#=> nil\nThing.new.hello()      \#=> \"Hello there!\"\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("name", "instance", "<i>mod</i>.name -> <i>aString</i>")
m0020.addFragment(Paragraph.new("Returns the name of the module <i>mod</i>.\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("private_class_method", "instance", "<i>mod</i>.private_class_method( <i>[</i><i>aSymbol</i><i>]+></i> ) -> <code>nil</code>")
m0021.addFragment(Paragraph.new("Makes existing class methods private. Often used to hide the default constructor <code>new</code>.\n"))
m0021.addFragment(Verbatim.new("class SimpleSingleton  \# Not thread safe\n  private_class_method :new\n  def SimpleSingleton.create(*args, &block)\n    @me = new(*args, &block) if ! @me\n    @me\n  end\nend"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("private_instance_methods", "instance", "<br></br><i>mod</i>.private_instance_methods( <i>includeSuper</i>=<code>false</code> ) -> <i>anArray</i>")
m0022.addFragment(Paragraph.new("Returns a list of the private instance methods defined in <i>mod</i>. If the optional parameter is not <code>false</code>, the methods of any ancestors are included.\n"))
m0022.addFragment(Verbatim.new("module Mod\n  def method1()  end\n  private :method1\n  def method2()  end\nend\nMod.instance_methods           \#=> [\"method2\"]\nMod.private_instance_methods   \#=> [\"method1\"]\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("protected_instance_methods", "instance", "<br></br><i>mod</i>.protected_instance_methods( <i>includeSuper</i>=<code>false</code> ) -> <i>anArray</i>")
m0023.addFragment(Paragraph.new("Returns a list of the protected instance methods defined in <i>mod</i>. If the optional parameter is not <code>false</code>, the methods of any ancestors are included.\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("public_class_method", "instance", "<i>mod</i>.public_class_method( <i>[</i><i>aSymbol</i><i>]+></i> ) -> <code>nil</code>")
m0024.addFragment(Paragraph.new("Makes a list of existing class methods public.\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("public_instance_methods", "instance", "<br></br><i>mod</i>.public_instance_methods( <i>includeSuper</i>=<code>false</code> ) -> <i>anArray</i>")
m0025.addFragment(Paragraph.new("Returns a list of the public instance methods defined in <i>mod</i>. If the optional parameter is not <code>false</code>, the methods of any ancestors are included.\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("alias_method", "private", "alias_method( <i>newID, oldID</i> ) -> <i>mod</i>")
m0026.addFragment(Paragraph.new("Makes <i>newID</i> a new copy of the method <i>oldID</i>. This can be used to retain access to methods that are overridden.\n"))
m0026.addFragment(Verbatim.new("module Mod\n  alias_method :origExit, :exit\n  def exit(code=0)\n    print \"Exiting with code \#{code}\\n\"\n    origExit(code)\n  end\nend\ninclude Mod\nexit(99)"))
m0026.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0026.addFragment(Verbatim.new("Exiting with code 99"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("append_features", "private", "append_features( <i>aModule</i> ) -> <i>mod</i>")
m0027.addFragment(Paragraph.new("When this module is included in another, Ruby calls <code>append_features</code> in this module, passing it the receiving module in <i>aModule</i>. Ruby's default implementation is to add the constants, methods, and module variables of this module to <i>aModule</i> if this module has not already been added to <i>aModule</i> or one of its ancestors. See also <code>Module\#include</code> on page 350.\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("attr", "private", "attr( <i>aSymbol</i>, <i>writable</i>=<code>false</code> ) -> <code>nil</code>")
m0028.addFragment(Paragraph.new("Defines a named attribute for this module, where the name is <i>aSymbol.</i><code>id2name</code>, creating an instance variable (<code>@name</code>) and a corresponding access method to read it. If the optional <i>writable</i> argument is <code>true</code>, also creates a method called <code>name=</code> to set the attribute.\n"))
m0028.addFragment(Verbatim.new("module Mod\n  attr  :size, true\nend"))
m0028.addFragment(Paragraph.new("<em>is equivalent to:</em>\n"))
m0028.addFragment(Verbatim.new("module Mod\n  def size\n    @size\n  end\n  def size=(val)\n    @size = val\n  end\nend"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("attr_accessor", "private", "attr_accessor( <i>[</i><i>aSymbol</i><i>]+></i> ) -> <code>nil</code>")
m0029.addFragment(Paragraph.new("Equivalent to calling ``<code>attr</code><i>aSymbol</i><code>, true</code>'' on each <i>aSymbol</i> in turn.\n"))
m0029.addFragment(Verbatim.new("module Mod\n  attr_accessor(:one, :two)\nend\nMod.instance_methods.sort   \#=> [\"one\", \"one=\", \"two\", \"two=\"]\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("attr_reader", "private", "attr_reader( <i>[</i><i>aSymbol</i><i>]+></i> ) -> <code>nil</code>")
m0030.addFragment(Paragraph.new("Creates instance variables and corresponding methods that return the value of each instance variable. Equivalent to calling ``<code>attr</code><i>:name</i>'' on each name in turn.\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("attr_writer", "private", "<p></p> attr_writer( <i>[</i><i>aSymbol</i><i>]+></i> ) -> <code>nil</code>")
m0031.addFragment(Paragraph.new("Creates an accessor method to allow assignment to the attribute <i>aSymbol</i><code>.id2name</code>.\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("extend_object", "private", "extend_object( <i>anObject</i> ) -> <i>anObject</i>")
m0032.addFragment(Paragraph.new("Extends the specified object by adding this module's constants and methods (which are added as singleton methods). This is the callback method used by <code>Object\#extend</code>.\n"))
m0032.addFragment(Verbatim.new("module Picky\n  def Picky.extend_object(o)\n    if String === o\n      print \"Can't add Picky to a String\\n\"\n    else\n      print \"Picky added to \", o.type, \"\\n\"\n      super\n    end\n  end\nend\n(s = Array.new).extend Picky  \# Call Object.extend\n(s = \"quick brown fox\").extend Picky"))
m0032.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0032.addFragment(Verbatim.new("Picky added to Array\nCan't add Picky to a String"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("include", "private", "include( <i>[</i><i>aModule</i><i>]+></i> ) -> <i>mod</i>")
m0033.addFragment(Paragraph.new("Invokes <code>Module.append_features</code> (documented on page 349) on each parameter in turn.\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("method_added", "private", "method_added( <i>aSymbol</i> )")
m0034.addFragment(Paragraph.new("Invoked as a callback whenever a method is added to the receiver.\n"))
m0034.addFragment(Verbatim.new("module Chatty\n  def Chatty.method_added(id)\n    print \"Adding \", id.id2name, \"\\n\"\n  end\n  def one()   end\nend\nmodule Chatty\n  def two()   end\nend"))
m0034.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0034.addFragment(Verbatim.new("Adding one\nAdding two"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("module_function", "private", "module_function( <i>[</i><i>aSymbol</i><i>]*</i> ) -> <i>mod</i>")
m0035.addFragment(Paragraph.new("Creates module functions for the named methods. These functions may be called with the module as a receiver, and also become available as instance methods to classes that mix in the module. Module functions are copies of the original, and so may be changed independently. The instance-method versions are made private. If used with no arguments, subsequently defined methods become module functions.\n"))
m0035.addFragment(Verbatim.new("module Mod\n  def one\n    \"This is one\"\n  end\n  module_function :one\nend\nclass Cls\n  include Mod\n  def callOne\n    one\n  end\nend\nMod.one     \#=> \"This is one\"\nc = Cls.new\nc.callOne   \#=> \"This is one\"\nmodule Mod\n  def one\n    \"This is the new one\"\n  end\nend\nMod.one     \#=> \"This is one\"\nc.callOne   \#=> \"This is the new one\"\n"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("private", "private", "private( <i>[</i><i>aSymbol</i><i>]*</i> ) -> <i>mod</i>")
m0036.addFragment(Paragraph.new("With no arguments, sets the default visibility for subsequently defined methods to private. With arguments, sets the named methods to have private visibility. See <em>Access Control</em> starting on page 235.\n"))
m0036.addFragment(Verbatim.new("module Mod\n  def a()  end\n  def b()  end\n  private\n  def c()  end\n  private :a\nend\nMod.private_instance_methods   \#=> [\"c\", \"a\"]\n"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("protected", "private", "protected( <i>[</i><i>aSymbol</i><i>]*</i> ) -> <i>mod</i>")
m0037.addFragment(Paragraph.new("With no arguments, sets the default visibility for subsequently defined methods to protected. With arguments, sets the named methods to have protected visibility. See <em>Access Control</em> starting on page 235.\n"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("public", "private", "public( <i>[</i><i>aSymbol</i><i>]*</i> ) -> <i>mod</i>")
m0038.addFragment(Paragraph.new("With no arguments, sets the default visibility for subsequently defined methods to public. With arguments, sets the named methods to have public visibility. See <em>Access Control</em> starting on page 235.\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("remove_const", "private", "remove_const( <i>aSymbol</i> ) -> <i>anObject</i>")
m0039.addFragment(Paragraph.new("Removes the definition of the given constant, returning that constant's value. Predefined classes and singleton objects (such as <i>true</i>) cannot be removed.\n"))
aClass.addMethod(m0039)
m0040 = MethodDesc.new("remove_method", "private", "remove_method( <i>aSymbol</i> ) -> <i>mod</i>")
m0040.addFragment(Paragraph.new("Removes the method identified by <i>aSymbol</i> from the current class. For an example, see <code>Module.undef_method</code>.\n"))
aClass.addMethod(m0040)
m0041 = MethodDesc.new("undef_method", "private", "undef_method( <i>aSymbol</i> ) -> <i>mod</i>")
m0041.addFragment(Paragraph.new("Prevents the current class from responding to calls to the named method. Contrast this with <code>remove_method</code>, which deletes the method from the particular class; Ruby will still search superclasses and mixed-in modules for a possible receiver.\n"))
m0041.addFragment(Verbatim.new("class Parent\n  def hello\n    print \"In parent\\n\"\n  end\nend\nclass Child < Parent\n  def hello\n    print \"In child\\n\"\n  end\nend\n\n\nc = Child.new\nc.hello\n\n\nclass Child\n  remove_method :hello  \# remove from child, still in parent\nend\nc.hello\n\n\nclass Child\n  undef_method :hello   \# prevent any calls to 'hello'\nend\nc.hello"))
m0041.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0041.addFragment(Verbatim.new("In child\nIn parent\nprog.rb:23: undefined method `hello' for \#<Child:0x4018d428> (NameError)"))
aClass.addMethod(m0041)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
