/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    static final long serialVersionUID = 2762574228534679611L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    private Scriptable prototype;
    private Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private transient Slot[] slots;
    private int count;
    private transient Slot lastAccess = REMOVED;
    private volatile transient Hashtable associatedValues;
    static /* synthetic */ Class class$org$mozilla$javascript$FunctionObject;

    public abstract String getClassName();

    public boolean has(String name, Scriptable start) {
        return null != this.getNamedSlot(name);
    }

    public boolean has(int index, Scriptable start) {
        return null != this.getSlot(null, index);
    }

    public Object get(String name, Scriptable start) {
        Slot slot = this.getNamedSlot(name);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if ((slot.flags & 1) != 0) {
            return this.getByGetter((GetterSlot)slot, start);
        }
        return slot.value;
    }

    private Object getByGetter(GetterSlot slot, Scriptable start) {
        Object[] args;
        Object getterThis;
        if (slot.delegateTo == null) {
            if (start != this) {
                Class clazz = slot.getter.getDeclaringClass();
                while (!clazz.isInstance(start)) {
                    if ((start = start.getPrototype()) == this) break;
                    if (start != null) continue;
                    start = this;
                    break;
                }
            }
            getterThis = start;
            args = ScriptRuntime.emptyArgs;
        } else {
            getterThis = slot.delegateTo;
            args = new Object[]{this};
        }
        return slot.getter.invoke(getterThis, args);
    }

    public Object get(int index, Scriptable start) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String name, Scriptable start, Object value) {
        int hash;
        Slot slot = this.lastAccess;
        if ((name != slot.stringKey || slot.wasDeleted != 0) && (slot = this.getSlot(name, hash = name.hashCode())) == null) {
            if (start != this) {
                start.put(name, start, value);
                return;
            }
            slot = this.addSlot(name, hash, null);
        }
        if (start == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", name);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            this.setBySetter((GetterSlot)slot, start, value);
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(name, start, value);
        }
    }

    private void setBySetter(GetterSlot slot, Scriptable start, Object value) {
        Object[] args;
        Object setterThis;
        if (!(start == this || slot.delegateTo == null && slot.setter.getDeclaringClass().isInstance(start))) {
            start.put(slot.stringKey, start, value);
            return;
        }
        Context cx = Context.getContext();
        Class[] pTypes = slot.setter.argTypes;
        Class desired = pTypes[pTypes.length - 1];
        int tag = FunctionObject.getTypeTag(desired);
        Object actualArg = FunctionObject.convertArg(cx, start, value, tag);
        if (slot.delegateTo == null) {
            setterThis = start;
            args = new Object[]{actualArg};
        } else {
            if (start != this) {
                Kit.codeBug();
            }
            setterThis = slot.delegateTo;
            args = new Object[]{this, actualArg};
        }
        if (((ScriptableObject)start).isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", slot.stringKey);
        }
        Object setterResult = slot.setter.invoke(setterThis, args);
        if (slot.setterReturnsValue) {
            Slot replacement = new Slot();
            replacement.intKey = slot.intKey;
            replacement.stringKey = slot.stringKey;
            replacement.attributes = slot.attributes;
            replacement.value = setterResult;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int i = ScriptableObject.getSlotPosition(this.slots, slot.stringKey, slot.intKey);
                if (i >= 0 && this.slots[i] == slot) {
                    this.slots[i] = replacement;
                    this.lastAccess = replacement;
                }
            }
        }
    }

    public void put(int index, Scriptable start, Object value) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            if (start != this) {
                start.put(index, start, value);
                return;
            }
            slot = this.addSlot(null, index, null);
        }
        if (start == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", Integer.toString(index));
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == start) {
            slot.value = value;
        } else {
            start.put(index, start, value);
        }
    }

    public void delete(String name) {
        this.removeSlot(name, name.hashCode());
    }

    public void delete(int index) {
        this.removeSlot(null, index);
    }

    public final int getAttributes(String name, Scriptable start) throws PropertyException {
        return this.getAttributes(name);
    }

    public final int getAttributes(int index, Scriptable start) throws PropertyException {
        return this.getAttributes(index);
    }

    public final void setAttributes(String name, Scriptable start, int attributes) throws PropertyException {
        this.setAttributes(name, attributes);
    }

    public void setAttributes(int index, Scriptable start, int attributes) throws PropertyException {
        this.setAttributes(index, attributes);
    }

    public int getAttributes(String name) {
        Slot slot = this.getSlot(name, name.hashCode());
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", name);
        }
        return slot.attributes;
    }

    public int getAttributes(int index) {
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(index));
        }
        return slot.attributes;
    }

    public void setAttributes(String name, int attributes) {
        int mask = 7;
        attributes &= 7;
        Slot slot = this.getSlot(name, name.hashCode());
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", name);
        }
        slot.attributes = (short)attributes;
    }

    public void setAttributes(int index, int attributes) {
        int mask = 7;
        attributes &= 7;
        Slot slot = this.getSlot(null, index);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(index));
        }
        slot.attributes = (short)attributes;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable m) {
        this.prototype = m;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public void setParentScope(Scriptable m) {
        this.parent = m;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class typeHint) {
        Context cx = null;
        try {
            int i = 0;
            while (i < 2) {
                block23: {
                    Object u;
                    Object val;
                    block24: {
                        String hint;
                        block22: {
                            boolean bl = typeHint == ScriptRuntime.StringClass ? i == 0 : i == 1;
                            if (!bl) break block22;
                            Object v = ScriptableObject.getProperty((Scriptable)this, "toString");
                            if (!(v instanceof Function)) break block23;
                            Function fun = (Function)v;
                            if (cx == null) {
                                cx = Context.getContext();
                            }
                            val = fun.call(cx, fun.getParentScope(), this, ScriptRuntime.emptyArgs);
                            break block24;
                        }
                        if (typeHint == null) {
                            hint = "undefined";
                        } else if (typeHint == ScriptRuntime.StringClass) {
                            hint = "string";
                        } else if (typeHint == ScriptRuntime.ScriptableClass) {
                            hint = "object";
                        } else if (typeHint == ScriptRuntime.FunctionClass) {
                            hint = "function";
                        } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                            hint = "boolean";
                        } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                            hint = "number";
                        } else {
                            throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                        }
                        Object v = ScriptableObject.getProperty((Scriptable)this, "valueOf");
                        if (!(v instanceof Function)) break block23;
                        Function fun = (Function)v;
                        Object[] args = new Object[]{hint};
                        if (cx == null) {
                            cx = Context.getContext();
                        }
                        val = fun.call(cx, fun.getParentScope(), this, args);
                    }
                    if (!(val == null || val != Undefined.instance && val instanceof Scriptable && typeHint != ScriptRuntime.ScriptableClass && typeHint != ScriptRuntime.FunctionClass)) {
                        return val;
                    }
                    if (val instanceof NativeJavaObject && (u = ((Wrapper)val).unwrap()) instanceof String) {
                        return u;
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptException jse) {
            // empty catch block
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw ScriptRuntime.typeError1("msg.default.value", arg);
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public static void defineClass(Scriptable scope, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scope, clazz, false);
    }

    public static void defineClass(Scriptable scope, Class clazz, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        FunctionObject ctor;
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals("init")) {
                Class<?>[] parmTypes = method.getParameterTypes();
                if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                    method.invoke(null, args);
                    return;
                }
                if (parmTypes.length == 1 && parmTypes[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(method.getModifiers())) {
                    Object[] args = new Object[]{scope};
                    method.invoke(null, args);
                    return;
                }
            }
            ++i;
        }
        Constructor<?>[] ctors = clazz.getConstructors();
        Constructor<?> protoCtor = null;
        int i2 = 0;
        while (i2 < ctors.length) {
            if (ctors[i2].getParameterTypes().length == 0) {
                protoCtor = ctors[i2];
                break;
            }
            ++i2;
        }
        if (protoCtor == null) {
            throw new ClassDefinitionException(Context.getMessage1("msg.zero.arg.ctor", clazz.getName()));
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        proto.setPrototype(ScriptableObject.getObjectPrototype(scope));
        String className = proto.getClassName();
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        Executable ctorMember = FunctionObject.findSingleMethod(methods, "jsConstructor");
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (ctors[0].getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (ctors[1].getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw new ClassDefinitionException(Context.getMessage1("msg.ctor.multiple.parms", clazz.getName()));
            }
        }
        if ((ctor = new FunctionObject(className, ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.addAsConstructor(scope, proto);
        Method finishInit = null;
        int i3 = 0;
        while (i3 < methods.length) {
            block31: {
                String prefix;
                String name;
                block34: {
                    block36: {
                        block35: {
                            block33: {
                                block32: {
                                    Class<?>[] parmTypes;
                                    if (methods[i3] == ctorMember) break block31;
                                    name = methods[i3].getName();
                                    if (!name.equals("finishInit") || (parmTypes = methods[i3].getParameterTypes()).length != 3 || parmTypes[0] != ScriptRuntime.ScriptableClass || parmTypes[1] != (class$org$mozilla$javascript$FunctionObject == null ? ScriptableObject.class$("org.mozilla.javascript.FunctionObject") : class$org$mozilla$javascript$FunctionObject) || parmTypes[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methods[i3].getModifiers())) break block32;
                                    finishInit = methods[i3];
                                    break block31;
                                }
                                if (name.indexOf(36) != -1 || name.equals("jsConstructor")) break block31;
                                prefix = null;
                                if (!name.startsWith("jsFunction_")) break block33;
                                prefix = "jsFunction_";
                                break block34;
                            }
                            if (!name.startsWith("jsStaticFunction_")) break block35;
                            prefix = "jsStaticFunction_";
                            if (!Modifier.isStatic(methods[i3].getModifiers())) {
                                throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                            }
                            break block34;
                        }
                        if (!name.startsWith("jsGet_")) break block36;
                        prefix = "jsGet_";
                        break block34;
                    }
                    if (!name.startsWith("jsSet_")) break block31;
                    prefix = "jsSet_";
                }
                name = name.substring(prefix.length());
                if (prefix != "jsSet_") {
                    if (prefix == "jsGet_") {
                        if (!(proto instanceof ScriptableObject)) {
                            throw PropertyException.withMessage2("msg.extend.scriptable", proto.getClass().toString(), name);
                        }
                        Method setter = FunctionObject.findSingleMethod(methods, "jsSet_" + name);
                        int attr = 6 | (setter != null ? 0 : 1);
                        ((ScriptableObject)proto).defineProperty(name, null, methods[i3], setter, attr);
                    } else {
                        FunctionObject f = new FunctionObject(name, methods[i3], proto);
                        if (f.isVarArgsConstructor()) {
                            throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
                        }
                        Scriptable dest = prefix == "jsStaticFunction_" ? ctor : proto;
                        ScriptableObject.defineProperty(dest, name, f, 2);
                        if (sealed) {
                            f.sealObject();
                        }
                    }
                }
            }
            ++i3;
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
            }
        }
    }

    public void defineProperty(String propertyName, Object value, int attributes) {
        this.put(propertyName, (Scriptable)this, value);
        this.setAttributes(propertyName, attributes);
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value, int attributes) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(propertyName, destination, value);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(propertyName, value, attributes);
    }

    public void defineProperty(String propertyName, Class clazz, int attributes) throws PropertyException {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods = FunctionObject.getMethodList(clazz);
        Method getter = FunctionObject.findSingleMethod(methods, getterName);
        Method setter = FunctionObject.findSingleMethod(methods, setterName);
        if (setter == null) {
            attributes |= 1;
        }
        this.defineProperty(propertyName, null, getter, setter == null ? null : setter, attributes);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) throws PropertyException {
        Class<?>[] parmTypes;
        int flags = 1;
        if (delegateTo == null && Modifier.isStatic(getter.getModifiers())) {
            delegateTo = HAS_STATIC_ACCESSORS;
        }
        if ((parmTypes = getter.getParameterTypes()).length != 0) {
            if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableObjectClass) {
                throw PropertyException.withMessage1("msg.bad.getter.parms", getter.toString());
            }
        } else if (delegateTo != null) {
            throw PropertyException.withMessage1("msg.obj.getter.parms", getter.toString());
        }
        if (setter != null) {
            Class<?> setterType;
            int setterTypeTag;
            flags |= 2;
            if (delegateTo == HAS_STATIC_ACCESSORS != Modifier.isStatic(setter.getModifiers())) {
                throw PropertyException.withMessage0("msg.getter.static");
            }
            parmTypes = setter.getParameterTypes();
            if (parmTypes.length == 2) {
                if (parmTypes[0] != ScriptRuntime.ScriptableObjectClass) {
                    throw PropertyException.withMessage0("msg.setter2.parms");
                }
                if (delegateTo == null) {
                    throw PropertyException.withMessage1("msg.setter1.parms", setter.toString());
                }
            } else if (parmTypes.length == 1) {
                if (delegateTo != null) {
                    throw PropertyException.withMessage1("msg.setter2.expected", setter.toString());
                }
            } else {
                throw PropertyException.withMessage0("msg.setter.parms");
            }
            if ((setterTypeTag = FunctionObject.getTypeTag(setterType = parmTypes[parmTypes.length - 1])) == 0) {
                throw PropertyException.withMessage2("msg.setter2.expected", setterType.getName(), setter.toString());
            }
        }
        ClassCache cache = ClassCache.get(this);
        GetterSlot slot = new GetterSlot();
        slot.delegateTo = delegateTo;
        slot.getter = new MemberBox(getter, cache);
        slot.getter.prepareInvokerOptimization();
        if (setter != null) {
            slot.setter = new MemberBox(setter, cache);
            slot.setter.prepareInvokerOptimization();
            slot.setterReturnsValue = setter.getReturnType() != Void.TYPE;
        }
        slot.value = null;
        slot.attributes = (short)attributes;
        slot.flags = (byte)flags;
        Slot inserted = this.addSlot(propertyName, propertyName.hashCode(), slot);
        if (inserted != slot) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] names, Class clazz, int attributes) throws PropertyException {
        Method[] methods = FunctionObject.getMethodList(clazz);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            Method m = FunctionObject.findSingleMethod(methods, name);
            if (m == null) {
                throw PropertyException.withMessage2("msg.method.not.found", name, clazz.getName());
            }
            FunctionObject f = new FunctionObject(name, m, this);
            this.defineProperty(name, f, attributes);
            ++i;
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return ScriptableObject.getClassPrototype(scope, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor == Scriptable.NOT_FOUND || !(ctor instanceof Scriptable)) {
            return null;
        }
        Scriptable ctorObj = (Scriptable)ctor;
        if (!ctorObj.has("prototype", ctorObj)) {
            return null;
        }
        Object proto = ctorObj.get("prototype", ctorObj);
        if (!(proto instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)proto;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable next = obj;
        while ((next = (obj = next).getParentScope()) != null) {
        }
        return obj;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static Object getProperty(Scriptable obj, int index) {
        Object result;
        Scriptable start = obj;
        while ((result = obj.get(index, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result;
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return null != ScriptableObject.getBase(obj, name);
    }

    public static boolean hasProperty(Scriptable obj, int index) {
        return null != ScriptableObject.getBase(obj, index);
    }

    public static void putProperty(Scriptable obj, String name, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value);
    }

    public static void putProperty(Scriptable obj, int index, Object value) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            base = obj;
        }
        base.put(index, obj, value);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index) {
        Scriptable base = ScriptableObject.getBase(obj, index);
        if (base == null) {
            return true;
        }
        base.delete(index);
        return !base.has(index, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result = obj.getIds();
        ObjToIntMap map = null;
        while ((obj = obj.getPrototype()) != null) {
            int i;
            Object[] ids = obj.getIds();
            if (ids.length == 0) continue;
            if (result.length == 0) {
                result = ids;
                continue;
            }
            if (map == null) {
                i = 0;
                while (i != result.length) {
                    map.intern(result[i]);
                    ++i;
                }
                result = null;
            }
            i = 0;
            while (i != ids.length) {
                map.intern(ids[i]);
                ++i;
            }
        }
        if (map != null) {
            result = map.getKeys();
        }
        return result;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args) throws JavaScriptException {
        Object funObj = ScriptableObject.getProperty(obj, methodName);
        if (!(funObj instanceof Function)) {
            throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(obj) + '.' + methodName);
        }
        Function fun = (Function)funObj;
        return Context.call(fun, ScriptableObject.getTopLevelScope(obj), obj, args);
    }

    private static Scriptable getBase(Scriptable obj, String name) {
        Scriptable start = obj;
        while (!obj.has(name, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, int index) {
        Scriptable start = obj;
        while (!obj.has(index, start) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    public final Object getAssociatedValue(Object key) {
        Hashtable h = this.associatedValues;
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public final Object associateValue(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Hashtable h = this.associatedValues;
        if (h == null) {
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                h = this.associatedValues;
                if (h == null) {
                    this.associatedValues = h = new Hashtable();
                }
            }
        }
        return Kit.initHash(h, key, value);
    }

    private Slot getNamedSlot(String name) {
        Slot slot = this.lastAccess;
        if (name == slot.stringKey && slot.wasDeleted == 0) {
            return slot;
        }
        Slot[] slots = this.slots;
        int hash = name.hashCode();
        int i = ScriptableObject.getSlotPosition(slots, name, hash);
        if (i < 0) {
            return null;
        }
        slot = slots[i];
        slot.stringKey = name;
        this.lastAccess = slot;
        return slot;
    }

    private Slot getSlot(String id, int index) {
        Slot[] slots = this.slots;
        int i = ScriptableObject.getSlotPosition(slots, id, index);
        return i < 0 ? null : slots[i];
    }

    private static int getSlotPosition(Slot[] slots, String id, int index) {
        if (slots != null) {
            Slot slot;
            int start;
            int i = start = (index & Integer.MAX_VALUE) % slots.length;
            while ((slot = slots[i]) != null) {
                if (slot != REMOVED && slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                    return i;
                }
                if (++i == slots.length) {
                    i = 0;
                }
                if (i != start) continue;
            }
        }
        return -1;
    }

    private synchronized Slot addSlot(String id, int index, Slot newSlot) {
        if (this.isSealed()) {
            String str = id != null ? id : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.add.sealed", str);
        }
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        return this.addSlotImpl(id, index, newSlot);
    }

    private Slot addSlotImpl(String id, int index, Slot newSlot) {
        int start;
        int i = start = (index & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[i]) == null || slot == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.addSlotImpl(id, index, newSlot);
                }
                slot = newSlot == null ? new Slot() : newSlot;
                slot.stringKey = id;
                slot.intKey = index;
                this.slots[i] = slot;
                ++this.count;
                return slot;
            }
            if (slot.intKey == index && (slot.stringKey == id || id != null && id.equals(slot.stringKey))) {
                return slot;
            }
            if (++i != this.slots.length) continue;
            i = 0;
        } while (i != start);
        Kit.codeBug();
        return null;
    }

    private synchronized void removeSlot(String name, int index) {
        if (this.isSealed()) {
            String str = name != null ? name : Integer.toString(index);
            throw Context.reportRuntimeError1("msg.remove.sealed", str);
        }
        int i = ScriptableObject.getSlotPosition(this.slots, name, index);
        if (i >= 0) {
            Slot slot = this.slots[i];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                this.slots[i] = REMOVED;
                --this.count;
                if (slot == this.lastAccess) {
                    this.lastAccess = REMOVED;
                }
            }
        }
    }

    private void grow() {
        Slot[] newSlots = new Slot[this.slots.length * 2 + 1];
        int j = this.slots.length - 1;
        while (j >= 0) {
            Slot slot = this.slots[j];
            if (slot != null && slot != REMOVED) {
                int k = (slot.intKey & Integer.MAX_VALUE) % newSlots.length;
                while (newSlots[k] != null) {
                    if (++k != newSlots.length) continue;
                    k = 0;
                }
                newSlots[k] = slot;
            }
            --j;
        }
        this.slots = newSlots;
    }

    Object[] getIds(boolean getAll) {
        Slot[] s = this.slots;
        Object[] a = ScriptRuntime.emptyArgs;
        if (s == null) {
            return a;
        }
        int c = 0;
        int i = 0;
        while (i < s.length) {
            Slot slot = s[i];
            if (slot != null && slot != REMOVED && (getAll || (slot.attributes & 2) == 0)) {
                if (c == 0) {
                    a = new Object[s.length - i];
                }
                a[c++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
            }
            ++i;
        }
        if (c == a.length) {
            return a;
        }
        Object[] result = new Object[c];
        System.arraycopy(a, 0, result, 0, c);
        return result;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        Slot[] s;
        out.defaultWriteObject();
        int N = this.count;
        if (N < 0) {
            N = -1 - this.count;
        }
        if ((s = this.slots) == null) {
            if (N != 0) {
                Kit.codeBug();
            }
            out.writeInt(0);
        } else {
            out.writeInt(s.length);
            int i = 0;
            while (N != 0) {
                Slot slot = s[i];
                if (slot != null && slot != REMOVED) {
                    --N;
                    out.writeObject(slot);
                }
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lastAccess = REMOVED;
        int capacity = in.readInt();
        if (capacity != 0) {
            this.slots = new Slot[capacity];
            int N = this.count;
            boolean wasSealed = false;
            if (N < 0) {
                N = -1 - N;
                wasSealed = true;
            }
            this.count = 0;
            int i = 0;
            while (i != N) {
                Slot s = (Slot)in.readObject();
                this.addSlotImpl(s.stringKey, s.intKey, s);
                ++i;
            }
            if (wasSealed) {
                this.count = -1 - this.count;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GetterSlot
    extends Slot {
        Object delegateTo;
        MemberBox getter;
        MemberBox setter;
        boolean setterReturnsValue;

        GetterSlot() {
        }
    }

    private static class Slot
    implements Serializable {
        static final int HAS_GETTER = 1;
        static final int HAS_SETTER = 2;
        static final long serialVersionUID = -2158009919774350004L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        byte flags;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }
    }
}

