#!/bin/sh
form_element_list=$*
old_file="form_element_list.cc"
new_file="form_element_list.cc.new"

cat > ${new_file} << EOF1
// file automatically generated by: $0
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/form_element.h"
EOF1

for x in ${form_element_list}; do
  echo "#include \"${x}.h\"" >> ${new_file}
done

cat >> ${new_file} << EOF2
namespace rheolef {
using namespace std;

template<class T, class M>
form_element_rep<T,M>* 
form_element_rep<T,M>::make_ptr (
    string                name,
    const space_type&     X,
    const space_type&     Y,
    const geo_type&       omega,
    const quadrature_option_type& qopt)
{
  // TODO: use gperf instead of a long if-else test suite
  if (name == "")          return 0;
EOF2

for x in ${form_element_list}; do
  if test $x != "2D_D" -a $x != "2D"; then
    y=$x
  else
    y="_${x}"
  fi
  echo "  if (name == \"${x}\") return new_macro ((${y}<T,M>)(X,Y,omega,qopt));" >> ${new_file}
done


cat >> ${new_file} << EOF3
  error_macro ("undefined form_element \"" << name << "\"");
  return 0;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class form_element_rep<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class form_element_rep<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
EOF3


if test ! -f ${old_file}; then
  mv ${new_file} ${old_file}
  echo "! file ${old_file} created." 1>&2
elif diff ${old_file} ${new_file} >/dev/null; then
  echo "! file ${old_file} unchanged." 1>&2
  rm -f ${new_file}
else
  mv ${new_file} ${old_file}
  echo "! file ${old_file} modified." 1>&2
fi

exit 0
