#include "rheolef.h"
#include "rheolef/catchmark.h"
using namespace rheolef;
using namespace std;
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  const Float epsilon = 0.01;
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  Xh.block ("left");
  Xh.block ("right");
  string eta_approx = "P" + itos(Xh.degree()-1) + "d";
  space Qh (omega, eta_approx);
  field eta (Qh);
  eta ["east"] = 1;
  eta ["west"] = epsilon;
  form a (Xh, Xh, "grad_grad", eta);
  field lh = riesz (Xh, 1);
  field uh (Xh);
  uh["left"] = uh["right"] = 0;
  solver sa (a.uu());
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << catchmark("epsilon") << epsilon << endl
       << catchmark("u")       << uh;
}
