#include "gtkUtils.h"
#include "gnomeuiEnum.h"

#include "RGtk.h"

USER_OBJECT_
S_check_GnomeClientState_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"idle",
		"saving-phase-1",
		"waiting-for-phase-2",
		"saving-phase-2",
		"frozen",
		"disconnected"};
  static const char * const realNames[]  = {"GNOME_CLIENT_IDLE",
		"GNOME_CLIENT_SAVING_PHASE_1",
		"GNOME_CLIENT_WAITING_FOR_PHASE_2",
		"GNOME_CLIENT_SAVING_PHASE_2",
		"GNOME_CLIENT_FROZEN",
		"GNOME_CLIENT_DISCONNECTED"};
  static const int        cValues[]      = {GNOME_CLIENT_IDLE,
	GNOME_CLIENT_SAVING_PHASE_1,
	GNOME_CLIENT_WAITING_FOR_PHASE_2,
	GNOME_CLIENT_SAVING_PHASE_2,
	GNOME_CLIENT_FROZEN,
	GNOME_CLIENT_DISCONNECTED};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GnomeClientState"));
}
 

USER_OBJECT_
S_check_GnomeUIInfoType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"endofinfo",
		"item",
		"toggleitem",
		"radioitems",
		"subtree",
		"separator",
		"help",
		"builder-data"};
  static const char * const realNames[]  = {"GNOME_APP_UI_ENDOFINFO",
		"GNOME_APP_UI_ITEM",
		"GNOME_APP_UI_TOGGLEITEM",
		"GNOME_APP_UI_RADIOITEMS",
		"GNOME_APP_UI_SUBTREE",
		"GNOME_APP_UI_SEPARATOR",
		"GNOME_APP_UI_HELP",
		"GNOME_APP_UI_BUILDER_DATA"};
  static const int        cValues[]      = {GNOME_APP_UI_ENDOFINFO,
	GNOME_APP_UI_ITEM,
	GNOME_APP_UI_TOGGLEITEM,
	GNOME_APP_UI_RADIOITEMS,
	GNOME_APP_UI_SUBTREE,
	GNOME_APP_UI_SEPARATOR,
	GNOME_APP_UI_HELP,
	GNOME_APP_UI_BUILDER_DATA};
  return(S_checkEnum(val, localNames, realNames, cValues, 8,"GnomeUIInfoType"));
}
 

USER_OBJECT_
S_check_GnomeCalculatorMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"deg",
		"rad",
		"grad"};
  static const char * const realNames[]  = {"GNOME_CALCULATOR_DEG",
		"GNOME_CALCULATOR_RAD",
		"GNOME_CALCULATOR_GRAD"};
  static const int        cValues[]      = {GNOME_CALCULATOR_DEG,
	GNOME_CALCULATOR_RAD,
	GNOME_CALCULATOR_GRAD};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomeCalculatorMode"));
}
 

USER_OBJECT_
S_check_GnomeSaveStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"global",
		"local",
		"both"};
  static const char * const realNames[]  = {"GNOME_SAVE_GLOBAL",
		"GNOME_SAVE_LOCAL",
		"GNOME_SAVE_BOTH"};
  static const int        cValues[]      = {GNOME_SAVE_GLOBAL,
	GNOME_SAVE_LOCAL,
	GNOME_SAVE_BOTH};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomeSaveStyle"));
}
 

USER_OBJECT_
S_check_GtkClockType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"increasing",
		"decreasing",
		"realtime"};
  static const char * const realNames[]  = {"GTK_CLOCK_INCREASING",
		"GTK_CLOCK_DECREASING",
		"GTK_CLOCK_REALTIME"};
  static const int        cValues[]      = {GTK_CLOCK_INCREASING,
	GTK_CLOCK_DECREASING,
	GTK_CLOCK_REALTIME};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GtkClockType"));
}
 

USER_OBJECT_
S_check_GnomeAnimatorStatus_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"stopped",
		"running"};
  static const char * const realNames[]  = {"GNOME_ANIMATOR_STATUS_STOPPED",
		"GNOME_ANIMATOR_STATUS_RUNNING"};
  static const int        cValues[]      = {GNOME_ANIMATOR_STATUS_STOPPED,
	GNOME_ANIMATOR_STATUS_RUNNING};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GnomeAnimatorStatus"));
}
 

USER_OBJECT_
S_check_GnomeDialogType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"error",
		"normal"};
  static const char * const realNames[]  = {"GNOME_DIALOG_ERROR",
		"GNOME_DIALOG_NORMAL"};
  static const int        cValues[]      = {GNOME_DIALOG_ERROR,
	GNOME_DIALOG_NORMAL};
  return(S_checkEnum(val, localNames, realNames, cValues, 2,"GnomeDialogType"));
}
 

USER_OBJECT_
S_check_GnomeDockPlacement_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"top",
		"right",
		"bottom",
		"left",
		"floating"};
  static const char * const realNames[]  = {"GNOME_DOCK_TOP",
		"GNOME_DOCK_RIGHT",
		"GNOME_DOCK_BOTTOM",
		"GNOME_DOCK_LEFT",
		"GNOME_DOCK_FLOATING"};
  static const int        cValues[]      = {GNOME_DOCK_TOP,
	GNOME_DOCK_RIGHT,
	GNOME_DOCK_BOTTOM,
	GNOME_DOCK_LEFT,
	GNOME_DOCK_FLOATING};
  return(S_checkEnum(val, localNames, realNames, cValues, 5,"GnomeDockPlacement"));
}
 

USER_OBJECT_
S_check_GnomeWinLayer_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"desktop",
		"below",
		"normal",
		"ontop",
		"dock",
		"above-dock"};
  static const char * const realNames[]  = {"WIN_LAYER_DESKTOP",
		"WIN_LAYER_BELOW",
		"WIN_LAYER_NORMAL",
		"WIN_LAYER_ONTOP",
		"WIN_LAYER_DOCK",
		"WIN_LAYER_ABOVE_DOCK"};
  static const int        cValues[]      = {WIN_LAYER_DESKTOP,
	WIN_LAYER_BELOW,
	WIN_LAYER_NORMAL,
	WIN_LAYER_ONTOP,
	WIN_LAYER_DOCK,
	WIN_LAYER_ABOVE_DOCK};
  return(S_checkEnum(val, localNames, realNames, cValues, 6,"GnomeWinLayer"));
}
 

USER_OBJECT_
S_check_GnomeUIPixmapType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"stock",
		"data",
		"filename"};
  static const char * const realNames[]  = {"GNOME_APP_PIXMAP_NONE",
		"GNOME_APP_PIXMAP_STOCK",
		"GNOME_APP_PIXMAP_DATA",
		"GNOME_APP_PIXMAP_FILENAME"};
  static const int        cValues[]      = {GNOME_APP_PIXMAP_NONE,
	GNOME_APP_PIXMAP_STOCK,
	GNOME_APP_PIXMAP_DATA,
	GNOME_APP_PIXMAP_FILENAME};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GnomeUIPixmapType"));
}
 

USER_OBJECT_
S_check_GnomeStockPixmapType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"data",
		"file",
		"path",
		"widget",
		"imlib",
		"imlib-scaled",
		"gpixmap"};
  static const char * const realNames[]  = {"GNOME_STOCK_PIXMAP_TYPE_NONE",
		"GNOME_STOCK_PIXMAP_TYPE_DATA",
		"GNOME_STOCK_PIXMAP_TYPE_FILE",
		"GNOME_STOCK_PIXMAP_TYPE_PATH",
		"GNOME_STOCK_PIXMAP_TYPE_WIDGET",
		"GNOME_STOCK_PIXMAP_TYPE_IMLIB",
		"GNOME_STOCK_PIXMAP_TYPE_IMLIB_SCALED",
		"GNOME_STOCK_PIXMAP_TYPE_GPIXMAP"};
  static const int        cValues[]      = {GNOME_STOCK_PIXMAP_TYPE_NONE,
	GNOME_STOCK_PIXMAP_TYPE_DATA,
	GNOME_STOCK_PIXMAP_TYPE_FILE,
	GNOME_STOCK_PIXMAP_TYPE_PATH,
	GNOME_STOCK_PIXMAP_TYPE_WIDGET,
	GNOME_STOCK_PIXMAP_TYPE_IMLIB,
	GNOME_STOCK_PIXMAP_TYPE_IMLIB_SCALED,
	GNOME_STOCK_PIXMAP_TYPE_GPIXMAP};
  return(S_checkEnum(val, localNames, realNames, cValues, 8,"GnomeStockPixmapType"));
}
 

USER_OBJECT_
S_check_GnomeWinAppState_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"active1",
		"active2",
		"error1",
		"error2",
		"fatal-error1",
		"fatal-error2",
		"idle1",
		"idle2",
		"waiting1",
		"waiting2",
		"working1",
		"working2",
		"need-user-input1",
		"need-user-input2",
		"struggling1",
		"struggling2",
		"disk-traffic1",
		"disk-traffic2",
		"network-traffic1",
		"network-traffic2",
		"overloaded1",
		"overloaded2",
		"percent000-1",
		"percent000-2",
		"percent010-1",
		"percent010-2",
		"percent020-1",
		"percent020-2",
		"percent030-1",
		"percent030-2",
		"percent040-1",
		"percent040-2",
		"percent050-1",
		"percent050-2",
		"percent060-1",
		"percent060-2",
		"percent070-1",
		"percent070-2",
		"percent080-1",
		"percent080-2",
		"percent090-1",
		"percent090-2",
		"percent100-1",
		"percent100-2"};
  static const char * const realNames[]  = {"WIN_APP_STATE_NONE",
		"WIN_APP_STATE_ACTIVE1",
		"WIN_APP_STATE_ACTIVE2",
		"WIN_APP_STATE_ERROR1",
		"WIN_APP_STATE_ERROR2",
		"WIN_APP_STATE_FATAL_ERROR1",
		"WIN_APP_STATE_FATAL_ERROR2",
		"WIN_APP_STATE_IDLE1",
		"WIN_APP_STATE_IDLE2",
		"WIN_APP_STATE_WAITING1",
		"WIN_APP_STATE_WAITING2",
		"WIN_APP_STATE_WORKING1",
		"WIN_APP_STATE_WORKING2",
		"WIN_APP_STATE_NEED_USER_INPUT1",
		"WIN_APP_STATE_NEED_USER_INPUT2",
		"WIN_APP_STATE_STRUGGLING1",
		"WIN_APP_STATE_STRUGGLING2",
		"WIN_APP_STATE_DISK_TRAFFIC1",
		"WIN_APP_STATE_DISK_TRAFFIC2",
		"WIN_APP_STATE_NETWORK_TRAFFIC1",
		"WIN_APP_STATE_NETWORK_TRAFFIC2",
		"WIN_APP_STATE_OVERLOADED1",
		"WIN_APP_STATE_OVERLOADED2",
		"WIN_APP_STATE_PERCENT000_1",
		"WIN_APP_STATE_PERCENT000_2",
		"WIN_APP_STATE_PERCENT010_1",
		"WIN_APP_STATE_PERCENT010_2",
		"WIN_APP_STATE_PERCENT020_1",
		"WIN_APP_STATE_PERCENT020_2",
		"WIN_APP_STATE_PERCENT030_1",
		"WIN_APP_STATE_PERCENT030_2",
		"WIN_APP_STATE_PERCENT040_1",
		"WIN_APP_STATE_PERCENT040_2",
		"WIN_APP_STATE_PERCENT050_1",
		"WIN_APP_STATE_PERCENT050_2",
		"WIN_APP_STATE_PERCENT060_1",
		"WIN_APP_STATE_PERCENT060_2",
		"WIN_APP_STATE_PERCENT070_1",
		"WIN_APP_STATE_PERCENT070_2",
		"WIN_APP_STATE_PERCENT080_1",
		"WIN_APP_STATE_PERCENT080_2",
		"WIN_APP_STATE_PERCENT090_1",
		"WIN_APP_STATE_PERCENT090_2",
		"WIN_APP_STATE_PERCENT100_1",
		"WIN_APP_STATE_PERCENT100_2"};
  static const int        cValues[]      = {WIN_APP_STATE_NONE,
	WIN_APP_STATE_ACTIVE1,
	WIN_APP_STATE_ACTIVE2,
	WIN_APP_STATE_ERROR1,
	WIN_APP_STATE_ERROR2,
	WIN_APP_STATE_FATAL_ERROR1,
	WIN_APP_STATE_FATAL_ERROR2,
	WIN_APP_STATE_IDLE1,
	WIN_APP_STATE_IDLE2,
	WIN_APP_STATE_WAITING1,
	WIN_APP_STATE_WAITING2,
	WIN_APP_STATE_WORKING1,
	WIN_APP_STATE_WORKING2,
	WIN_APP_STATE_NEED_USER_INPUT1,
	WIN_APP_STATE_NEED_USER_INPUT2,
	WIN_APP_STATE_STRUGGLING1,
	WIN_APP_STATE_STRUGGLING2,
	WIN_APP_STATE_DISK_TRAFFIC1,
	WIN_APP_STATE_DISK_TRAFFIC2,
	WIN_APP_STATE_NETWORK_TRAFFIC1,
	WIN_APP_STATE_NETWORK_TRAFFIC2,
	WIN_APP_STATE_OVERLOADED1,
	WIN_APP_STATE_OVERLOADED2,
	WIN_APP_STATE_PERCENT000_1,
	WIN_APP_STATE_PERCENT000_2,
	WIN_APP_STATE_PERCENT010_1,
	WIN_APP_STATE_PERCENT010_2,
	WIN_APP_STATE_PERCENT020_1,
	WIN_APP_STATE_PERCENT020_2,
	WIN_APP_STATE_PERCENT030_1,
	WIN_APP_STATE_PERCENT030_2,
	WIN_APP_STATE_PERCENT040_1,
	WIN_APP_STATE_PERCENT040_2,
	WIN_APP_STATE_PERCENT050_1,
	WIN_APP_STATE_PERCENT050_2,
	WIN_APP_STATE_PERCENT060_1,
	WIN_APP_STATE_PERCENT060_2,
	WIN_APP_STATE_PERCENT070_1,
	WIN_APP_STATE_PERCENT070_2,
	WIN_APP_STATE_PERCENT080_1,
	WIN_APP_STATE_PERCENT080_2,
	WIN_APP_STATE_PERCENT090_1,
	WIN_APP_STATE_PERCENT090_2,
	WIN_APP_STATE_PERCENT100_1,
	WIN_APP_STATE_PERCENT100_2};
  return(S_checkEnum(val, localNames, realNames, cValues, 45,"GnomeWinAppState"));
}
 

USER_OBJECT_
S_check_GnomeIconListMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"icons",
		"text-below",
		"text-right"};
  static const char * const realNames[]  = {"GNOME_ICON_LIST_ICONS",
		"GNOME_ICON_LIST_TEXT_BELOW",
		"GNOME_ICON_LIST_TEXT_RIGHT"};
  static const int        cValues[]      = {GNOME_ICON_LIST_ICONS,
	GNOME_ICON_LIST_TEXT_BELOW,
	GNOME_ICON_LIST_TEXT_RIGHT};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomeIconListMode"));
}
 

USER_OBJECT_
S_check_GnomeFontPickerMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"pixmap",
		"font-info",
		"user-widget"};
  static const char * const realNames[]  = {"GNOME_FONT_PICKER_MODE_PIXMAP",
		"GNOME_FONT_PICKER_MODE_FONT_INFO",
		"GNOME_FONT_PICKER_MODE_USER_WIDGET"};
  static const int        cValues[]      = {GNOME_FONT_PICKER_MODE_PIXMAP,
	GNOME_FONT_PICKER_MODE_FONT_INFO,
	GNOME_FONT_PICKER_MODE_USER_WIDGET};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomeFontPickerMode"));
}
 

USER_OBJECT_
S_check_GnomeAnimatorLoopType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"restart",
		"ping-pong"};
  static const char * const realNames[]  = {"GNOME_ANIMATOR_LOOP_NONE",
		"GNOME_ANIMATOR_LOOP_RESTART",
		"GNOME_ANIMATOR_LOOP_PING_PONG"};
  static const int        cValues[]      = {GNOME_ANIMATOR_LOOP_NONE,
	GNOME_ANIMATOR_LOOP_RESTART,
	GNOME_ANIMATOR_LOOP_PING_PONG};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomeAnimatorLoopType"));
}
 

USER_OBJECT_
S_check_GnomeRestartStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"if-running",
		"anyway",
		"immediately",
		"never"};
  static const char * const realNames[]  = {"GNOME_RESTART_IF_RUNNING",
		"GNOME_RESTART_ANYWAY",
		"GNOME_RESTART_IMMEDIATELY",
		"GNOME_RESTART_NEVER"};
  static const int        cValues[]      = {GNOME_RESTART_IF_RUNNING,
	GNOME_RESTART_ANYWAY,
	GNOME_RESTART_IMMEDIATELY,
	GNOME_RESTART_NEVER};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GnomeRestartStyle"));
}
 

USER_OBJECT_
S_check_GnomePreferencesType_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"never",
		"user",
		"always"};
  static const char * const realNames[]  = {"GNOME_PREFERENCES_NEVER",
		"GNOME_PREFERENCES_USER",
		"GNOME_PREFERENCES_ALWAYS"};
  static const int        cValues[]      = {GNOME_PREFERENCES_NEVER,
	GNOME_PREFERENCES_USER,
	GNOME_PREFERENCES_ALWAYS};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomePreferencesType"));
}
 

USER_OBJECT_
S_check_GnomePropertyAction_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"apply",
		"update",
		"load",
		"save",
		"load-temp",
		"save-temp",
		"discard-temp",
		"changed"};
  static const char * const realNames[]  = {"GNOME_PROPERTY_ACTION_APPLY",
		"GNOME_PROPERTY_ACTION_UPDATE",
		"GNOME_PROPERTY_ACTION_LOAD",
		"GNOME_PROPERTY_ACTION_SAVE",
		"GNOME_PROPERTY_ACTION_LOAD_TEMP",
		"GNOME_PROPERTY_ACTION_SAVE_TEMP",
		"GNOME_PROPERTY_ACTION_DISCARD_TEMP",
		"GNOME_PROPERTY_ACTION_CHANGED"};
  static const int        cValues[]      = {GNOME_PROPERTY_ACTION_APPLY,
	GNOME_PROPERTY_ACTION_UPDATE,
	GNOME_PROPERTY_ACTION_LOAD,
	GNOME_PROPERTY_ACTION_SAVE,
	GNOME_PROPERTY_ACTION_LOAD_TEMP,
	GNOME_PROPERTY_ACTION_SAVE_TEMP,
	GNOME_PROPERTY_ACTION_DISCARD_TEMP,
	GNOME_PROPERTY_ACTION_CHANGED};
  return(S_checkEnum(val, localNames, realNames, cValues, 8,"GnomePropertyAction"));
}
 

USER_OBJECT_
S_check_GnomeInteractStyle_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"none",
		"errors",
		"any"};
  static const char * const realNames[]  = {"GNOME_INTERACT_NONE",
		"GNOME_INTERACT_ERRORS",
		"GNOME_INTERACT_ANY"};
  static const int        cValues[]      = {GNOME_INTERACT_NONE,
	GNOME_INTERACT_ERRORS,
	GNOME_INTERACT_ANY};
  return(S_checkEnum(val, localNames, realNames, cValues, 3,"GnomeInteractStyle"));
}
 

USER_OBJECT_
S_check_GnomeMDIMode_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"notebook",
		"toplevel",
		"modal",
		"default-mode"};
  static const char * const realNames[]  = {"GNOME_MDI_NOTEBOOK",
		"GNOME_MDI_TOPLEVEL",
		"GNOME_MDI_MODAL",
		"GNOME_MDI_DEFAULT_MODE"};
  static const int        cValues[]      = {GNOME_MDI_NOTEBOOK,
	GNOME_MDI_TOPLEVEL,
	GNOME_MDI_MODAL,
	GNOME_MDI_DEFAULT_MODE};
  return(S_checkEnum(val, localNames, realNames, cValues, 4,"GnomeMDIMode"));
}
 

USER_OBJECT_
S_check_GnomeDateEditFlags_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"show-time",
		"a-24-hr",
		"week-starts-on-monday"};
  static const char * const realNames[]  = {"GNOME_DATE_EDIT_SHOW_TIME",
		"GNOME_DATE_EDIT_24_HR",
		"GNOME_DATE_EDIT_WEEK_STARTS_ON_MONDAY"};
  static const int        cValues[]      = {GNOME_DATE_EDIT_SHOW_TIME,
	GNOME_DATE_EDIT_24_HR,
	GNOME_DATE_EDIT_WEEK_STARTS_ON_MONDAY};
  return(S_checkFlag(val, localNames, realNames, cValues, 3,"GnomeDateEditFlags"));
}
 

USER_OBJECT_
S_check_GnomeWinState_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"sticky",
		"minimized",
		"maximized-vert",
		"maximized-horiz",
		"hidden",
		"shaded",
		"hid-workspace",
		"hid-transient",
		"fixed-position",
		"arrange-ignore"};
  static const char * const realNames[]  = {"WIN_STATE_STICKY",
		"WIN_STATE_MINIMIZED",
		"WIN_STATE_MAXIMIZED_VERT",
		"WIN_STATE_MAXIMIZED_HORIZ",
		"WIN_STATE_HIDDEN",
		"WIN_STATE_SHADED",
		"WIN_STATE_HID_WORKSPACE",
		"WIN_STATE_HID_TRANSIENT",
		"WIN_STATE_FIXED_POSITION",
		"WIN_STATE_ARRANGE_IGNORE"};
  static const int        cValues[]      = {WIN_STATE_STICKY,
	WIN_STATE_MINIMIZED,
	WIN_STATE_MAXIMIZED_VERT,
	WIN_STATE_MAXIMIZED_HORIZ,
	WIN_STATE_HIDDEN,
	WIN_STATE_SHADED,
	WIN_STATE_HID_WORKSPACE,
	WIN_STATE_HID_TRANSIENT,
	WIN_STATE_FIXED_POSITION,
	WIN_STATE_ARRANGE_IGNORE};
  return(S_checkFlag(val, localNames, realNames, cValues, 10,"GnomeWinState"));
}
 

USER_OBJECT_
S_check_GnomeWinHints_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"skip-focus",
		"skip-winlist",
		"skip-taskbar",
		"group-transient",
		"focus-on-click"};
  static const char * const realNames[]  = {"WIN_HINTS_SKIP_FOCUS",
		"WIN_HINTS_SKIP_WINLIST",
		"WIN_HINTS_SKIP_TASKBAR",
		"WIN_HINTS_GROUP_TRANSIENT",
		"WIN_HINTS_FOCUS_ON_CLICK"};
  static const int        cValues[]      = {WIN_HINTS_SKIP_FOCUS,
	WIN_HINTS_SKIP_WINLIST,
	WIN_HINTS_SKIP_TASKBAR,
	WIN_HINTS_GROUP_TRANSIENT,
	WIN_HINTS_FOCUS_ON_CLICK};
  return(S_checkFlag(val, localNames, realNames, cValues, 5,"GnomeWinHints"));
}
 

USER_OBJECT_
S_check_GnomeDockItemBehavior_value(USER_OBJECT_ val)
{
  static const char * const localNames[] = {"normal",
		"exclusive",
		"never-floating",
		"never-vertical",
		"never-horizontal",
		"locked"};
  static const char * const realNames[]  = {"GNOME_DOCK_ITEM_BEH_NORMAL",
		"GNOME_DOCK_ITEM_BEH_EXCLUSIVE",
		"GNOME_DOCK_ITEM_BEH_NEVER_FLOATING",
		"GNOME_DOCK_ITEM_BEH_NEVER_VERTICAL",
		"GNOME_DOCK_ITEM_BEH_NEVER_HORIZONTAL",
		"GNOME_DOCK_ITEM_BEH_LOCKED"};
  static const int        cValues[]      = {GNOME_DOCK_ITEM_BEH_NORMAL,
	GNOME_DOCK_ITEM_BEH_EXCLUSIVE,
	GNOME_DOCK_ITEM_BEH_NEVER_FLOATING,
	GNOME_DOCK_ITEM_BEH_NEVER_VERTICAL,
	GNOME_DOCK_ITEM_BEH_NEVER_HORIZONTAL,
	GNOME_DOCK_ITEM_BEH_LOCKED};
  return(S_checkFlag(val, localNames, realNames, cValues, 6,"GnomeDockItemBehavior"));
}
 

