#include "RGtk.h"
#include "gtkUtils.h"

USER_OBJECT_
R_gtkComboSetPopdownStrings(USER_OBJECT_ scombo, USER_OBJECT_ strings)
{
    GList *items = NULL;
    int i, n;
    GtkCombo *combo = GTK_COMBO(getPtrValue(scombo));

    n = GET_LENGTH(strings);
    for(i = 0; i < n ; i++) {
	items = g_list_append(items, CHAR_DEREF(STRING_ELT(strings, i)));
    }
    gtk_combo_set_popdown_strings(combo, items);
    g_list_free(items);

    return(NULL_USER_OBJECT);
}


USER_OBJECT_
R_gtkWidgetSetFlags(USER_OBJECT_ wid, USER_OBJECT_ vals)
{
  int i;
  USER_OBJECT_ ans;
  GtkWidget *w = (GtkWidget *) getPtrValue(wid);

  if(!w) {
    PROBLEM "Null widget value passed to R_gtkWidgetSetFlags"
    ERROR
  }

  PROTECT(ans = NEW_INTEGER(1));
  INTEGER_DATA(ans)[0] = GTK_WIDGET_FLAGS(w);
  for(i = 0 ; i < Rf_length(vals); i++) {
     GTK_WIDGET_SET_FLAGS(w, INTEGER_DATA(vals)[0]);
  }

  UNPROTECT(1);

  return(ans);
}




USER_OBJECT_
S_gtk_color_selection_get_color(USER_OBJECT_ s_colorsel)
{

	USER_OBJECT_ rval;
	gdouble colors[4];
	int i;
	GtkColorSelection * colorsel = GTK_COLOR_SELECTION ((GtkObject*) getPtrValue( s_colorsel));
	
	gtk_color_selection_get_color(colorsel, colors);
	PROTECT(rval=NEW_NUMERIC(4));

	for(i = 0; i < 4; i++) 
		NUMERIC_DATA(rval)[i] = colors[i];

	UNPROTECT(1);
	return(rval);
}






/*
 Contribted by Luca Di Gaspero <l.digaspero@uniud.it>
*/
USER_OBJECT_
S_GtkWidgetGetAllocatedSize (USER_OBJECT_ s_obj)
{
	USER_OBJECT_ _result;
	GtkAllocation allocation;
   
	allocation = ((GtkWidget*) getPtrValue( s_obj ))->allocation ;
	_result = allocVector(INTSXP, 2);
	INTEGER(_result)[0] = allocation.width;
	INTEGER(_result)[1] = allocation.height;

	return _result;
}



USER_OBJECT_
R_gtkCListGetText(USER_OBJECT_ clist,  USER_OBJECT_ dims)
{
  char *tmp;
  SEXP ans;
  int n, i, ctr;
  GtkCList *w;

  w = GTK_CLIST(getPtrValue(clist));

  n = Rf_length(dims)/2;
  PROTECT(ans = NEW_CHARACTER(n));

 for(i = 0, ctr = 0; i < n; i++, ctr += 2) {
     gtk_clist_get_text(w, INTEGER(dims)[ctr], INTEGER(dims)[ctr + 1], &tmp);  
     if(tmp && tmp[0])
         SET_STRING_ELT(ans, i, COPY_TO_USER_STRING(tmp));
  }

  UNPROTECT(1);
  return(ans);
}

USER_OBJECT_
R_gtkCListSetText(USER_OBJECT_ clist,  USER_OBJECT_ dims, USER_OBJECT_ vals)
{
  char *tmp;
  SEXP ans = NULL_USER_OBJECT;
  int n, i, ctr;
  GtkCList *w;

  w = GTK_CLIST(getPtrValue(clist));

  n = Rf_length(vals);
  for(i = 0, ctr = 0; i < n; i++, ctr += 2) {
     tmp = CHAR_DEREF(STRING_ELT(vals, i)); 
     gtk_clist_set_text(w, INTEGER(dims)[i], INTEGER(dims)[i + n], tmp);  
  }

  return(ans);
}




USER_OBJECT_
S_gtk_label_get(USER_OBJECT_ s_label)
{
	GtkLabel * label = GTK_LABEL ((GtkObject*) getPtrValue( s_label));
	gchar *str;
	USER_OBJECT_ ans;
	gtk_label_get(label, &str);
	PROTECT(ans = NEW_CHARACTER(1));
	if(str)
		SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(str));
	UNPROTECT(1);
	return(ans);
}


USER_OBJECT_
R_gtkLabelGet(USER_OBJECT_ label)
{
 USER_OBJECT_ ans = NULL_USER_OBJECT;
 char *str = NULL;
 GtkLabel *w = GTK_LABEL(getPtrValue(label));

 gtk_label_get(w, &str);

 PROTECT(ans = NEW_CHARACTER(1));
 if(str && str[0])
      SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(str));
 UNPROTECT(1);

 return(ans);

}

