\name{[[.GtkObject}
\alias{[[.GtkObject}
\alias{[[.GdkEvent}
\title{Access a value within a Gtk object}
\description{
  These methods allow one to treat Gtk objects
  in an S-like manner and access certain properties
  or values within an object by name
  or accesses the children by index.
  The search works first by looking for an accessor method
  for the Gtk object.
  If no accessor is found, we look for a property or Gtk `argument'
  within the object. If such a named property exists, we retrieve
  its value.
  If the index (\code{name}) is a numeric value, we assume that
  the user means to access the child widget 
  corresponding to that index.
}
\usage{
[[.GtkObject(obj, name)
[[.GdkEvent(obj, name)
}
\arguments{
  \item{obj}{the object in which the value is to be found.}
  \item{name}{the name of the element to retrieve.}
}
\details{
}
\value{
 An S object giving the value
 returned from invoking the accessor function
 or retrieving the named property
 or a GtkWidget  object which is the corresponding child
 of the container widget.
}
\references{
  Information on the package is available
  from \url{http://www.omegahat.org/RGtk}.

  Information on Gtk is available from
  \url{http://www.gtk.org}.
}

\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}

\seealso{
\code{\link{$.GtkObject}}
\code{\link{.getAutoElementByName}}
\code{\link{.getAutoMethodByName}}
\code{\link{names.GtkObject}}
}

\examples{
 gtkInit()

 dlg <- gtkColorSelectionDialog("", show = FALSE)
  # invoke gtkColorSelectionDialogGetMainVbox()
 dlg[["MainVbox"]]


 b <- gtkButton("My own button")
  # Access a named property/argument.
 b[["label"]]

  # Create a vertical box and put the button into it.
 box <- gtkVBox(TRUE, 2)
 box$PackStart(b)
  # Now get the parent of the button, uses the named
  # property.
 b[["parent"]]

  # Get the first child, indexing by numerical value/position.
 box[[1]]
 
}
\keyword{interface}
