#
# Similar to the tcltk FAQ demo
# This offers a text and an html version.
# A more appropriate way to view the html is in the gtkhtml.S
# example using
#  viewHtml(file.path(Sys.getenv("R_HOME"), "doc", "manual", "R-FAQ.html"))

gtkFAQ <-
function(asHTML = TRUE)
{
   # Create the top-level window
  win <- gtkWindow(show = FALSE)
  win$SetUsize(300, 400)

   # A scrolled window which we will use to house the
   # text that we display.
  sw <- gtkScrolledWindow()

    # Find the appropriate file: text or HTML
  faqFile <- ifelse(asHTML,
                    file.path(Sys.getenv("R_HOME"), "doc", "manual", "R-FAQ.html"),
                    file.path(Sys.getenv("R_HOME"), "FAQ"))
  txt <-  paste(readLines(faqFile), collapse="\n")

   # Now create the widget and load the text into it.
  if(asHTML) {
    w <- gtkHTML()
    w$LoadFromString(txt, len = -1)
  } else {
    w <- gtkText()
    w$Freeze()
      w$Insert(chars = txt, length = -1)
    w$Thaw()
  }

    # Add the text display to the scrolled window and then
    # add the scrolled window to the top-level window
  sw$Add(w)  
  win$Add(sw)
  
  win$Show()
  list(win = win, text = w)
}  
