gtkItemFactoryAddForeign <-
function(accel.widget = NULL, full.path, accel.group, keyval, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(accel.widget, "GtkWidget")
	 full.path <- as.character(full.path)
	 gtkCheckInherits(accel.group, "GtkAccelGroup")
	 keyval <- as.integer(keyval)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_item_factory_add_foreign", accel.widget, full.path, accel.group, keyval, modifiers, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPanedSetPosition <-
function(paned = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_paned_set_position", paned, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListStartSelection <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_start_selection", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuItemNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_menu_item_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkMenuItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCheckMenuItemNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_check_menu_item_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCheckMenuItem", "GtkMenuItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCListGetSelectable <-
function(clist = NULL, row, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)

	 w <- .GtkCall("S_gtk_clist_get_selectable", clist, row, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkScreenHeight <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_screen_height", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDragSetDefaultIcon <-
function(colormap, pixmap, mask, hot.x, hot.y, .flush = TRUE)
{
	 gtkCheckInherits(colormap, "GdkColormap")
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")
	 hot.x <- as.integer(hot.x)
	 hot.y <- as.integer(hot.y)

	 w <- .GtkCall("S_gtk_drag_set_default_icon", colormap, pixmap, mask, hot.x, hot.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnResizeable <-
function(clist = NULL, column, resizeable, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 resizeable <- as.logical(resizeable)

	 w <- .GtkCall("S_gtk_clist_set_column_resizeable", clist, column, resizeable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeDrawStepBack <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_draw_step_back", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetTabLabelPacking <-
function(notebook = NULL, child = NULL, expand, fill, pack.type = GtkPackType[1], .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 expand <- as.logical(expand)
	 fill <- as.logical(fill)
	 pack.type  <- mapGtkPackType(pack.type)

	 w <- .GtkCall("S_gtk_notebook_set_tab_label_packing", notebook, child, expand, fill, pack.type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkDragStatus <-
function(context, action, time, .flush = TRUE)
{
	 gtkCheckInherits(context, "GdkDragContext")
	 action  <- mapGdkDragAction(action)
	 time <- as.integer(time)

	 w <- .GtkCall("S_gdk_drag_status", context, action, time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookNextPage <-
function(notebook = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")

	 w <- .GtkCall("S_gtk_notebook_next_page", notebook, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGetColormap <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_colormap", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkListEndSelection <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_end_selection", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressBarSetOrientation <-
function(pbar = NULL, orientation = GtkProgressBarOrientation[1], .flush = TRUE)
{
	 gtkCheckInherits(pbar, "GtkProgressBar")
	 orientation  <- mapGtkProgressBarOrientation(orientation)

	 w <- .GtkCall("S_gtk_progress_bar_set_orientation", pbar, orientation, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextSetAdjustments <-
function(text = NULL, hadj = NULL, vadj = NULL, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 gtkCheckInherits(hadj, "GtkAdjustment", nullOk = TRUE)
	 gtkCheckInherits(vadj, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_text_set_adjustments", text, hadj, vadj, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextNew <-
function(hadj = NULL, vadj = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(hadj, "GtkAdjustment", nullOk = TRUE)
	 gtkCheckInherits(vadj, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_text_new", hadj, vadj, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkText", "GtkEditable", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCalendarClearMarks <-
function(calendar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")

	 w <- .GtkCall("S_gtk_calendar_clear_marks", calendar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVScrollbarNew <-
function(adjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_vscrollbar_new", adjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVScrollbar", "GtkScrollbar", "GtkRange", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkFixedMove <-
function(fixed = NULL, widget = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(fixed, "GtkFixed")
	 gtkCheckInherits(widget, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_fixed_move", fixed, widget, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListItemNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_list_item_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkListItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkAccelGroupNew <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_accel_group_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkAccelGroup")
	 return(w)

}
 

gtkHButtonBoxSetLayoutDefault <-
function(layout = GtkButtonBoxStyle[1], .flush = TRUE)
{
	 layout  <- mapGtkButtonBoxStyle(layout)

	 w <- .GtkCall("S_gtk_hbutton_box_set_layout_default", layout, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupsActivate <-
function(object = NULL, key, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_accel_groups_activate", object, key, modifiers, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkEditableSelectRegion <-
function(editable = NULL, start, end, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")
	 start <- as.integer(start)
	 end <- as.integer(end)

	 w <- .GtkCall("S_gtk_editable_select_region", editable, start, end, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetHideAll <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_hide_all", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkAtomIntern <-
function(atom.name, only.if.exists = FALSE, .flush = TRUE)
{
	 atom.name <- as.character(atom.name)
	 only.if.exists <- as.integer(only.if.exists)

	 w <- .GtkCall("S_gdk_atom_intern", atom.name, only.if.exists, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkFixedNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_fixed_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkFixed", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gdkScreenWidth <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_screen_width", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkScaleSetDigits <-
function(scale = NULL, digits, .flush = TRUE)
{
	 gtkCheckInherits(scale, "GtkScale")
	 digits <- as.integer(digits)

	 w <- .GtkCall("S_gtk_scale_set_digits", scale, digits, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_list_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkList", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkToolbarSetTooltips <-
function(toolbar = NULL, enable, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 enable <- as.logical(enable)

	 w <- .GtkCall("S_gtk_toolbar_set_tooltips", toolbar, enable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLayoutGetVadjustment <-
function(layout = NULL, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")

	 w <- .GtkCall("S_gtk_layout_get_vadjustment", layout, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuShellAppend <-
function(menu.shell = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_shell_append", menu.shell, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupAdd <-
function(group, key, modifiers, flags, object = NULL, signal, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)
	 flags  <- mapGtkAccelFlags(flags)
	 gtkCheckInherits(object, "GtkObject")
	 signal <- as.character(signal)

	 w <- .GtkCall("S_gtk_accel_group_add", group, key, modifiers, flags, object, signal, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGetEvents <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_events", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkNotebookSetMenuLabel <-
function(notebook = NULL, child = NULL, menu.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(menu.label, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_set_menu_label", notebook, child, menu.label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkItemFactoryPathFromWidget <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_item_factory_path_from_widget", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListSetColumnWidth <-
function(clist = NULL, column, width, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 width <- as.integer(width)

	 w <- .GtkCall("S_gtk_clist_set_column_width", clist, column, width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuShellActivateItem <-
function(menu.shell = NULL, menu.item = NULL, force.deactivate, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")
	 gtkCheckInherits(menu.item, "GtkWidget")
	 force.deactivate <- as.logical(force.deactivate)

	 w <- .GtkCall("S_gtk_menu_shell_activate_item", menu.shell, menu.item, force.deactivate, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFrameNew <-
function(label = NULL, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_frame_new", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkFrame", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkProgressSetAdjustment <-
function(progress = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_progress_set_adjustment", progress, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookRemovePage <-
function(notebook = NULL, page.num, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 page.num <- as.integer(page.num)

	 w <- .GtkCall("S_gtk_notebook_remove_page", notebook, page.num, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSignalHandlersDestroy <-
function(object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_gtk_signal_handlers_destroy", object, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_notebook_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkNotebook", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkOptionMenuRemoveMenu <-
function(option.menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(option.menu, "GtkOptionMenu")

	 w <- .GtkCall("S_gtk_option_menu_remove_menu", option.menu, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListColumnTitlesActive <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_column_titles_active", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTableResize <-
function(table = NULL, rows, cols, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 rows <- as.integer(rows)
	 cols <- as.integer(cols)

	 w <- .GtkCall("S_gtk_table_resize", table, rows, cols, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupAttach <-
function(group, object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_gtk_accel_group_attach", group, object, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextSetEditable <-
function(text = NULL, editable, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 editable <- as.logical(editable)

	 w <- .GtkCall("S_gtk_text_set_editable", text, editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPackerSetSpacing <-
function(packer = NULL, spacing, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_packer_set_spacing", packer, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuShellInsert <-
function(menu.shell = NULL, child = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")
	 gtkCheckInherits(child, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_menu_shell_insert", menu.shell, child, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSortRecursive <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_sort_recursive", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLayoutNew <-
function(hadjustment = NULL, vadjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(hadjustment, "GtkAdjustment", nullOk = TRUE)
	 gtkCheckInherits(vadjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_layout_new", hadjustment, vadjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkLayout", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkMenuItemActivate <-
function(menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")

	 w <- .GtkCall("S_gtk_menu_item_activate", menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableDeleteText <-
function(editable = NULL, start, end, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")
	 start <- as.integer(start)
	 end <- as.integer(end)

	 w <- .GtkCall("S_gtk_editable_delete_text", editable, start, end, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookPageNum <-
function(notebook = NULL, page = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(page, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_page_num", notebook, page, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressSetTextAlignment <-
function(progress = NULL, x.align, y.align, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 x.align <- as.numeric(x.align)
	 y.align <- as.numeric(y.align)

	 w <- .GtkCall("S_gtk_progress_set_text_alignment", progress, x.align, y.align, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListInsert <-
function(clist = NULL, row, text, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_clist_insert", clist, row, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuItemConfigure <-
function(menu.item = NULL, show.toggle.indicator, show.submenu.indicator, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")
	 show.toggle.indicator <- as.logical(show.toggle.indicator)
	 show.submenu.indicator <- as.logical(show.submenu.indicator)

	 w <- .GtkCall("S_gtk_menu_item_configure", menu.item, show.toggle.indicator, show.submenu.indicator, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetDigits <-
function(spin.button = NULL, digits, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 digits <- as.integer(digits)

	 w <- .GtkCall("S_gtk_spin_button_set_digits", spin.button, digits, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTableNew <-
function(rows, columns, homogenous, show = TRUE, .flush = TRUE)
{
	 rows <- as.integer(rows)
	 columns <- as.integer(columns)
	 homogenous <- as.logical(homogenous)

	 w <- .GtkCall("S_gtk_table_new", rows, columns, homogenous, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTable", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkToggleButtonToggled <-
function(toggle.button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(toggle.button, "GtkToggleButton")

	 w <- .GtkCall("S_gtk_toggle_button_toggled", toggle.button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetNumeric <-
function(spin.button = NULL, numeric, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 numeric <- as.logical(numeric)

	 w <- .GtkCall("S_gtk_spin_button_set_numeric", spin.button, numeric, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonEnter <-
function(button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")

	 w <- .GtkCall("S_gtk_button_enter", button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkFontLoad <-
function(name, .flush = TRUE)
{
	 name <- as.character(name)

	 w <- .GtkCall("S_gdk_font_load", name, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressBarUpdate <-
function(progress.bar = NULL, percentage, .flush = TRUE)
{
	 gtkCheckInherits(progress.bar, "GtkProgressBar")
	 percentage <- as.numeric(percentage)

	 w <- .GtkCall("S_gtk_progress_bar_update", progress.bar, percentage, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSelectionOwnerSet <-
function(widget = NULL, selection, time, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(selection, "GdkAtom")
	 time <- as.integer(time)

	 w <- .GtkCall("S_gtk_selection_owner_set", widget, selection, time, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetPopStyle <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_widget_pop_style", PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSetIndent <-
function(ctree = NULL, indent, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 indent <- as.integer(indent)

	 w <- .GtkCall("S_gtk_ctree_set_indent", ctree, indent, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPackerAddDefaults <-
function(packer = NULL, child = NULL, side = GtkSideType[1], anchor = GtkAnchorType[1], options, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 gtkCheckInherits(child, "GtkWidget")
	 side  <- mapGtkSideType(side)
	 anchor  <- mapGtkAnchorType(anchor)
	 options  <- mapGtkPackerOptions(options)

	 w <- .GtkCall("S_gtk_packer_add_defaults", packer, child, side, anchor, options, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuShellDeactivate <-
function(menu.shell = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")

	 w <- .GtkCall("S_gtk_menu_shell_deactivate", menu.shell, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntrySetEditable <-
function(entry = NULL, editable, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 editable <- as.logical(editable)

	 w <- .GtkCall("S_gtk_entry_set_editable", entry, editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCurveReset <-
function(curve = NULL, .flush = TRUE)
{
	 gtkCheckInherits(curve, "GtkCurve")

	 w <- .GtkCall("S_gtk_curve_reset", curve, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetIsAncestor <-
function(widget = NULL, ancestor = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(ancestor, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_is_ancestor", widget, ancestor, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkHandleBoxSetShadowType <-
function(handle.box = NULL, type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(handle.box, "GtkHandleBox")
	 type  <- mapGtkShadowType(type)

	 w <- .GtkCall("S_gtk_handle_box_set_shadow_type", handle.box, type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkStatusbarGetContextId <-
function(statusbar = NULL, context.description, .flush = TRUE)
{
	 gtkCheckInherits(statusbar, "GtkStatusbar")
	 context.description <- as.character(context.description)

	 w <- .GtkCall("S_gtk_statusbar_get_context_id", statusbar, context.description, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkButtonGetRelief <-
function(button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")

	 w <- .GtkCall("S_gtk_button_get_relief", button, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkButtonBoxSetSpacing <-
function(widget = NULL, spacing, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkButtonBox")
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_button_box_set_spacing", widget, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetForeground <-
function(ctree = NULL, node, color, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 gtkCheckInherits(color, "GdkColor")

	 w <- .GtkCall("S_gtk_ctree_node_set_foreground", ctree, node, color, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetUnmap <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_unmap", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkItemFactoryParseRc <-
function(file.name, .flush = TRUE)
{
	 file.name <- as.character(file.name)

	 w <- .GtkCall("S_gtk_item_factory_parse_rc", file.name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeMoveto <-
function(ctree = NULL, node, column, row.align, col.align, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)
	 row.align <- as.numeric(row.align)
	 col.align <- as.numeric(col.align)

	 w <- .GtkCall("S_gtk_ctree_node_moveto", ctree, node, column, row.align, col.align, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListUnselectChild <-
function(list = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_list_unselect_child", list, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetCellStyle <-
function(ctree = NULL, node, column, style, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_ctree_node_set_cell_style", ctree, node, column, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeSelectChild <-
function(tree = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_tree_select_child", tree, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkOptionMenuNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_option_menu_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkOptionMenu", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gdkScreenWidthMm <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_screen_width_mm", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetSetExtensionEvents <-
function(widget = NULL, events = GdkExtensionMode[1], .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 events  <- mapGdkExtensionMode(events)

	 w <- .GtkCall("S_gtk_widget_set_extension_events", widget, events, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRulerDrawTicks <-
function(ruler = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ruler, "GtkRuler")

	 w <- .GtkCall("S_gtk_ruler_draw_ticks", ruler, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookGetMenuLabel <-
function(notebook = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_get_menu_label", notebook, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkListClearItems <-
function(list = NULL, start, end, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 start <- as.integer(start)
	 end <- as.integer(end)

	 w <- .GtkCall("S_gtk_list_clear_items", list, start, end, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuPopdown <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_popdown", menu, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeItemNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_tree_item_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTreeItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetResetRcStyles <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_reset_rc_styles", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToggleButtonNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_toggle_button_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkToggleButton", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkMenuShellSelectItem <-
function(menu.shell = NULL, menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")
	 gtkCheckInherits(menu.item, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_shell_select_item", menu.shell, menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeExpandRecursive <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_expand_recursive", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetShapeCombineMask <-
function(widget = NULL, mask, ofs.x, ofs.y, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(mask, "GdkBitmap")
	 ofs.x <- as.integer(ofs.x)
	 ofs.y <- as.integer(ofs.y)

	 w <- .GtkCall("S_gtk_widget_shape_combine_mask", widget, mask, ofs.x, ofs.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkScreenHeightMm <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gdk_screen_height_mm", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gTKCHECKTYPE <-
function(object = NULL, type, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 type <- as.integer(type)

	 w <- .GtkCall("S_GTK_CHECK_TYPE", object, type, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkEditableGetChars <-
function(editable = NULL, start, end, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")
	 start <- as.integer(start)
	 end <- as.integer(end)

	 w <- .GtkCall("S_gtk_editable_get_chars", editable, start, end, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTipsQueryNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_tips_query_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTipsQuery", "GtkLabel", "GtkMisc", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetPopup <-
function(widget = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_widget_popup", widget, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonGetValueAsFloat <-
function(spin.button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")

	 w <- .GtkCall("S_gtk_spin_button_get_value_as_float", spin.button, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressGetCurrentPercentage <-
function(progress = NULL, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")

	 w <- .GtkCall("S_gtk_progress_get_current_percentage", progress, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkPreviewSetExpand <-
function(preview = NULL, expand, .flush = TRUE)
{
	 gtkCheckInherits(preview, "GtkPreview")
	 expand <- as.integer(expand)

	 w <- .GtkCall("S_gtk_preview_set_expand", preview, expand, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetEvents <-
function(widget = NULL, events, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 events  <- mapGdkEventMask(events)

	 w <- .GtkCall("S_gtk_widget_set_events", widget, events, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarSetSpaceStyle <-
function(toolbar = NULL, space.style = GtkToolbarSpaceStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 space.style  <- mapGtkToolbarSpaceStyle(space.style)

	 w <- .GtkCall("S_gtk_toolbar_set_space_style", toolbar, space.style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTableSetRowSpacings <-
function(table = NULL, spacing, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_table_set_row_spacings", table, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetDestroy <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_destroy", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDragSetIconWidget <-
function(context, widget = NULL, hot.x, hot.y, .flush = TRUE)
{
	 gtkCheckInherits(context, "GdkDragContext")
	 gtkCheckInherits(widget, "GtkWidget")
	 hot.x <- as.integer(hot.x)
	 hot.y <- as.integer(hot.y)

	 w <- .GtkCall("S_gtk_drag_set_icon_widget", context, widget, hot.x, hot.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVRulerNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_vruler_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVRuler", "GtkRuler", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkListUnselectItem <-
function(list = NULL, item, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 item <- as.integer(item)

	 w <- .GtkCall("S_gtk_list_unselect_item", list, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTooltipsSetTip <-
function(tooltips = NULL, widget = NULL, tip.text = NULL, tip.private = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tooltips, "GtkTooltips")
	 gtkCheckInherits(widget, "GtkWidget")
	 tip.text <- as.character(tip.text)
	 tip.private <- as.character(tip.private)

	 w <- .GtkCall("S_gtk_tooltips_set_tip", tooltips, widget, tip.text, tip.private, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkViewportSetVadjustment <-
function(viewport = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(viewport, "GtkViewport")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_viewport_set_vadjustment", viewport, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetShowAll <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_show_all", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPanedAdd2 <-
function(paned = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_paned_add2", paned, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPanedAdd1 <-
function(paned = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_paned_add1", paned, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDragSetIconPixmap <-
function(context, colormap, pixmap, mask, hot.x, hot.y, .flush = TRUE)
{
	 gtkCheckInherits(context, "GdkDragContext")
	 gtkCheckInherits(colormap, "GdkColormap")
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")
	 hot.x <- as.integer(hot.x)
	 hot.y <- as.integer(hot.y)

	 w <- .GtkCall("S_gtk_drag_set_icon_pixmap", context, colormap, pixmap, mask, hot.x, hot.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetQueueClear <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_queue_clear", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDragUnhighlight <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_drag_unhighlight", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkInputRemove <-
function(tag, .flush = TRUE)
{
	 tag <- as.integer(tag)

	 w <- .GtkCall("S_gtk_input_remove", tag, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetForeground <-
function(clist = NULL, row, color, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 gtkCheckInherits(color, "GdkColor")

	 w <- .GtkCall("S_gtk_clist_set_foreground", clist, row, color, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuItemSetSubmenu <-
function(menu.item = NULL, submenu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")
	 gtkCheckInherits(submenu, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_item_set_submenu", menu.item, submenu, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeGetCellType <-
function(ctree = NULL, node, column, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_ctree_node_get_cell_type", ctree, node, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuBarAppend <-
function(menu.bar = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.bar, "GtkMenuBar")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_bar_append", menu.bar, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListSelectAll <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_select_all", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTipsQueryStartQuery <-
function(tips.query = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tips.query, "GtkTipsQuery")

	 w <- .GtkCall("S_gtk_tips_query_start_query", tips.query, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDragGetSourceWidget <-
function(context, .flush = TRUE)
{
	 gtkCheckInherits(context, "GdkDragContext")

	 w <- .GtkCall("S_gtk_drag_get_source_widget", context, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListColumnsAutosize <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_columns_autosize", clist, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkAccelLabelSetAccelWidget <-
function(accel.label = NULL, accel.widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(accel.label, "GtkAccelLabel")
	 gtkCheckInherits(accel.widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_accel_label_set_accel_widget", accel.label, accel.widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkColorSelectionNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_color_selection_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkColorSelection", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWindowSetWmclass <-
function(window = NULL, wmclass.class, wmclass.name, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 wmclass.class <- as.character(wmclass.class)
	 wmclass.name <- as.character(wmclass.name)

	 w <- .GtkCall("S_gtk_window_set_wmclass", window, wmclass.class, wmclass.name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGetDefaultColormap <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_widget_get_default_colormap", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkFontSelectionDialogSetPreviewText <-
function(fsd = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(fsd, "GtkFontSelectionDialog")
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_font_selection_dialog_set_preview_text", fsd, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeAppend <-
function(tree = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_tree_append", tree, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonBoxGetSpacing <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkButtonBox")

	 w <- .GtkCall("S_gtk_button_box_get_spacing", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkComboSetUseArrows <-
function(combo = NULL, val, .flush = TRUE)
{
	 gtkCheckInherits(combo, "GtkCombo")
	 val <- as.logical(val)

	 w <- .GtkCall("S_gtk_combo_set_use_arrows", combo, val, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPanedSetGutterSize <-
function(paned = NULL, size, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 size <- as.integer(size)

	 w <- .GtkCall("S_gtk_paned_set_gutter_size", paned, size, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelLabelNew <-
function(string, show = TRUE, .flush = TRUE)
{
	 string <- as.character(string)

	 w <- .GtkCall("S_gtk_accel_label_new", string, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkAccelLabel", "GtkLabel", "GtkMisc", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWindowSetPolicy <-
function(window = NULL, allow.shrink, allow.grow, auto.shrink, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 allow.shrink <- as.logical(allow.shrink)
	 allow.grow <- as.logical(allow.grow)
	 auto.shrink <- as.logical(auto.shrink)

	 w <- .GtkCall("S_gtk_window_set_policy", window, allow.shrink, allow.grow, auto.shrink, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeUnselectChild <-
function(tree = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_tree_unselect_child", tree, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeInsert <-
function(tree = NULL, child = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 gtkCheckInherits(child, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_tree_insert", tree, child, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetSelectionMode <-
function(clist = NULL, mode = GtkSelectionMode[1], .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 mode  <- mapGtkSelectionMode(mode)

	 w <- .GtkCall("S_gtk_clist_set_selection_mode", clist, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowNew <-
function(hadjustment = NULL, vadjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(hadjustment, "GtkAdjustment", nullOk = TRUE)
	 gtkCheckInherits(vadjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_scrolled_window_new", hadjustment, vadjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkScrolledWindow", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkArrowNew <-
function(arrow.type = GtkArrowType[1], shadow.type = GtkShadowType[1], show = TRUE, .flush = TRUE)
{
	 arrow.type  <- mapGtkArrowType(arrow.type)
	 shadow.type  <- mapGtkShadowType(shadow.type)

	 w <- .GtkCall("S_gtk_arrow_new", arrow.type, shadow.type, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkArrow", "GtkMisc", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetAddAccelerator <-
function(widget = NULL, signal.name, group, key, modifiers, flags, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 signal.name <- as.character(signal.name)
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)
	 flags  <- mapGtkAccelFlags(flags)

	 w <- .GtkCall("S_gtk_widget_add_accelerator", widget, signal.name, group, key, modifiers, flags, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetHideOnDelete <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_hide_on_delete", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetReparent <-
function(widget = NULL, new.parent = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(new.parent, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_reparent", widget, new.parent, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowAddWithViewport <-
function(scrolled.window = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_scrolled_window_add_with_viewport", scrolled.window, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupUnlockEntry <-
function(group, key, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_accel_group_unlock_entry", group, key, modifiers, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressSetValue <-
function(progress = NULL, value, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 value <- as.numeric(value)

	 w <- .GtkCall("S_gtk_progress_set_value", progress, value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCurveSetGamma <-
function(curve = NULL, gamma, .flush = TRUE)
{
	 gtkCheckInherits(curve, "GtkCurve")
	 gamma <- as.numeric(gamma)

	 w <- .GtkCall("S_gtk_curve_set_gamma", curve, gamma, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeIsVisible <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_node_is_visible", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkLabelSetText <-
function(label = NULL, str, .flush = TRUE)
{
	 gtkCheckInherits(label, "GtkLabel")
	 str <- as.character(str)

	 w <- .GtkCall("S_gtk_label_set_text", label, str, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCurveNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_curve_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCurve", "GtkDrawingArea", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWindowSetDefaultSize <-
function(window = NULL, width, height, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_window_set_default_size", window, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTooltipsEnable <-
function(tooltips = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tooltips, "GtkTooltips")

	 w <- .GtkCall("S_gtk_tooltips_enable", tooltips, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookAppendPageMenu <-
function(notebook = NULL, child = NULL, tab.label = NULL, menu.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")
	 gtkCheckInherits(menu.label, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_append_page_menu", notebook, child, tab.label, menu.label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListClear <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_clear", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHButtonBoxSetSpacingDefault <-
function(spacing, .flush = TRUE)
{
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_hbutton_box_set_spacing_default", spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuInsert <-
function(menu = NULL, child = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 gtkCheckInherits(child, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_menu_insert", menu, child, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarSetStyle <-
function(toolbar = NULL, style = GtkToolbarStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 style  <- mapGtkToolbarStyle(style)

	 w <- .GtkCall("S_gtk_toolbar_set_style", toolbar, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkObjectDestroy <-
function(object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_gtk_object_destroy", object, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListUndoSelection <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_undo_selection", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonLeave <-
function(button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")

	 w <- .GtkCall("S_gtk_button_leave", button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableSetEditable <-
function(editable = NULL, is.editable, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")
	 is.editable <- as.logical(is.editable)

	 w <- .GtkCall("S_gtk_editable_set_editable", editable, is.editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkItemToggle <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GtkItem")

	 w <- .GtkCall("S_gtk_item_toggle", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkArrowSet <-
function(arrow = NULL, arrow.type = GtkArrowType[1], shadow.type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(arrow, "GtkArrow")
	 arrow.type  <- mapGtkArrowType(arrow.type)
	 shadow.type  <- mapGtkShadowType(shadow.type)

	 w <- .GtkCall("S_gtk_arrow_set", arrow, arrow.type, shadow.type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFrameSetShadowType <-
function(frame = NULL, type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(frame, "GtkFrame")
	 type  <- mapGtkShadowType(type)

	 w <- .GtkCall("S_gtk_frame_set_shadow_type", frame, type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeSetUpdatePolicy <-
function(range = NULL, policy = GtkUpdateType[1], .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")
	 policy  <- mapGtkUpdateType(policy)

	 w <- .GtkCall("S_gtk_range_set_update_policy", range, policy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupRemove <-
function(group, key, modifiers, object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_gtk_accel_group_remove", group, key, modifiers, object, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLayoutFreeze <-
function(layout = NULL, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")

	 w <- .GtkCall("S_gtk_layout_freeze", layout, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntrySelectRegion <-
function(entry = NULL, start, end, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 start <- as.integer(start)
	 end <- as.integer(end)

	 w <- .GtkCall("S_gtk_entry_select_region", entry, start, end, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHButtonBoxGetLayoutDefault <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_hbutton_box_get_layout_default", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkListEndDragSelection <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_end_drag_selection", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFileSelectionNew <-
function(title, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)

	 w <- .GtkCall("S_gtk_file_selection_new", title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkFileSelection", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkTableSetColSpacings <-
function(table = NULL, spacing, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_table_set_col_spacings", table, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextSetWordWrap <-
function(text = NULL, word.wrap, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 word.wrap <- as.integer(word.wrap)

	 w <- .GtkCall("S_gtk_text_set_word_wrap", text, word.wrap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkQuitAddDestroy <-
function(main.level, object = NULL, .flush = TRUE)
{
	 main.level <- as.integer(main.level)
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_gtk_quit_add_destroy", main.level, object, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowGetVadjustment <-
function(scrolled.window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")

	 w <- .GtkCall("S_gtk_scrolled_window_get_vadjustment", scrolled.window, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkScaleSetDrawValue <-
function(scale = NULL, draw.value, .flush = TRUE)
{
	 gtkCheckInherits(scale, "GtkScale")
	 draw.value <- as.logical(draw.value)

	 w <- .GtkCall("S_gtk_scale_set_draw_value", scale, draw.value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressBarNewWithAdjustment <-
function(adjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_progress_bar_new_with_adjustment", adjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkProgressBar", "GtkProgress", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetSetStyle <-
function(widget = NULL, style, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_widget_set_style", widget, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowSetPlacement <-
function(scrolled.window = NULL, window.placement = GtkCornerType[1], .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")
	 window.placement  <- mapGtkCornerType(window.placement)

	 w <- .GtkCall("S_gtk_scrolled_window_set_placement", scrolled.window, window.placement, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextGetLength <-
function(text = NULL, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")

	 w <- .GtkCall("S_gtk_text_get_length", text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkPlugNew <-
function(socket.id, show = TRUE, .flush = TRUE)
{
	 socket.id <- as.integer(socket.id)

	 w <- .GtkCall("S_gtk_plug_new", socket.id, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkPlug", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWindowActivateFocus <-
function(window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")

	 w <- .GtkCall("S_gtk_window_activate_focus", window, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkAlignmentSet <-
function(alignment = NULL, xalign, yalign, xscale, yscale, .flush = TRUE)
{
	 gtkCheckInherits(alignment, "GtkAlignment")
	 xalign <- as.numeric(xalign)
	 yalign <- as.numeric(yalign)
	 xscale <- as.numeric(xscale)
	 yscale <- as.numeric(yscale)

	 w <- .GtkCall("S_gtk_alignment_set", alignment, xalign, yalign, xscale, yscale, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetAppPaintable <-
function(widget = NULL, app.paintable, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 app.paintable <- as.logical(app.paintable)

	 w <- .GtkCall("S_gtk_widget_set_app_paintable", widget, app.paintable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewSetInstallCmap <-
function(install.cmap, .flush = TRUE)
{
	 install.cmap <- as.integer(install.cmap)

	 w <- .GtkCall("S_gtk_preview_set_install_cmap", install.cmap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gTKOBJECTTYPE <-
function(object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_GTK_OBJECT_TYPE", object, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkViewportSetShadowType <-
function(viewport = NULL, type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(viewport, "GtkViewport")
	 type  <- mapGtkShadowType(type)

	 w <- .GtkCall("S_gtk_viewport_set_shadow_type", viewport, type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkComboNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_combo_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCombo", "GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCheckButtonNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_check_button_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCheckButton", "GtkToggleButton", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkEntryAppendText <-
function(entry = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_entry_append_text", entry, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRulerSetMetric <-
function(ruler = NULL, metric = GtkMetricType[1], .flush = TRUE)
{
	 gtkCheckInherits(ruler, "GtkRuler")
	 metric  <- mapGtkMetricType(metric)

	 w <- .GtkCall("S_gtk_ruler_set_metric", ruler, metric, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkDrawLine <-
function(drawable, gc, x1, y1, x2, y2, .flush = TRUE)
{
	 gtkCheckInherits(drawable, "GdkDrawable")
	 gtkCheckInherits(gc, "GdkGC")
	 x1 <- as.integer(x1)
	 y1 <- as.integer(y1)
	 x2 <- as.integer(x2)
	 y2 <- as.integer(y2)

	 w <- .GtkCall("S_gdk_draw_line", drawable, gc, x1, y1, x2, y2, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntrySetVisibility <-
function(entry = NULL, visible, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 visible <- as.logical(visible)

	 w <- .GtkCall("S_gtk_entry_set_visibility", entry, visible, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetTabLabel <-
function(notebook = NULL, child = NULL, tab.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_set_tab_label", notebook, child, tab.label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCurveSetRange <-
function(curve = NULL, min.x, max.x, min.y, max.y, .flush = TRUE)
{
	 gtkCheckInherits(curve, "GtkCurve")
	 min.x <- as.numeric(min.x)
	 max.x <- as.numeric(max.x)
	 min.y <- as.numeric(min.y)
	 max.y <- as.numeric(max.y)

	 w <- .GtkCall("S_gtk_curve_set_range", curve, min.x, max.x, min.y, max.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerFocus <-
function(container = NULL, direction = GtkDirectionType[1], .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 direction  <- mapGtkDirectionType(direction)

	 w <- .GtkCall("S_gtk_container_focus", container, direction, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMiscSetAlignment <-
function(misc = NULL, xalign, yalign, .flush = TRUE)
{
	 gtkCheckInherits(misc, "GtkMisc")
	 xalign <- as.numeric(xalign)
	 yalign <- as.numeric(yalign)

	 w <- .GtkCall("S_gtk_misc_set_alignment", misc, xalign, yalign, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHScrollbarNew <-
function(adjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_hscrollbar_new", adjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHScrollbar", "GtkScrollbar", "GtkRange", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkMenuItemNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_menu_item_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkMenuItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetDrawDefault <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_draw_default", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnAutoResize <-
function(clist = NULL, column, auto.resize, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 auto.resize <- as.logical(auto.resize)

	 w <- .GtkCall("S_gtk_clist_set_column_auto_resize", clist, column, auto.resize, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuBarNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_menu_bar_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkMenuBar", "GtkMenuShell", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkToolbarNew <-
function(orientation = GtkOrientation[1], style = GtkToolbarStyle[1], show = TRUE, .flush = TRUE)
{
	 orientation  <- mapGtkOrientation(orientation)
	 style  <- mapGtkToolbarStyle(style)

	 w <- .GtkCall("S_gtk_toolbar_new", orientation, style, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkToolbar", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkContainerChildCompositeName <-
function(container = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_container_child_composite_name", container, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWindowSetPosition <-
function(window = NULL, position = GtkWindowPosition[1], .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 position  <- mapGtkWindowPosition(position)

	 w <- .GtkCall("S_gtk_window_set_position", window, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowSetVadjustment <-
function(scrolled.window = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_scrolled_window_set_vadjustment", scrolled.window, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVButtonBoxSetSpacingDefault <-
function(spacing, .flush = TRUE)
{
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_vbutton_box_set_spacing_default", spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeToggleExpansion <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_toggle_expansion", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableGetPosition <-
function(editable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")

	 w <- .GtkCall("S_gtk_editable_get_position", editable, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkFileSelectionGetFilename <-
function(filesel = NULL, .flush = TRUE)
{
	 gtkCheckInherits(filesel, "GtkFileSelection")

	 w <- .GtkCall("S_gtk_file_selection_get_filename", filesel, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkToggleButtonGetActive <-
function(toggle.button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(toggle.button, "GtkToggleButton")

	 w <- .GtkCall("S_gtk_toggle_button_get_active", toggle.button, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkAdjustmentValueChanged <-
function(adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_adjustment_value_changed", adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSetExpanderStyle <-
function(ctree = NULL, style = GtkCTreeExpanderStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 style  <- mapGtkCTreeExpanderStyle(style)

	 w <- .GtkCall("S_gtk_ctree_set_expander_style", ctree, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeDrawStepForw <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_draw_step_forw", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarSelectDay <-
function(calendar = NULL, day, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")
	 day <- as.integer(day)

	 w <- .GtkCall("S_gtk_calendar_select_day", calendar, day, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookGetTabLabel <-
function(notebook = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_get_tab_label", notebook, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCTreeCollapseRecursive <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_collapse_recursive", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDragSourceSetIcon <-
function(widget = NULL, colormap, pixmap, mask, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(colormap, "GdkColormap")
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")

	 w <- .GtkCall("S_gtk_drag_source_set_icon", widget, colormap, pixmap, mask, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTooltipsForceWindow <-
function(tooltips = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tooltips, "GtkTooltips")

	 w <- .GtkCall("S_gtk_tooltips_force_window", tooltips, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToggleButtonNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_toggle_button_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkToggleButton", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkItemFactoryNew <-
function(container.type, path, group, .flush = TRUE)
{
	 container.type <- as.integer(container.type)
	 path <- as.character(path)
	 gtkCheckInherits(group, "GtkAccelGroup")

	 w <- .GtkCall("S_gtk_item_factory_new", container.type, path, group, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkItemFactory", "GtkObject")
	 return(w)

}
 

gtkItemFactoryGetWidget <-
function(ifactory = NULL, path, .flush = TRUE)
{
	 gtkCheckInherits(ifactory, "GtkItemFactory")
	 path <- as.character(path)

	 w <- .GtkCall("S_gtk_item_factory_get_widget", ifactory, path, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListRowMove <-
function(clist = NULL, source.row, dest.row, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 source.row <- as.integer(source.row)
	 dest.row <- as.integer(dest.row)

	 w <- .GtkCall("S_gtk_clist_row_move", clist, source.row, dest.row, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonPressed <-
function(button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")

	 w <- .GtkCall("S_gtk_button_pressed", button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLabelParseUline <-
function(label = NULL, string, .flush = TRUE)
{
	 gtkCheckInherits(label, "GtkLabel")
	 string <- as.character(string)

	 w <- .GtkCall("S_gtk_label_parse_uline", label, string, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkInputDialogNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_input_dialog_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkInputDialog", "GtkDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkMenuSetActive <-
function(menu = NULL, index, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 index <- as.integer(index)

	 w <- .GtkCall("S_gtk_menu_set_active", menu, index, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarPrependWidget <-
function(Toolbar = NULL, Widget = NULL, tooltip.text, tooltip.private.text, .flush = TRUE)
{
	 gtkCheckInherits(Toolbar, "GtkToolbar")
	 gtkCheckInherits(Widget, "GtkWidget")
	 tooltip.text <- as.character(tooltip.text)
	 tooltip.private.text <- as.character(tooltip.private.text)

	 w <- .GtkCall("S_gtk_toolbar_prepend_widget", Toolbar, Widget, tooltip.text, tooltip.private.text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFixedPut <-
function(fixed = NULL, widget = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(fixed, "GtkFixed")
	 gtkCheckInherits(widget, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_fixed_put", fixed, widget, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVPanedNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_vpaned_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVPaned", "GtkPaned", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetGetExtensionEvents <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_extension_events", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTooltipsSetDelay <-
function(tooltips = NULL, delay, .flush = TRUE)
{
	 gtkCheckInherits(tooltips, "GtkTooltips")
	 delay <- as.integer(delay)

	 w <- .GtkCall("S_gtk_tooltips_set_delay", tooltips, delay, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableDeleteSelection <-
function(editable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")

	 w <- .GtkCall("S_gtk_editable_delete_selection", editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressBarSetBarStyle <-
function(pbar = NULL, style = GtkProgressBarStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(pbar, "GtkProgressBar")
	 style  <- mapGtkProgressBarStyle(style)

	 w <- .GtkCall("S_gtk_progress_bar_set_bar_style", pbar, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSelectRecursive <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_select_recursive", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarMarkDay <-
function(calendar = NULL, day, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")
	 day <- as.integer(day)

	 w <- .GtkCall("S_gtk_calendar_mark_day", calendar, day, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkItemFactoryGetWidgetByAction <-
function(ifactory = NULL, action, .flush = TRUE)
{
	 gtkCheckInherits(ifactory, "GtkItemFactory")
	 action <- as.integer(action)

	 w <- .GtkCall("S_gtk_item_factory_get_widget_by_action", ifactory, action, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkViewportGetHadjustment <-
function(viewport = NULL, .flush = TRUE)
{
	 gtkCheckInherits(viewport, "GtkViewport")

	 w <- .GtkCall("S_gtk_viewport_get_hadjustment", viewport, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuEnsureUlineAccelGroup <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_ensure_uline_accel_group", menu, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkListSelectItem <-
function(list = NULL, item, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 item <- as.integer(item)

	 w <- .GtkCall("S_gtk_list_select_item", list, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupUnlock <-
function(group, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")

	 w <- .GtkCall("S_gtk_accel_group_unlock", group, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetRemoveAccelerator <-
function(widget = NULL, group, key, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_widget_remove_accelerator", widget, group, key, modifiers, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuSetAccelGroup <-
function(menu = NULL, group, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 gtkCheckInherits(group, "GtkAccelGroup")

	 w <- .GtkCall("S_gtk_menu_set_accel_group", menu, group, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_button_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkGrabAdd <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_grab_add", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerSetFocusChild <-
function(container = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 gtkCheckInherits(child, "GtkWidget", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_container_set_focus_child", container, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuReposition <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_reposition", menu, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerSetFocusHadjustment <-
function(container = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_container_set_focus_hadjustment", container, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeGetCellStyle <-
function(ctree = NULL, node, column, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_ctree_node_get_cell_style", ctree, node, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuGetAccelGroup <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_get_accel_group", menu, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuItemSetPlacement <-
function(menu.item = NULL, placement = GtkSubmenuPlacement[1], .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")
	 placement  <- mapGtkSubmenuPlacement(placement)

	 w <- .GtkCall("S_gtk_menu_item_set_placement", menu.item, placement, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTipsQueryStopQuery <-
function(tips.query = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tips.query, "GtkTipsQuery")

	 w <- .GtkCall("S_gtk_tips_query_stop_query", tips.query, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListScrollHorizontal <-
function(list = NULL, scroll.type = GtkScrollType[1], pos, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 scroll.type  <- mapGtkScrollType(scroll.type)
	 pos <- as.numeric(pos)

	 w <- .GtkCall("S_gtk_list_scroll_horizontal", list, scroll.type, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowSetTitle <-
function(window = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 title <- as.character(title)

	 w <- .GtkCall("S_gtk_window_set_title", window, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookAppendPage <-
function(notebook = NULL, child = NULL, tab.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_append_page", notebook, child, tab.label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkDrawArc <-
function(drawable, gc, filled, x, y, width, height, angle1, angle2, .flush = TRUE)
{
	 gtkCheckInherits(drawable, "GdkDrawable")
	 gtkCheckInherits(gc, "GdkGC")
	 filled <- as.integer(filled)
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)
	 angle1 <- as.integer(angle1)
	 angle2 <- as.integer(angle2)

	 w <- .GtkCall("S_gdk_draw_arc", drawable, gc, filled, x, y, width, height, angle1, angle2, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNew <-
function(columns, tree.column, show = TRUE, .flush = TRUE)
{
	 columns <- as.integer(columns)
	 tree.column <- as.integer(tree.column)

	 w <- .GtkCall("S_gtk_ctree_new", columns, tree.column, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCTree", "GtkCList", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCTreeSetNodeInfo <-
function(ctree = NULL, node, text, spacing, pixmap.closed, mask.closed, pixmap.opened, mask.opened, is.leaf, expanded, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 text <- as.character(text)
	 spacing <- as.integer(spacing)
	 gtkCheckInherits(pixmap.closed, "GdkPixmap")
	 gtkCheckInherits(mask.closed, "GdkBitmap")
	 gtkCheckInherits(pixmap.opened, "GdkPixmap")
	 gtkCheckInherits(mask.opened, "GdkBitmap")
	 is.leaf <- as.logical(is.leaf)
	 expanded <- as.logical(expanded)

	 w <- .GtkCall("S_gtk_ctree_set_node_info", ctree, node, text, spacing, pixmap.closed, mask.closed, pixmap.opened, mask.opened, is.leaf, expanded, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowSetPolicy <-
function(scrolled.window = NULL, hscrollbar.policy = GtkPolicyType[1], vscrollbar.policy = GtkPolicyType[1], .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")
	 hscrollbar.policy  <- mapGtkPolicyType(hscrollbar.policy)
	 vscrollbar.policy  <- mapGtkPolicyType(vscrollbar.policy)

	 w <- .GtkCall("S_gtk_scrolled_window_set_policy", scrolled.window, hscrollbar.policy, vscrollbar.policy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookPrependPageMenu <-
function(notebook = NULL, child = NULL, tab.label = NULL, menu.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")
	 gtkCheckInherits(menu.label, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_prepend_page_menu", notebook, child, tab.label, menu.label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnJustification <-
function(clist = NULL, column, justification = GtkJustification[1], .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 justification  <- mapGtkJustification(justification)

	 w <- .GtkCall("S_gtk_clist_set_column_justification", clist, column, justification, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionDialogGetFont <-
function(fsd = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fsd, "GtkFontSelectionDialog")

	 w <- .GtkCall("S_gtk_font_selection_dialog_get_font", fsd, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkNotebookPrependPage <-
function(notebook = NULL, child = NULL, tab.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")

	 w <- .GtkCall("S_gtk_notebook_prepend_page", notebook, child, tab.label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkDrawRectangle <-
function(drawable, gc, filled, x, y, width, height, .flush = TRUE)
{
	 gtkCheckInherits(drawable, "GdkDrawable")
	 gtkCheckInherits(gc, "GdkGC")
	 filled <- as.integer(filled)
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gdk_draw_rectangle", drawable, gc, filled, x, y, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetAutoSort <-
function(clist = NULL, auto.sort, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 auto.sort <- as.logical(auto.sort)

	 w <- .GtkCall("S_gtk_clist_set_auto_sort", clist, auto.sort, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListSetSelectionMode <-
function(list = NULL, mode = GtkSelectionMode[1], .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 mode  <- mapGtkSelectionMode(mode)

	 w <- .GtkCall("S_gtk_list_set_selection_mode", list, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNewWithTitles <-
function(columns, tree.column, titles, show = TRUE, .flush = TRUE)
{
	 columns <- as.integer(columns)
	 tree.column <- as.integer(tree.column)
	 titles <- as.character(titles)

	 w <- .GtkCall("S_gtk_ctree_new_with_titles", columns, tree.column, titles, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCTree", "GtkCList", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gdkDrawPoint <-
function(drawable, gc, x, y, .flush = TRUE)
{
	 gtkCheckInherits(drawable, "GdkDrawable")
	 gtkCheckInherits(gc, "GdkGC")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gdk_draw_point", drawable, gc, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxPackEndDefaults <-
function(box = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_box_pack_end_defaults", box, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkStatusbarNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_statusbar_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkStatusbar", "GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetPushColormap <-
function(cmap, .flush = TRUE)
{
	 gtkCheckInherits(cmap, "GdkColormap")

	 w <- .GtkCall("S_gtk_widget_push_colormap", cmap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTipsQuerySetLabels <-
function(tips.query = NULL, label.inactive, label.no.tip, .flush = TRUE)
{
	 gtkCheckInherits(tips.query, "GtkTipsQuery")
	 label.inactive <- as.character(label.inactive)
	 label.no.tip <- as.character(label.no.tip)

	 w <- .GtkCall("S_gtk_tips_query_set_labels", tips.query, label.inactive, label.no.tip, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeGetRowStyle <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_node_get_row_style", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkOptionMenuSetHistory <-
function(option.menu = NULL, index, .flush = TRUE)
{
	 gtkCheckInherits(option.menu, "GtkOptionMenu")
	 index <- as.integer(index)

	 w <- .GtkCall("S_gtk_option_menu_set_history", option.menu, index, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookInsertPage <-
function(notebook = NULL, child = NULL, tab.label = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_notebook_insert_page", notebook, child, tab.label, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuPopup <-
function(menu = NULL, parent.shell = NULL, parent.item = NULL, func = NULL, data = NULL, button, activate.time, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 gtkCheckInherits(parent.shell, "GtkWidget")
	 gtkCheckInherits(parent.item, "GtkWidget")
	 gtkCheckInherits(func, "GtkMenuPositionFunc", nullOk = TRUE)
	 gtkCheckInherits(data, "gpointer", nullOk = TRUE)
	 button <- as.numeric(button)
	 activate.time <- as.numeric(activate.time)

	 w <- .GtkCall("S_gtk_menu_popup", menu, parent.shell, parent.item, func, data, button, activate.time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVButtonBoxGetLayoutDefault <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_vbutton_box_get_layout_default", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkFontSelectionGetPreviewText <-
function(fontsel = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fontsel, "GtkFontSelection")

	 w <- .GtkCall("S_gtk_font_selection_get_preview_text", fontsel, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCTreeCollapseToDepth <-
function(ctree = NULL, node, depth, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 depth <- as.integer(depth)

	 w <- .GtkCall("S_gtk_ctree_collapse_to_depth", ctree, node, depth, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCheckMenuItemNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_check_menu_item_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCheckMenuItem", "GtkMenuItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkBoxSetChildPacking <-
function(box = NULL, child = NULL, expand, fill, padding, pack.type = GtkPackType[1], .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 gtkCheckInherits(child, "GtkWidget")
	 expand <- as.logical(expand)
	 fill <- as.logical(fill)
	 padding <- as.integer(padding)
	 pack.type  <- mapGtkPackType(pack.type)

	 w <- .GtkCall("S_gtk_box_set_child_packing", box, child, expand, fill, padding, pack.type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListSelectChild <-
function(list = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_list_select_child", list, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeToggleExpansionRecursive <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_toggle_expansion_recursive", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAdjustmentNew <-
function(value, lower, upper, step.increment, page.increment, page.size, .flush = TRUE)
{
	 value <- as.numeric(value)
	 lower <- as.numeric(lower)
	 upper <- as.numeric(upper)
	 step.increment <- as.numeric(step.increment)
	 page.increment <- as.numeric(page.increment)
	 page.size <- as.numeric(page.size)

	 w <- .GtkCall("S_gtk_adjustment_new", value, lower, upper, step.increment, page.increment, page.size, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkAdjustment", "GtkData", "GtkObject")
	 return(w)

}
 

gtkToolbarSetButtonRelief <-
function(toolbar = NULL, relief = GtkReliefStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 relief  <- mapGtkReliefStyle(relief)

	 w <- .GtkCall("S_gtk_toolbar_set_button_relief", toolbar, relief, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFileSelectionSetFilename <-
function(filesel = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(filesel, "GtkFileSelection")
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gtk_file_selection_set_filename", filesel, filename, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkViewportGetVadjustment <-
function(viewport = NULL, .flush = TRUE)
{
	 gtkCheckInherits(viewport, "GtkViewport")

	 w <- .GtkCall("S_gtk_viewport_get_vadjustment", viewport, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkSocketSteal <-
function(socket = NULL, window.id, .flush = TRUE)
{
	 gtkCheckInherits(socket, "GtkSocket")
	 window.id <- as.integer(window.id)

	 w <- .GtkCall("S_gtk_socket_steal", socket, window.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeItemDeselect <-
function(tree.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree.item, "GtkTreeItem")

	 w <- .GtkCall("S_gtk_tree_item_deselect", tree.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuDetach <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_detach", menu, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuSetTearoffState <-
function(menu = NULL, torn.off, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 torn.off <- as.logical(torn.off)

	 w <- .GtkCall("S_gtk_menu_set_tearoff_state", menu, torn.off, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetSelectable <-
function(clist = NULL, row, selectable, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 selectable <- as.logical(selectable)

	 w <- .GtkCall("S_gtk_clist_set_selectable", clist, row, selectable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetTabBorder <-
function(notebook = NULL, border.width, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 border.width <- as.integer(border.width)

	 w <- .GtkCall("S_gtk_notebook_set_tab_border", notebook, border.width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToggleButtonSetMode <-
function(toggle.button = NULL, draw.indicator, .flush = TRUE)
{
	 gtkCheckInherits(toggle.button, "GtkToggleButton")
	 draw.indicator <- as.logical(draw.indicator)

	 w <- .GtkCall("S_gtk_toggle_button_set_mode", toggle.button, draw.indicator, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetEnsureStyle <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_ensure_style", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookPopupEnable <-
function(notebook = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")

	 w <- .GtkCall("S_gtk_notebook_popup_enable", notebook, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetRowStyle <-
function(clist = NULL, row, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)

	 w <- .GtkCall("S_gtk_clist_get_row_style", clist, row, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressBarNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_progress_bar_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkProgressBar", "GtkProgress", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkTreePrepend <-
function(tree = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_tree_prepend", tree, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSelectionAddTarget <-
function(widget = NULL, selection, target, info, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(selection, "GdkAtom")
	 gtkCheckInherits(target, "GdkAtom")
	 info <- as.integer(info)

	 w <- .GtkCall("S_gtk_selection_add_target", widget, selection, target, info, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_font_selection_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkFontSelection", "GtkNotebook", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkTextSetLineWrap <-
function(text = NULL, line.wrap, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 line.wrap <- as.integer(line.wrap)

	 w <- .GtkCall("S_gtk_text_set_line_wrap", text, line.wrap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookPopupDisable <-
function(notebook = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")

	 w <- .GtkCall("S_gtk_notebook_popup_disable", notebook, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTableSetColSpacing <-
function(table = NULL, column, spacing, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 column <- as.integer(column)
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_table_set_col_spacing", table, column, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSelect <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_select", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListUndoSelection <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_undo_selection", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSetShowStub <-
function(ctree = NULL, show.stub, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 show.stub <- as.logical(show.stub)

	 w <- .GtkCall("S_gtk_ctree_set_show_stub", ctree, show.stub, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarAppendWidget <-
function(Toolbar = NULL, Widget = NULL, tooltip.text, tooltip.private.text, .flush = TRUE)
{
	 gtkCheckInherits(Toolbar, "GtkToolbar")
	 gtkCheckInherits(Widget, "GtkWidget")
	 tooltip.text <- as.character(tooltip.text)
	 tooltip.private.text <- as.character(tooltip.private.text)

	 w <- .GtkCall("S_gtk_toolbar_append_widget", Toolbar, Widget, tooltip.text, tooltip.private.text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewNew <-
function(type = GtkPreviewType[1], show = TRUE, .flush = TRUE)
{
	 type  <- mapGtkPreviewType(type)

	 w <- .GtkCall("S_gtk_preview_new", type, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkPreview", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkToolbarInsertWidget <-
function(toolbar = NULL, widget = NULL, tooltip.text, tooltip.private.text, position, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 gtkCheckInherits(widget, "GtkWidget")
	 tooltip.text <- as.character(tooltip.text)
	 tooltip.private.text <- as.character(tooltip.private.text)
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_toolbar_insert_widget", toolbar, widget, tooltip.text, tooltip.private.text, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRcParse <-
function(file, .flush = TRUE)
{
	 file <- as.character(file)

	 w <- .GtkCall("S_gtk_rc_parse", file, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressGetValue <-
function(progress = NULL, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")

	 w <- .GtkCall("S_gtk_progress_get_value", progress, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkListToggleRow <-
function(list = NULL, item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 gtkCheckInherits(item, "GtkWidget")

	 w <- .GtkCall("S_gtk_list_toggle_row", list, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkGrabGetCurrent <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_grab_get_current", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkItemFactoryFromWidget <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_item_factory_from_widget", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDragSetIconDefault <-
function(context, .flush = TRUE)
{
	 gtkCheckInherits(context, "GdkDragContext")

	 w <- .GtkCall("S_gtk_drag_set_icon_default", context, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextBackwardDelete <-
function(text = NULL, nchars, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 nchars <- as.integer(nchars)

	 w <- .GtkCall("S_gtk_text_backward_delete", text, nchars, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPixmapNew <-
function(pixmap, mask = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_pixmap_new", pixmap, mask, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkPixmap", "GtkMisc", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCTreeUnselect <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_unselect", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowGetHadjustment <-
function(scrolled.window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")

	 w <- .GtkCall("S_gtk_scrolled_window_get_hadjustment", scrolled.window, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressGetPercentageFromValue <-
function(progress = NULL, value, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 value <- as.numeric(value)

	 w <- .GtkCall("S_gtk_progress_get_percentage_from_value", progress, value, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkPackerReorderChild <-
function(packer = NULL, widget = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 gtkCheckInherits(widget, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_packer_reorder_child", packer, widget, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuReorderChild <-
function(menu = NULL, child = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 gtkCheckInherits(child, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_menu_reorder_child", menu, child, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRulerSetRange <-
function(ruler = NULL, lower, upper, position, max.size, .flush = TRUE)
{
	 gtkCheckInherits(ruler, "GtkRuler")
	 lower <- as.numeric(lower)
	 upper <- as.numeric(upper)
	 position <- as.numeric(position)
	 max.size <- as.numeric(max.size)

	 w <- .GtkCall("S_gtk_ruler_set_range", ruler, lower, upper, position, max.size, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetButtonActions <-
function(clist = NULL, button, button.actions, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 button <- as.integer(button)
	 button.actions <- as.integer(button.actions)

	 w <- .GtkCall("S_gtk_clist_set_button_actions", clist, button, button.actions, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkOptionMenuGetMenu <-
function(option.menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(option.menu, "GtkOptionMenu")

	 w <- .GtkCall("S_gtk_option_menu_get_menu", option.menu, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetSetRcStyle <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_set_rc_style", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListItemDeselect <-
function(list.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list.item, "GtkListItem")

	 w <- .GtkCall("S_gtk_list_item_deselect", list.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeDrawTrough <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_draw_trough", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetReorderable <-
function(clist = NULL, reorderable, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 reorderable <- as.logical(reorderable)

	 w <- .GtkCall("S_gtk_clist_set_reorderable", clist, reorderable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListFreeze <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_freeze", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListRowIsVisible <-
function(clist = NULL, row, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)

	 w <- .GtkCall("S_gtk_clist_row_is_visible", clist, row, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkContainerSetResizeMode <-
function(container = NULL, resize.mode = GtkResizeMode[1], .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 resize.mode  <- mapGtkResizeMode(resize.mode)

	 w <- .GtkCall("S_gtk_container_set_resize_mode", container, resize.mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetPopColormap <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_widget_pop_colormap", PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelLabelRefetch <-
function(accel.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(accel.label, "GtkAccelLabel")

	 w <- .GtkCall("S_gtk_accel_label_refetch", accel.label, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTearoffMenuItemNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_tearoff_menu_item_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTearoffMenuItem", "GtkMenuItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkSpinButtonGetValueAsInt <-
function(spin.button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")

	 w <- .GtkCall("S_gtk_spin_button_get_value_as_int", spin.button, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkSpinButtonSetValue <-
function(spin.button = NULL, value, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 value <- as.numeric(value)

	 w <- .GtkCall("S_gtk_spin_button_set_value", spin.button, value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetScrollAdjustments <-
function(widget = NULL, hadjustment = NULL, vadjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(hadjustment, "GtkAdjustment")
	 gtkCheckInherits(vadjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_widget_set_scroll_adjustments", widget, hadjustment, vadjustment, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDragHighlight <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_drag_highlight", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuShellPrepend <-
function(menu.shell = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_shell_prepend", menu.shell, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntrySetPosition <-
function(entry = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_entry_set_position", entry, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTooltipsSetColors <-
function(tooltips = NULL, background, foreground, .flush = TRUE)
{
	 gtkCheckInherits(tooltips, "GtkTooltips")
	 gtkCheckInherits(background, "GdkColor")
	 gtkCheckInherits(foreground, "GdkColor")

	 w <- .GtkCall("S_gtk_tooltips_set_colors", tooltips, background, foreground, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetQueueClearArea <-
function(widget = NULL, x, y, width, height, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_widget_queue_clear_area", widget, x, y, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_calendar_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCalendar", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkEntrySetMaxLength <-
function(entry = NULL, max, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 max <- as.integer(max)

	 w <- .GtkCall("S_gtk_entry_set_max_length", entry, max, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScrolledWindowSetHadjustment <-
function(scrolled.window = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scrolled.window, "GtkScrolledWindow")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_scrolled_window_set_hadjustment", scrolled.window, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewSize <-
function(preview = NULL, width, height, .flush = TRUE)
{
	 gtkCheckInherits(preview, "GtkPreview")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_preview_size", preview, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeIsViewable <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_is_viewable", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListSetColumnMinWidth <-
function(clist = NULL, column, min.width, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 min.width <- as.integer(min.width)

	 w <- .GtkCall("S_gtk_clist_set_column_min_width", clist, column, min.width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetAdjustment <-
function(spin.button = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_spin_button_set_adjustment", spin.button, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSelectRow <-
function(clist = NULL, row, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_select_row", clist, row, column, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRcParseString <-
function(rc.string, .flush = TRUE)
{
	 rc.string <- as.character(rc.string)

	 w <- .GtkCall("S_gtk_rc_parse_string", rc.string, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetRowStyle <-
function(clist = NULL, row, style, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_clist_set_row_style", clist, row, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetShowTabs <-
function(notebook = NULL, show.tabs, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 show.tabs <- as.logical(show.tabs)

	 w <- .GtkCall("S_gtk_notebook_set_show_tabs", notebook, show.tabs, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListUnselectAll <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_unselect_all", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTableAttachDefaults <-
function(table = NULL, child = NULL, left.attach, right.attach, top.attach, bottom.attach, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 gtkCheckInherits(child, "GtkWidget")
	 left.attach <- as.integer(left.attach)
	 right.attach <- as.integer(right.attach)
	 top.attach <- as.integer(top.attach)
	 bottom.attach <- as.integer(bottom.attach)

	 w <- .GtkCall("S_gtk_table_attach_defaults", table, child, left.attach, right.attach, top.attach, bottom.attach, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFileSelectionComplete <-
function(filesel = NULL, pattern, .flush = TRUE)
{
	 gtkCheckInherits(filesel, "GtkFileSelection")
	 pattern <- as.character(pattern)

	 w <- .GtkCall("S_gtk_file_selection_complete", filesel, pattern, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarSelectMonth <-
function(calendar = NULL, month, year, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")
	 month <- as.integer(month)
	 year <- as.integer(year)

	 w <- .GtkCall("S_gtk_calendar_select_month", calendar, month, year, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkHButtonBoxNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_hbutton_box_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHButtonBox", "GtkButtonBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkListScrollVertical <-
function(list = NULL, scroll.type = GtkScrollType[1], pos, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 scroll.type  <- mapGtkScrollType(scroll.type)
	 pos <- as.numeric(pos)

	 w <- .GtkCall("S_gtk_list_scroll_vertical", list, scroll.type, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGetStyle <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_style", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkVButtonBoxGetSpacingDefault <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_vbutton_box_get_spacing_default", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetGetParentWindow <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_parent_window", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetRemoveAccelerators <-
function(widget = NULL, signal.name, visible.only, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 signal.name <- as.character(signal.name)
	 visible.only <- as.logical(visible.only)

	 w <- .GtkCall("S_gtk_widget_remove_accelerators", widget, signal.name, visible.only, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxPackEnd <-
function(box = NULL, child = NULL, expand = TRUE, fill = TRUE, padding = 0, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 gtkCheckInherits(child, "GtkWidget")
	 expand <- as.logical(expand)
	 fill <- as.logical(fill)
	 padding <- as.integer(padding)

	 w <- .GtkCall("S_gtk_box_pack_end", box, child, expand, fill, padding, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScaleDrawValue <-
function(scale = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scale, "GtkScale")

	 w <- .GtkCall("S_gtk_scale_draw_value", scale, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetColumnWidget <-
function(clist = NULL, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_get_column_widget", clist, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetLockAccelerators <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_lock_accelerators", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarSetSpaceSize <-
function(toolbar = NULL, space.size, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 space.size <- as.integer(space.size)

	 w <- .GtkCall("S_gtk_toolbar_set_space_size", toolbar, space.size, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTooltipsDisable <-
function(tooltips = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tooltips, "GtkTooltips")

	 w <- .GtkCall("S_gtk_tooltips_disable", tooltips, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListChildPosition <-
function(list = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_list_child_position", list, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkToolbarGetButtonRelief <-
function(toolbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")

	 w <- .GtkCall("S_gtk_toolbar_get_button_relief", toolbar, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListUnselectRow <-
function(clist = NULL, row, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_unselect_row", clist, row, column, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewPut <-
function(preview = NULL, window, gc, srcx, srcy, destx, desty, width, height, .flush = TRUE)
{
	 gtkCheckInherits(preview, "GtkPreview")
	 gtkCheckInherits(window, "GdkWindow")
	 gtkCheckInherits(gc, "GdkGC")
	 srcx <- as.integer(srcx)
	 srcy <- as.integer(srcy)
	 destx <- as.integer(destx)
	 desty <- as.integer(desty)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_preview_put", preview, window, gc, srcx, srcy, destx, desty, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAlignmentNew <-
function(xalign, yalign, xscale, yscale, show = TRUE, .flush = TRUE)
{
	 xalign <- as.numeric(xalign)
	 yalign <- as.numeric(yalign)
	 xscale <- as.numeric(xscale)
	 yscale <- as.numeric(yscale)

	 w <- .GtkCall("S_gtk_alignment_new", xalign, yalign, xscale, yscale, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkAlignment", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetSetDefaultStyle <-
function(style, .flush = TRUE)
{
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_widget_set_default_style", style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupLockEntry <-
function(group, key, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_accel_group_lock_entry", group, key, modifiers, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFileSelectionHideFileopButtons <-
function(filesel = NULL, .flush = TRUE)
{
	 gtkCheckInherits(filesel, "GtkFileSelection")

	 w <- .GtkCall("S_gtk_file_selection_hide_fileop_buttons", filesel, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarInsertSpace <-
function(toolbar = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_toolbar_insert_space", toolbar, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetTabPos <-
function(notebook = NULL, pos = GtkPositionType[1], .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 pos  <- mapGtkPositionType(pos)

	 w <- .GtkCall("S_gtk_notebook_set_tab_pos", notebook, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTypeFromName <-
function(name, .flush = TRUE)
{
	 name <- as.character(name)

	 w <- .GtkCall("S_gtk_type_from_name", name, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkItemDeselect <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GtkItem")

	 w <- .GtkCall("S_gtk_item_deselect", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDragDestSetProxy <-
function(widget = NULL, proxy.window, protocol = GdkDragProtocol[1], use.coordinates, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(proxy.window, "GdkWindow")
	 protocol  <- mapGdkDragProtocol(protocol)
	 use.coordinates <- as.logical(use.coordinates)

	 w <- .GtkCall("S_gtk_drag_dest_set_proxy", widget, proxy.window, protocol, use.coordinates, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetAddEvents <-
function(widget = NULL, events, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 events  <- mapGdkEventMask(events)

	 w <- .GtkCall("S_gtk_widget_add_events", widget, events, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetMap <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_map", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSelectionRemoveAll <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_selection_remove_all", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntrySetText <-
function(entry = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_entry_set_text", entry, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLabelNew <-
function(str, show = TRUE, .flush = TRUE)
{
	 str <- as.character(str)

	 w <- .GtkCall("S_gtk_label_new", str, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkLabel", "GtkMisc", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkHandleBoxNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_handle_box_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHandleBox", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkItemSelect <-
function(item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(item, "GtkItem")

	 w <- .GtkCall("S_gtk_item_select", item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDialogNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_dialog_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkSpinButtonUpdate <-
function(spin.button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")

	 w <- .GtkCall("S_gtk_spin_button_update", spin.button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerAdd <-
function(container = NULL, widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_container_add", container, widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRcLoadImage <-
function(colormap = NULL, transparent.color = NULL, filename, .flush = TRUE)
{
	 gtkCheckInherits(colormap, "GdkColormap", nullOk = TRUE)
	 gtkCheckInherits(transparent.color, "GdkColor", nullOk = TRUE)
	 filename <- as.character(filename)

	 w <- .GtkCall("S_gtk_rc_load_image", colormap, transparent.color, filename, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkHSeparatorNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_hseparator_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHSeparator", "GtkSeparator", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCTreeRealSelectRecursive <-
function(ctree = NULL, node, state, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 state <- as.integer(state)

	 w <- .GtkCall("S_gtk_ctree_real_select_recursive", ctree, node, state, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gTKOBJECTFLAGS <-
function(object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_GTK_OBJECT_FLAGS", object, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkStatusbarRemove <-
function(statusbar = NULL, context.id, message.id, .flush = TRUE)
{
	 gtkCheckInherits(statusbar, "GtkStatusbar")
	 context.id <- as.integer(context.id)
	 message.id <- as.integer(message.id)

	 w <- .GtkCall("S_gtk_statusbar_remove", statusbar, context.id, message.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnMaxWidth <-
function(clist = NULL, column, max.width, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 max.width <- as.integer(max.width)

	 w <- .GtkCall("S_gtk_clist_set_column_max_width", clist, column, max.width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListColumnTitlesPassive <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_column_titles_passive", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeExpand <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_expand", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetSensitive <-
function(widget = NULL, sensitive, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 sensitive <- as.logical(sensitive)

	 w <- .GtkCall("S_gtk_widget_set_sensitive", widget, sensitive, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScaleGetValueWidth <-
function(scale = NULL, .flush = TRUE)
{
	 gtkCheckInherits(scale, "GtkScale")

	 w <- .GtkCall("S_gtk_scale_get_value_width", scale, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkQuitRemove <-
function(quit.id, .flush = TRUE)
{
	 quit.id <- as.integer(quit.id)

	 w <- .GtkCall("S_gtk_quit_remove", quit.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeLast <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_last", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkVButtonBoxSetLayoutDefault <-
function(layout = GtkButtonBoxStyle[1], .flush = TRUE)
{
	 layout  <- mapGtkButtonBoxStyle(layout)

	 w <- .GtkCall("S_gtk_vbutton_box_set_layout_default", layout, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkGammaCurveNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_gamma_curve_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkGammaCurve", "GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetShowNow <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_show_now", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkComboSetCaseSensitive <-
function(combo = NULL, val, .flush = TRUE)
{
	 gtkCheckInherits(combo, "GtkCombo")
	 val <- as.logical(val)

	 w <- .GtkCall("S_gtk_combo_set_case_sensitive", combo, val, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressBarSetDiscreteBlocks <-
function(pbar = NULL, blocks, .flush = TRUE)
{
	 gtkCheckInherits(pbar, "GtkProgressBar")
	 blocks <- as.integer(blocks)

	 w <- .GtkCall("S_gtk_progress_bar_set_discrete_blocks", pbar, blocks, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarPrependSpace <-
function(toolbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")

	 w <- .GtkCall("S_gtk_toolbar_prepend_space", toolbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListExtendSelection <-
function(list = NULL, scroll.type = GtkScrollType[1], position, auto.start, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")
	 scroll.type  <- mapGtkScrollType(scroll.type)
	 position <- as.numeric(position)
	 auto.start <- as.logical(auto.start)

	 w <- .GtkCall("S_gtk_list_extend_selection", list, scroll.type, position, auto.start, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxSetHomogeneous <-
function(box = NULL, homogenous, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 homogenous <- as.logical(homogenous)

	 w <- .GtkCall("S_gtk_box_set_homogeneous", box, homogenous, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_button_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gdkCursorNew <-
function(cursor.type = GdkCursorType[1], .flush = TRUE)
{
	 cursor.type  <- mapGdkCursorType(cursor.type)

	 w <- .GtkCall("S_gdk_cursor_new", cursor.type, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkCursor")
	 return(w)

}
 

gTKOBJECTSETFLAGS <-
function(object = NULL, flags, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 flags  <- mapGtkWidgetFlags(flags)

	 w <- .GtkCall("S_GTK_OBJECT_SET_FLAGS", object, flags, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLayoutSetVadjustment <-
function(layout = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_layout_set_vadjustment", layout, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetQueueDraw <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_queue_draw", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeItemSetSubtree <-
function(tree.item = NULL, subtree = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree.item, "GtkTreeItem")
	 gtkCheckInherits(subtree, "GtkWidget")

	 w <- .GtkCall("S_gtk_tree_item_set_subtree", tree.item, subtree, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookPrevPage <-
function(notebook = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")

	 w <- .GtkCall("S_gtk_notebook_prev_page", notebook, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetDefaultColormap <-
function(cmap, .flush = TRUE)
{
	 gtkCheckInherits(cmap, "GdkColormap")

	 w <- .GtkCall("S_gtk_widget_set_default_colormap", cmap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonBoxSetChildSize <-
function(widget = NULL, min.width, min.height, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkButtonBox")
	 min.width <- as.integer(min.width)
	 min.height <- as.integer(min.height)

	 w <- .GtkCall("S_gtk_button_box_set_child_size", widget, min.width, min.height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarAppendSpace <-
function(toolbar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")

	 w <- .GtkCall("S_gtk_toolbar_append_space", toolbar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonBoxSetChildIpaddingDefault <-
function(ipad.x, ipad.y, .flush = TRUE)
{
	 ipad.x <- as.integer(ipad.x)
	 ipad.y <- as.integer(ipad.y)

	 w <- .GtkCall("S_gtk_button_box_set_child_ipadding_default", ipad.x, ipad.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPackerSetDefaultPad <-
function(packer = NULL, pad.x, pad.y, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 pad.x <- as.integer(pad.x)
	 pad.y <- as.integer(pad.y)

	 w <- .GtkCall("S_gtk_packer_set_default_pad", packer, pad.x, pad.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableCutClipboard <-
function(edtiable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(edtiable, "GtkEditable")

	 w <- .GtkCall("S_gtk_editable_cut_clipboard", edtiable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPackerNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_packer_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkPacker", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkPreviewSetGamma <-
function(gamma, .flush = TRUE)
{
	 gtkCheckInherits(gamma, "double")

	 w <- .GtkCall("S_gtk_preview_set_gamma", gamma, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeItemRemoveSubtree <-
function(tree.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree.item, "GtkTreeItem")

	 w <- .GtkCall("S_gtk_tree_item_remove_subtree", tree.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetShift <-
function(clist = NULL, row, column, vertical, horizontal, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)
	 vertical <- as.integer(vertical)
	 horizontal <- as.integer(horizontal)

	 w <- .GtkCall("S_gtk_clist_set_shift", clist, row, column, vertical, horizontal, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookGetCurrentPage <-
function(notebook = NULL, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")

	 w <- .GtkCall("S_gtk_notebook_get_current_page", notebook, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuItemRemoveSubmenu <-
function(menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")

	 w <- .GtkCall("S_gtk_menu_item_remove_submenu", menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetCellType <-
function(clist = NULL, row, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_get_cell_type", clist, row, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gdkFontsetLoad <-
function(name, .flush = TRUE)
{
	 name <- as.character(name)

	 w <- .GtkCall("S_gdk_fontset_load", name, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCalendarThaw <-
function(calendar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")

	 w <- .GtkCall("S_gtk_calendar_thaw", calendar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTableSetHomogeneous <-
function(table = NULL, homogeneous, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 homogeneous <- as.logical(homogeneous)

	 w <- .GtkCall("S_gtk_table_set_homogeneous", table, homogeneous, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetCellStyle <-
function(clist = NULL, row, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_get_cell_style", clist, row, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetGetAncestor <-
function(widget = NULL, type, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 type <- as.integer(type)

	 w <- .GtkCall("S_gtk_widget_get_ancestor", widget, type, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkGrabRemove <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_grab_remove", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuItemDeselect <-
function(menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")

	 w <- .GtkCall("S_gtk_menu_item_deselect", menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListThaw <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_thaw", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonBoxSetChildIpadding <-
function(widget = NULL, ipad.x, ipad.y, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkButtonBox")
	 ipad.x <- as.integer(ipad.x)
	 ipad.y <- as.integer(ipad.y)

	 w <- .GtkCall("S_gtk_button_box_set_child_ipadding", widget, ipad.x, ipad.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeItemCollapse <-
function(tree.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree.item, "GtkTreeItem")

	 w <- .GtkCall("S_gtk_tree_item_collapse", tree.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressBarSetActivityStep <-
function(pbar = NULL, step, .flush = TRUE)
{
	 gtkCheckInherits(pbar, "GtkProgressBar")
	 step <- as.integer(step)

	 w <- .GtkCall("S_gtk_progress_bar_set_activity_step", pbar, step, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeUnselectItem <-
function(tree = NULL, item, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 item <- as.integer(item)

	 w <- .GtkCall("S_gtk_tree_unselect_item", tree, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetRealize <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_realize", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetUnrealize <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_unrealize", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListColumnTitleActive <-
function(clist = NULL, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_column_title_active", clist, column, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeIsAncestor <-
function(ctree = NULL, node, child, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 gtkCheckInherits(child, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_is_ancestor", ctree, node, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetSetUposition <-
function(widget = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_widget_set_uposition", widget, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarSetOrientation <-
function(toolbar = NULL, orientation = GtkOrientation[1], .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 orientation  <- mapGtkOrientation(orientation)

	 w <- .GtkCall("S_gtk_toolbar_set_orientation", toolbar, orientation, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetShow <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_show", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonNew <-
function(adjustment = NULL, climb.rate, digits, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment", nullOk = TRUE)
	 climb.rate <- as.numeric(climb.rate)
	 digits <- as.integer(digits)

	 w <- .GtkCall("S_gtk_spin_button_new", adjustment, climb.rate, digits, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkSpinButton", "GtkEntry", "GtkEditable", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetSetParentWindow <-
function(widget = NULL, parent.window, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(parent.window, "GdkWindow")

	 w <- .GtkCall("S_gtk_widget_set_parent_window", widget, parent.window, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDrawingAreaNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_drawing_area_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkDrawingArea", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkLabelSetPattern <-
function(label = NULL, pattern, .flush = TRUE)
{
	 gtkCheckInherits(label, "GtkLabel")
	 pattern <- as.character(pattern)

	 w <- .GtkCall("S_gtk_label_set_pattern", label, pattern, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeSetViewLines <-
function(tree = NULL, flag, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 flag <- as.logical(flag)

	 w <- .GtkCall("S_gtk_tree_set_view_lines", tree, flag, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowNew <-
function(type = GtkWindowType[1], show = TRUE, .flush = TRUE)
{
	 type  <- mapGtkWindowType(type)

	 w <- .GtkCall("S_gtk_window_new", type, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkLayoutThaw <-
function(layout = NULL, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")

	 w <- .GtkCall("S_gtk_layout_thaw", layout, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeGetAdjustment <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_get_adjustment", range, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkLayoutPut <-
function(layout = NULL, child = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")
	 gtkCheckInherits(child, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_layout_put", layout, child, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetHomogeneousTabs <-
function(notebook = NULL, homogeneous, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 homogeneous <- as.logical(homogeneous)

	 w <- .GtkCall("S_gtk_notebook_set_homogeneous_tabs", notebook, homogeneous, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowActivateDefault <-
function(window = NULL, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")

	 w <- .GtkCall("S_gtk_window_activate_default", window, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkSelectionConvert <-
function(widget = NULL, selection, target, time, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(selection, "GdkAtom")
	 gtkCheckInherits(target, "GdkAtom")
	 time <- as.integer(time)

	 w <- .GtkCall("S_gtk_selection_convert", widget, selection, target, time, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuShellDeselect <-
function(menu.shell = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.shell, "GtkMenuShell")

	 w <- .GtkCall("S_gtk_menu_shell_deselect", menu.shell, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGetToplevel <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_toplevel", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTableAttach <-
function(table = NULL, child = NULL, left.attach, right.attach, top.attach, bottom.attach, xoptions = c("GTK_EXPAND", "GTK_FILL"), yoptions = c("GTK_EXPAND", "GTK_FILL"), xpadding = 0, ypadding = 0, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 gtkCheckInherits(child, "GtkWidget")
	 left.attach <- as.integer(left.attach)
	 right.attach <- as.integer(right.attach)
	 top.attach <- as.integer(top.attach)
	 bottom.attach <- as.integer(bottom.attach)
	 xoptions  <- mapGtkAttachOptions(xoptions)
	 yoptions  <- mapGtkAttachOptions(yoptions)
	 xpadding <- as.integer(xpadding)
	 ypadding <- as.integer(ypadding)

	 w <- .GtkCall("S_gtk_table_attach", table, child, left.attach, right.attach, top.attach, bottom.attach, xoptions, yoptions, xpadding, ypadding, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetDrawFocus <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_draw_focus", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuSetTitle <-
function(menu = NULL, title, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 title <- as.character(title)

	 w <- .GtkCall("S_gtk_menu_set_title", menu, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnWidget <-
function(clist = NULL, column, widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_clist_set_column_widget", clist, column, widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressSetShowText <-
function(progress = NULL, show.text, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 show.text <- as.integer(show.text)

	 w <- .GtkCall("S_gtk_progress_set_show_text", progress, show.text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarDisplayOptions <-
function(calendar = NULL, flags, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")
	 flags  <- mapGtkCalendarDisplayOptions(flags)

	 w <- .GtkCall("S_gtk_calendar_display_options", calendar, flags, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextFreeze <-
function(text = NULL, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")

	 w <- .GtkCall("S_gtk_text_freeze", text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSetSpacing <-
function(ctree = NULL, spacing, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_ctree_set_spacing", ctree, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowSetTransientFor <-
function(window = NULL, parent = NULL, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 gtkCheckInherits(parent, "GtkWindow")

	 w <- .GtkCall("S_gtk_window_set_transient_for", window, parent, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarFreeze <-
function(calendar = NULL, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")

	 w <- .GtkCall("S_gtk_calendar_freeze", calendar, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSignalEmitStopByName <-
function(object = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 name <- as.character(name)

	 w <- .GtkCall("S_gtk_signal_emit_stop_by_name", object, name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRadioButtonNewWithLabelFromWidget <-
function(group = NULL, label, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkRadioButton", nullOk = TRUE)
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_radio_button_new_with_label_from_widget", group, label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkRadioButton", "GtkCheckButton", "GtkToggleButton", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkButtonBoxGetLayout <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkButtonBox")

	 w <- .GtkCall("S_gtk_button_box_get_layout", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkContainerRegisterToplevel <-
function(container = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")

	 w <- .GtkCall("S_gtk_container_register_toplevel", container, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetName <-
function(widget = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 name <- as.character(name)

	 w <- .GtkCall("S_gtk_widget_set_name", widget, name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListRemove <-
function(clist = NULL, row, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)

	 w <- .GtkCall("S_gtk_clist_remove", clist, row, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuItemSelect <-
function(menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")

	 w <- .GtkCall("S_gtk_menu_item_select", menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonReleased <-
function(button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")

	 w <- .GtkCall("S_gtk_button_released", button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTimeoutRemove <-
function(tag, .flush = TRUE)
{
	 tag <- as.integer(tag)

	 w <- .GtkCall("S_gtk_timeout_remove", tag, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuAppend <-
function(menu = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_append", menu, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetHide <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_hide", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListToggleAddMode <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_toggle_add_mode", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextForwardDelete <-
function(text = NULL, nchars, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 nchars <- as.integer(nchars)

	 w <- .GtkCall("S_gtk_text_forward_delete", text, nchars, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHScaleNew <-
function(adjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_hscale_new", adjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHScale", "GtkScale", "GtkRange", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkMainQuit <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_main_quit", PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetRestoreDefaultStyle <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_restore_default_style", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuItemRightJustify <-
function(menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkMenuItem")

	 w <- .GtkCall("S_gtk_menu_item_right_justify", menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxPackStartDefaults <-
function(box = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_box_pack_start_defaults", box, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewSetColorCube <-
function(nred.shades, ngreen.shades, nblue.shades, ngray.shades, .flush = TRUE)
{
	 nred.shades <- as.integer(nred.shades)
	 ngreen.shades <- as.integer(ngreen.shades)
	 nblue.shades <- as.integer(nblue.shades)
	 ngray.shades <- as.integer(ngray.shades)

	 w <- .GtkCall("S_gtk_preview_set_color_cube", nred.shades, ngreen.shades, nblue.shades, ngray.shades, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetUnlockAccelerators <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_unlock_accelerators", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeSetAdjustment <-
function(range = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_range_set_adjustment", range, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionSetFontName <-
function(fontsel = NULL, fontname, .flush = TRUE)
{
	 gtkCheckInherits(fontsel, "GtkFontSelection")
	 fontname <- as.character(fontname)

	 w <- .GtkCall("S_gtk_font_selection_set_font_name", fontsel, fontname, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetAcceleratorsLocked <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_accelerators_locked", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkFontSelectionGetFontName <-
function(fontsel = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fontsel, "GtkFontSelection")

	 w <- .GtkCall("S_gtk_font_selection_get_font_name", fontsel, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkViewportSetHadjustment <-
function(viewport = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(viewport, "GtkViewport")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_viewport_set_hadjustment", viewport, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerRemove <-
function(container = NULL, widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_container_remove", container, widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetColumnTitle <-
function(clist = NULL, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_get_column_title", clist, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkDragFinish <-
function(context, success, del, time, .flush = TRUE)
{
	 gtkCheckInherits(context, "GdkDragContext")
	 success <- as.logical(success)
	 del <- as.logical(del)
	 time <- as.integer(time)

	 w <- .GtkCall("S_gtk_drag_finish", context, success, del, time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListNewWithTitles <-
function(columns, titles, show = TRUE, .flush = TRUE)
{
	 columns <- as.integer(columns)
	 titles <- as.character(titles)

	 w <- .GtkCall("S_gtk_clist_new_with_titles", columns, titles, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCList", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkNotebookSetMenuLabelText <-
function(notebook = NULL, child = NULL, menu.text, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 menu.text <- as.character(menu.text)

	 w <- .GtkCall("S_gtk_notebook_set_menu_label_text", notebook, child, menu.text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookInsertPageMenu <-
function(notebook = NULL, child = NULL, tab.label = NULL, menu.label = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 gtkCheckInherits(tab.label, "GtkWidget")
	 gtkCheckInherits(menu.label, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_notebook_insert_page_menu", notebook, child, tab.label, menu.label, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeNth <-
function(ctree = NULL, row, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 row <- as.integer(row)

	 w <- .GtkCall("S_gtk_ctree_node_nth", ctree, row, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListSetSortColumn <-
function(clist = NULL, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_set_sort_column", clist, column, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowSetModal <-
function(window = NULL, modal, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 modal <- as.logical(modal)

	 w <- .GtkCall("S_gtk_window_set_modal", window, modal, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAdjustmentSetValue <-
function(adjustment = NULL, value, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment")
	 value <- as.numeric(value)

	 w <- .GtkCall("S_gtk_adjustment_set_value", adjustment, value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuGetAttachWidget <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_get_attach_widget", menu, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkWidgetGetDefaultStyle <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_widget_get_default_style", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkColorSelectionSetOpacity <-
function(colorsel = NULL, use.opacity, .flush = TRUE)
{
	 gtkCheckInherits(colorsel, "GtkColorSelection")
	 use.opacity <- as.logical(use.opacity)

	 w <- .GtkCall("S_gtk_color_selection_set_opacity", colorsel, use.opacity, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSelectAll <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_select_all", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressBarSetActivityBlocks <-
function(pbar = NULL, blocks, .flush = TRUE)
{
	 gtkCheckInherits(pbar, "GtkProgressBar")
	 blocks <- as.integer(blocks)

	 w <- .GtkCall("S_gtk_progress_bar_set_activity_blocks", pbar, blocks, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFrameSetLabel <-
function(frame = NULL, label, .flush = TRUE)
{
	 gtkCheckInherits(frame, "GtkFrame")
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_frame_set_label", frame, label, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetSnapToTicks <-
function(spin.button = NULL, snap.to.ticks, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 snap.to.ticks <- as.logical(snap.to.ticks)

	 w <- .GtkCall("S_gtk_spin_button_set_snap_to_ticks", spin.button, snap.to.ticks, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkOptionMenuSetMenu <-
function(option.menu = NULL, menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(option.menu, "GtkOptionMenu")
	 gtkCheckInherits(menu, "GtkWidget")

	 w <- .GtkCall("S_gtk_option_menu_set_menu", option.menu, menu, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSignalHandlerUnblock <-
function(object = NULL, id, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 id <- as.integer(id)

	 w <- .GtkCall("S_gtk_signal_handler_unblock", object, id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListToggleFocusRow <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_toggle_focus_row", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetAcceleratorSignal <-
function(widget = NULL, group, key, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_widget_accelerator_signal", widget, group, key, modifiers, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTreeItemExpand <-
function(tree.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree.item, "GtkTreeItem")

	 w <- .GtkCall("S_gtk_tree_item_expand", tree.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetRowStyle <-
function(ctree = NULL, node, style, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_ctree_node_set_row_style", ctree, node, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetParent <-
function(widget = NULL, parent = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(parent, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_set_parent", widget, parent, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetSelectable <-
function(ctree = NULL, node, selectable, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 selectable <- as.logical(selectable)

	 w <- .GtkCall("S_gtk_ctree_node_set_selectable", ctree, node, selectable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerResizeChildren <-
function(container = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")

	 w <- .GtkCall("S_gtk_container_resize_children", container, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntryNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_entry_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkEntry", "GtkEditable", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCListSetHadjustment <-
function(clist = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_clist_set_hadjustment", clist, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuPrepend <-
function(menu = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_prepend", menu, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowAddAccelGroup <-
function(window = NULL, group, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 gtkCheckInherits(group, "GtkAccelGroup")

	 w <- .GtkCall("S_gtk_window_add_accel_group", window, group, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAdjustmentChanged <-
function(adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_adjustment_changed", adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewSetReserved <-
function(nreserved, .flush = TRUE)
{
	 nreserved <- as.integer(nreserved)

	 w <- .GtkCall("S_gtk_preview_set_reserved", nreserved, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerCheckResize <-
function(container = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")

	 w <- .GtkCall("S_gtk_container_check_resize", container, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionDialogSetFontName <-
function(fsd = NULL, fontname, .flush = TRUE)
{
	 gtkCheckInherits(fsd, "GtkFontSelectionDialog")
	 fontname <- as.character(fontname)

	 w <- .GtkCall("S_gtk_font_selection_dialog_set_font_name", fsd, fontname, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkRangeDrawBackground <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_draw_background", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPackerSetDefaultIpad <-
function(packer = NULL, ipad.x, ipad.y, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 ipad.x <- as.integer(ipad.x)
	 ipad.y <- as.integer(ipad.y)

	 w <- .GtkCall("S_gtk_packer_set_default_ipad", packer, ipad.x, ipad.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeChildPosition <-
function(tree = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_tree_child_position", tree, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkLayoutMove <-
function(layout = NULL, child = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")
	 gtkCheckInherits(child, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_layout_move", layout, child, x, y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetPage <-
function(notebook = NULL, page.num, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 page.num <- as.integer(page.num)

	 w <- .GtkCall("S_gtk_notebook_set_page", notebook, page.num, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkStatusbarPop <-
function(statusbar = NULL, context.id, .flush = TRUE)
{
	 gtkCheckInherits(statusbar, "GtkStatusbar")
	 context.id <- as.integer(context.id)

	 w <- .GtkCall("S_gtk_statusbar_pop", statusbar, context.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkComboDisableActivate <-
function(combo = NULL, .flush = TRUE)
{
	 gtkCheckInherits(combo, "GtkCombo")

	 w <- .GtkCall("S_gtk_combo_disable_activate", combo, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxSetSpacing <-
function(box = NULL, spacing, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_box_set_spacing", box, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkCursorNewFromPixmap <-
function(source, mask, fg, bg, x, y, .flush = TRUE)
{
	 gtkCheckInherits(source, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")
	 gtkCheckInherits(fg, "GdkColor")
	 gtkCheckInherits(bg, "GdkColor")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gdk_cursor_new_from_pixmap", source, mask, fg, bg, x, y, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GdkCursor")
	 return(w)

}
 

gtkSignalDisconnect <-
function(object = NULL, handler.id, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 handler.id <- as.integer(handler.id)

	 w <- .GtkCall("S_gtk_signal_disconnect", object, handler.id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVButtonBoxNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_vbutton_box_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVButtonBox", "GtkButtonBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkFileSelectionShowFileopButtons <-
function(filesel = NULL, .flush = TRUE)
{
	 gtkCheckInherits(filesel, "GtkFileSelection")

	 w <- .GtkCall("S_gtk_file_selection_show_fileop_buttons", filesel, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonClicked <-
function(button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")

	 w <- .GtkCall("S_gtk_button_clicked", button, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionSetPreviewText <-
function(fontsel = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(fontsel, "GtkFontSelection")
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_font_selection_set_preview_text", fontsel, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeItemSelect <-
function(tree.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tree.item, "GtkTreeItem")

	 w <- .GtkCall("S_gtk_tree_item_select", tree.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupLock <-
function(group, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")

	 w <- .GtkCall("S_gtk_accel_group_lock", group, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerSetBorderWidth <-
function(container = NULL, border.width, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 border.width <- as.integer(border.width)

	 w <- .GtkCall("S_gtk_container_set_border_width", container, border.width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetTabLabelText <-
function(notebook = NULL, child = NULL, tab.text, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 tab.text <- as.character(tab.text)

	 w <- .GtkCall("S_gtk_notebook_set_tab_label_text", notebook, child, tab.text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetUnparent <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_unparent", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWindowRemoveAccelGroup <-
function(window = NULL, group, .flush = TRUE)
{
	 gtkCheckInherits(window, "GtkWindow")
	 gtkCheckInherits(group, "GtkAccelGroup")

	 w <- .GtkCall("S_gtk_window_remove_accel_group", window, group, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkColorSelectionDialogNew <-
function(title, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)

	 w <- .GtkCall("S_gtk_color_selection_dialog_new", title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkColorSelectionDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkAccelGroupGetDefault <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_accel_group_get_default", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressSetActivityMode <-
function(progress = NULL, activity.mode, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 activity.mode <- as.integer(activity.mode)

	 w <- .GtkCall("S_gtk_progress_set_activity_mode", progress, activity.mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVSeparatorNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_vseparator_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVSeparator", "GtkSeparator", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetSetCompositeName <-
function(widget = NULL, name, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 name <- as.character(name)

	 w <- .GtkCall("S_gtk_widget_set_composite_name", widget, name, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListColumnTitlePassive <-
function(clist = NULL, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_column_title_passive", clist, column, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnTitle <-
function(clist = NULL, column, title, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 title <- as.character(title)

	 w <- .GtkCall("S_gtk_clist_set_column_title", clist, column, title, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeSetLineStyle <-
function(ctree = NULL, style = GtkCTreeLineStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 style  <- mapGtkCTreeLineStyle(style)

	 w <- .GtkCall("S_gtk_ctree_set_line_style", ctree, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntryPrependText <-
function(entry = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_entry_prepend_text", entry, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeSliderUpdate <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_slider_update", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetHadjustment <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_get_hadjustment", clist, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCheckButtonNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_check_button_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCheckButton", "GtkToggleButton", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkDragDestUnset <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_drag_dest_unset", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCurveSetCurveType <-
function(curve = NULL, type = GtkCurveType[1], .flush = TRUE)
{
	 gtkCheckInherits(curve, "GtkCurve")
	 type  <- mapGtkCurveType(type)

	 w <- .GtkCall("S_gtk_curve_set_curve_type", curve, type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntryNewWithMaxLength <-
function(max, show = TRUE, .flush = TRUE)
{
	 max <- as.integer(max)

	 w <- .GtkCall("S_gtk_entry_new_with_max_length", max, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkEntry", "GtkEditable", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkRcGetStyle <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_rc_get_style", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkNotebookSetTabVborder <-
function(notebook = NULL, tab.vborder, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 tab.vborder <- as.integer(tab.vborder)

	 w <- .GtkCall("S_gtk_notebook_set_tab_vborder", notebook, tab.vborder, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeCollapse <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_collapse", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeFind <-
function(ctree = NULL, node, child, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 gtkCheckInherits(child, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_find", ctree, node, child, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTextThaw <-
function(text = NULL, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")

	 w <- .GtkCall("S_gtk_text_thaw", text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkItemFactoryDeleteItem <-
function(ifactory = NULL, path, .flush = TRUE)
{
	 gtkCheckInherits(ifactory, "GtkItemFactory")
	 path <- as.character(path)

	 w <- .GtkCall("S_gtk_item_factory_delete_item", ifactory, path, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetShadowType <-
function(clist = NULL, border = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 border  <- mapGtkShadowType(border)

	 w <- .GtkCall("S_gtk_clist_set_shadow_type", clist, border, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeIsHotSpot <-
function(ctree = NULL, x, y, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 x <- as.integer(x)
	 y <- as.integer(y)

	 w <- .GtkCall("S_gtk_ctree_is_hot_spot", ctree, x, y, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListColumnTitlesShow <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_column_titles_show", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPackerSetChildPacking <-
function(packer = NULL, child = NULL, size = GtkSideType[1], anchor = GtkAnchorType[1], options, border.width = 0, pad.x = 0, pad.y = 0, ipad.x = 0, ipad.y = 0, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 gtkCheckInherits(child, "GtkWidget")
	 size  <- mapGtkSideType(size)
	 anchor  <- mapGtkAnchorType(anchor)
	 options  <- mapGtkPackerOptions(options)
	 border.width <- as.integer(border.width)
	 pad.x <- as.integer(pad.x)
	 pad.y <- as.integer(pad.y)
	 ipad.x <- as.integer(ipad.x)
	 ipad.y <- as.integer(ipad.y)

	 w <- .GtkCall("S_gtk_packer_set_child_packing", packer, child, size, anchor, options, border.width, pad.x, pad.y, ipad.x, ipad.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetState <-
function(widget = NULL, state = GtkStateType[1], .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 state  <- mapGtkStateType(state)

	 w <- .GtkCall("S_gtk_widget_set_state", widget, state, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionGetFont <-
function(fontsel = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fontsel, "GtkFontSelection")

	 w <- .GtkCall("S_gtk_font_selection_get_font", fontsel, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkRulerDrawPos <-
function(ruler = NULL, .flush = TRUE)
{
	 gtkCheckInherits(ruler, "GtkRuler")

	 w <- .GtkCall("S_gtk_ruler_draw_pos", ruler, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHButtonBoxGetSpacingDefault <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_hbutton_box_get_spacing_default", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkItemFactoryPopup <-
function(ifactory = NULL, x, y, mouse.button, time, .flush = TRUE)
{
	 gtkCheckInherits(ifactory, "GtkItemFactory")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 mouse.button <- as.integer(mouse.button)
	 time <- as.integer(time)

	 w <- .GtkCall("S_gtk_item_factory_popup", ifactory, x, y, mouse.button, time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetScrollable <-
function(notebook = NULL, scrollable, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 scrollable <- as.integer(scrollable)

	 w <- .GtkCall("S_gtk_notebook_set_scrollable", notebook, scrollable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressSetPercentage <-
function(progress = NULL, percentage, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 percentage <- as.numeric(percentage)

	 w <- .GtkCall("S_gtk_progress_set_percentage", progress, percentage, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkComboSetValueInList <-
function(combo = NULL, val, ok.if.empty, .flush = TRUE)
{
	 gtkCheckInherits(combo, "GtkCombo")
	 val <- as.logical(val)
	 ok.if.empty <- as.logical(ok.if.empty)

	 w <- .GtkCall("S_gtk_combo_set_value_in_list", combo, val, ok.if.empty, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelLabelGetAccelWidth <-
function(accel.label = NULL, .flush = TRUE)
{
	 gtkCheckInherits(accel.label, "GtkAccelLabel")

	 w <- .GtkCall("S_gtk_accel_label_get_accel_width", accel.label, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkPackerAdd <-
function(packer = NULL, child = NULL, side = GtkSideType[1], anchor = GtkAnchorType[1], options, border.width = 0, pad.x = 0, pad.y = 0, ipad.x = 0, ipad.y = 0, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 gtkCheckInherits(child, "GtkWidget")
	 side  <- mapGtkSideType(side)
	 anchor  <- mapGtkAnchorType(anchor)
	 options  <- mapGtkPackerOptions(options)
	 border.width <- as.integer(border.width)
	 pad.x <- as.integer(pad.x)
	 pad.y <- as.integer(pad.y)
	 ipad.x <- as.integer(ipad.x)
	 ipad.y <- as.integer(ipad.y)

	 w <- .GtkCall("S_gtk_packer_add", packer, child, side, anchor, options, border.width, pad.x, pad.y, ipad.x, ipad.y, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSignalHandlerBlock <-
function(object = NULL, id, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 id <- as.integer(id)

	 w <- .GtkCall("S_gtk_signal_handler_block", object, id, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextGetPoint <-
function(text = NULL, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")

	 w <- .GtkCall("S_gtk_text_get_point", text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTreeItemNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_tree_item_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTreeItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCListOptimalColumnWidth <-
function(clist = NULL, column, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)

	 w <- .GtkCall("S_gtk_clist_optimal_column_width", clist, column, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkPanedPack1 <-
function(paned = NULL, child = NULL, resize = TRUE, shrink = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 gtkCheckInherits(child, "GtkWidget")
	 resize <- as.logical(resize)
	 shrink <- as.logical(shrink)

	 w <- .GtkCall("S_gtk_paned_pack1", paned, child, resize, shrink, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPanedPack2 <-
function(paned = NULL, child = NULL, resize = TRUE, shrink = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 gtkCheckInherits(child, "GtkWidget")
	 resize <- as.logical(resize)
	 shrink <- as.logical(shrink)

	 w <- .GtkCall("S_gtk_paned_pack2", paned, child, resize, shrink, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListColumnTitlesHide <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_column_titles_hide", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkDrawString <-
function(drawable, font, gc, x, y, str, .flush = TRUE)
{
	 gtkCheckInherits(drawable, "GdkDrawable")
	 gtkCheckInherits(font, "GdkFont")
	 gtkCheckInherits(gc, "GdkGC")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 str <- as.character(str)

	 w <- .GtkCall("S_gdk_draw_string", drawable, font, gc, x, y, str, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarAppendItem <-
function(toolbar = NULL, text, tooltip, tooltip.private = '', icon = NULL, callback = NULL, user.data = NULL, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 text <- as.character(text)
	 tooltip <- as.character(tooltip)
	 tooltip.private <- as.character(tooltip.private)
	 gtkCheckInherits(icon, "GtkWidget", nullOk = TRUE)
	 gtkCheckInherits(callback, "GtkCallback", nullOk = TRUE)
	 gtkCheckInherits(user.data, "void", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_toolbar_append_item", toolbar, text, tooltip, tooltip.private, icon, callback, user.data, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkExit <-
function(code = 0, .flush = TRUE)
{
	 code <- as.integer(code)

	 w <- .GtkCall("S_gtk_exit", code, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRadioButtonNewFromWidget <-
function(group = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkRadioButton")

	 w <- .GtkCall("S_gtk_radio_button_new_from_widget", group, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkRadioButton", "GtkCheckButton", "GtkToggleButton", "GtkButton", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkFontSelectionDialogGetPreviewText <-
function(fsd = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fsd, "GtkFontSelectionDialog")

	 w <- .GtkCall("S_gtk_font_selection_dialog_get_preview_text", fsd, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkRcReparseAll <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_rc_reparse_all", PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSpin <-
function(spin.button = NULL, direction = GtkSpinType[1], increment, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 direction  <- mapGtkSpinType(direction)
	 increment <- as.numeric(increment)

	 w <- .GtkCall("S_gtk_spin_button_spin", spin.button, direction, increment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetPixtext <-
function(ctree = NULL, node, column, text, spacing, pixmap, mask, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)
	 text <- as.character(text)
	 spacing <- as.integer(spacing)
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")

	 w <- .GtkCall("S_gtk_ctree_node_set_pixtext", ctree, node, column, text, spacing, pixmap, mask, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetColumnVisibility <-
function(clist = NULL, column, visible, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 column <- as.integer(column)
	 visible <- as.logical(visible)

	 w <- .GtkCall("S_gtk_clist_set_column_visibility", clist, column, visible, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetUpdatePolicy <-
function(spin.button = NULL, policy = GtkSpinButtonUpdatePolicy[1], .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 policy  <- mapGtkSpinButtonUpdatePolicy(policy)

	 w <- .GtkCall("S_gtk_spin_button_set_update_policy", spin.button, policy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPanedSetHandleSize <-
function(paned = NULL, size, .flush = TRUE)
{
	 gtkCheckInherits(paned, "GtkPaned")
	 size <- as.integer(size)

	 w <- .GtkCall("S_gtk_paned_set_handle_size", paned, size, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableChanged <-
function(editable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")

	 w <- .GtkCall("S_gtk_editable_changed", editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableSetPosition <-
function(editable = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_editable_set_position", editable, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetPushStyle <-
function(style, .flush = TRUE)
{
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_widget_push_style", style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkDrawPixmap <-
function(drawable, gc, src, xsrc, ysrc, xdest, ydest, width, height, .flush = TRUE)
{
	 gtkCheckInherits(drawable, "GdkDrawable")
	 gtkCheckInherits(gc, "GdkGC")
	 gtkCheckInherits(src, "GdkDrawable")
	 xsrc <- as.integer(xsrc)
	 ysrc <- as.integer(ysrc)
	 xdest <- as.integer(xdest)
	 ydest <- as.integer(ydest)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gdk_draw_pixmap", drawable, gc, src, xsrc, ysrc, xdest, ydest, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkComboSetUseArrowsAlways <-
function(combo = NULL, val, .flush = TRUE)
{
	 gtkCheckInherits(combo, "GtkCombo")
	 val <- as.logical(val)

	 w <- .GtkCall("S_gtk_combo_set_use_arrows_always", combo, val, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPixmapSet <-
function(pixmap = NULL, val, mask, .flush = TRUE)
{
	 gtkCheckInherits(pixmap, "GtkPixmap")
	 gtkCheckInherits(val, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")

	 w <- .GtkCall("S_gtk_pixmap_set", pixmap, val, mask, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuGetActive <-
function(menu = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu, "GtkMenu")

	 w <- .GtkCall("S_gtk_menu_get_active", menu, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkComboSetItemString <-
function(combo = NULL, item = NULL, item.value, .flush = TRUE)
{
	 gtkCheckInherits(combo, "GtkCombo")
	 gtkCheckInherits(item, "GtkItem")
	 item.value <- as.character(item.value)

	 w <- .GtkCall("S_gtk_combo_set_item_string", combo, item, item.value, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTextSetPoint <-
function(text = NULL, index, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 index <- as.integer(index)

	 w <- .GtkCall("S_gtk_text_set_point", text, index, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookReorderChild <-
function(notebook = NULL, child = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 gtkCheckInherits(child, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_notebook_reorder_child", notebook, child, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressGetCurrentText <-
function(progress = NULL, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")

	 w <- .GtkCall("S_gtk_progress_get_current_text", progress, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkPackerSetDefaultBorderWidth <-
function(packer = NULL, border, .flush = TRUE)
{
	 gtkCheckInherits(packer, "GtkPacker")
	 border <- as.integer(border)

	 w <- .GtkCall("S_gtk_packer_set_default_border_width", packer, border, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetShadowType <-
function(spin.button = NULL, shadow.type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 shadow.type  <- mapGtkShadowType(shadow.type)

	 w <- .GtkCall("S_gtk_spin_button_set_shadow_type", spin.button, shadow.type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkProgressGetTextFromValue <-
function(progress = NULL, value, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 value <- as.numeric(value)

	 w <- .GtkCall("S_gtk_progress_get_text_from_value", progress, value, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkNotebookGetNthPage <-
function(notebook = NULL, page.num, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 page.num <- as.integer(page.num)

	 w <- .GtkCall("S_gtk_notebook_get_nth_page", notebook, page.num, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkHandleBoxSetHandlePosition <-
function(handle.box = NULL, position = GtkPositionType[1], .flush = TRUE)
{
	 gtkCheckInherits(handle.box, "GtkHandleBox")
	 position  <- mapGtkPositionType(position)

	 w <- .GtkCall("S_gtk_handle_box_set_handle_position", handle.box, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkIdleRemove <-
function(tag, .flush = TRUE)
{
	 tag <- as.integer(tag)

	 w <- .GtkCall("S_gtk_idle_remove", tag, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetBackground <-
function(clist = NULL, row, color, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 gtkCheckInherits(color, "GdkColor")

	 w <- .GtkCall("S_gtk_clist_set_background", clist, row, color, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToggleButtonSetActive <-
function(toggle.button = NULL, state, .flush = TRUE)
{
	 gtkCheckInherits(toggle.button, "GtkToggleButton")
	 state <- as.logical(state)

	 w <- .GtkCall("S_gtk_toggle_button_set_active", toggle.button, state, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListNew <-
function(columns, show = TRUE, .flush = TRUE)
{
	 columns <- as.integer(columns)

	 w <- .GtkCall("S_gtk_clist_new", columns, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkCList", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkDragGetData <-
function(widget = NULL, context, target, time, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(context, "GdkDragContext")
	 gtkCheckInherits(target, "GdkAtom")
	 time <- as.integer(time)

	 w <- .GtkCall("S_gtk_drag_get_data", widget, context, target, time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMain <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_main", PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetPixmap <-
function(ctree = NULL, node, column, pixmap, mask, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")

	 w <- .GtkCall("S_gtk_ctree_node_set_pixmap", ctree, node, column, pixmap, mask, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetActivate <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_activate", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTextInsert <-
function(text = NULL, font = NULL, fore = NULL, back = NULL, chars, length = -1, .flush = TRUE)
{
	 gtkCheckInherits(text, "GtkText")
	 gtkCheckInherits(font, "GdkFont", nullOk = TRUE)
	 gtkCheckInherits(fore, "GdkColor", nullOk = TRUE)
	 gtkCheckInherits(back, "GdkColor", nullOk = TRUE)
	 chars <- as.character(chars)
	 length <- as.integer(length)

	 w <- .GtkCall("S_gtk_text_insert", text, font, fore, back, chars, length, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListGetVadjustment <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_get_vadjustment", clist, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMenuBarPrepend <-
function(menu.bar = NULL, child = NULL, .flush = TRUE)
{
	 gtkCheckInherits(menu.bar, "GtkMenuBar")
	 gtkCheckInherits(child, "GtkWidget")

	 w <- .GtkCall("S_gtk_menu_bar_prepend", menu.bar, child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkColorSelectionSetUpdatePolicy <-
function(colorsel = NULL, policy = GtkUpdateType[1], .flush = TRUE)
{
	 gtkCheckInherits(colorsel, "GtkColorSelection")
	 policy  <- mapGtkUpdateType(policy)

	 w <- .GtkCall("S_gtk_color_selection_set_update_policy", colorsel, policy, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHRulerNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_hruler_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHRuler", "GtkRuler", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkFontSelectionDialogNew <-
function(title, show = TRUE, .flush = TRUE)
{
	 title <- as.character(title)

	 w <- .GtkCall("S_gtk_font_selection_dialog_new", title, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkFontSelectionDialog", "GtkWindow", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkRangeClearBackground <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_clear_background", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGrabDefault <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_grab_default", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCheckMenuItemSetShowToggle <-
function(menu.item = NULL, always, .flush = TRUE)
{
	 gtkCheckInherits(menu.item, "GtkCheckMenuItem")
	 always <- as.logical(always)

	 w <- .GtkCall("S_gtk_check_menu_item_set_show_toggle", menu.item, always, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSocketNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_socket_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkSocket", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkButtonBoxSetChildSizeDefault <-
function(min.width, min.height, .flush = TRUE)
{
	 min.width <- as.integer(min.width)
	 min.height <- as.integer(min.height)

	 w <- .GtkCall("S_gtk_button_box_set_child_size_default", min.width, min.height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkVScaleNew <-
function(adjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_vscale_new", adjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVScale", "GtkScale", "GtkRange", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkTooltipsNew <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_tooltips_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTooltips", "GtkData", "GtkObject")
	 return(w)

}
 

gtkAspectFrameNew <-
function(label, xalign, yalign, ratio, obey.child, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)
	 xalign <- as.numeric(xalign)
	 yalign <- as.numeric(yalign)
	 ratio <- as.numeric(ratio)
	 obey.child <- as.integer(obey.child)

	 w <- .GtkCall("S_gtk_aspect_frame_new", label, xalign, yalign, ratio, obey.child, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkAspectFrame", "GtkFrame", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCTreeNodeGetSelectable <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_node_get_selectable", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTreeSelectItem <-
function(tree = NULL, item, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 item <- as.integer(item)

	 w <- .GtkCall("S_gtk_tree_select_item", tree, item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeRemoveNode <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_remove_node", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetPixtext <-
function(clist = NULL, row, col, text, spacing, pixmap, mask, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 col <- as.integer(col)
	 text <- as.character(text)
	 spacing <- as.integer(spacing)
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap")

	 w <- .GtkCall("S_gtk_clist_set_pixtext", clist, row, col, text, spacing, pixmap, mask, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeClearItems <-
function(tree = NULL, start, end, .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 start <- as.integer(start)
	 end <- as.integer(end)

	 w <- .GtkCall("S_gtk_tree_clear_items", tree, start, end, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkButtonBoxSetLayout <-
function(widget = NULL, layout.style = GtkButtonBoxStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkButtonBox")
	 layout.style  <- mapGtkButtonBoxStyle(layout.style)

	 w <- .GtkCall("S_gtk_button_box_set_layout", widget, layout.style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPixmapSetBuildInsensitive <-
function(pixmap = NULL, build, .flush = TRUE)
{
	 gtkCheckInherits(pixmap, "GtkPixmap")
	 build <- as.integer(build)

	 w <- .GtkCall("S_gtk_pixmap_set_build_insensitive", pixmap, build, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuBarInsert <-
function(menu.bar = NULL, child = NULL, position, .flush = TRUE)
{
	 gtkCheckInherits(menu.bar, "GtkMenuBar")
	 gtkCheckInherits(child, "GtkWidget")
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_menu_bar_insert", menu.bar, child, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSetLocale <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_set_locale", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkVBoxNew <-
function(homogeneous = FALSE, spacing = 1, show = TRUE, .flush = TRUE)
{
	 homogeneous <- as.logical(homogeneous)
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_vbox_new", homogeneous, spacing, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkVBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkWidgetGetName <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_name", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkMiscSetPadding <-
function(misc = NULL, xpad, ypad, .flush = TRUE)
{
	 gtkCheckInherits(misc, "GtkMisc")
	 xpad <- as.integer(xpad)
	 ypad <- as.integer(ypad)

	 w <- .GtkCall("S_gtk_misc_set_padding", misc, xpad, ypad, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetQueueDrawArea <-
function(widget = NULL, x, y, width, height, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 x <- as.integer(x)
	 y <- as.integer(y)
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_widget_queue_draw_area", widget, x, y, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeSetSelectionMode <-
function(tree = NULL, mode = GtkSelectionMode[1], .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 mode  <- mapGtkSelectionMode(mode)

	 w <- .GtkCall("S_gtk_tree_set_selection_mode", tree, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListUnselectAll <-
function(list = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list, "GtkList")

	 w <- .GtkCall("S_gtk_list_unselect_all", list, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGetCompositeName <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_get_composite_name", widget, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkEditablePasteClipboard <-
function(editable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")

	 w <- .GtkCall("S_gtk_editable_paste_clipboard", editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxPackStart <-
function(box = NULL, child = NULL, expand = TRUE, fill = TRUE, padding = 0, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 gtkCheckInherits(child, "GtkWidget")
	 expand <- as.logical(expand)
	 fill <- as.logical(fill)
	 padding <- as.integer(padding)

	 w <- .GtkCall("S_gtk_box_pack_start", box, child, expand, fill, padding, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkScaleSetValuePos <-
function(scale = NULL, pos = GtkPositionType[1], .flush = TRUE)
{
	 gtkCheckInherits(scale, "GtkScale")
	 pos  <- mapGtkPositionType(pos)

	 w <- .GtkCall("S_gtk_scale_set_value_pos", scale, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkDrawingAreaSize <-
function(darea = NULL, width, height, .flush = TRUE)
{
	 gtkCheckInherits(darea, "GtkDrawingArea")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_drawing_area_size", darea, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetRowHeight <-
function(clist = NULL, height, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_clist_set_row_height", clist, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetQueueResize <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_queue_resize", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeExpandToDepth <-
function(ctree = NULL, node, depth, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 depth <- as.integer(depth)

	 w <- .GtkCall("S_gtk_ctree_expand_to_depth", ctree, node, depth, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTypeName <-
function(type, .flush = TRUE)
{
	 type <- as.integer(type)

	 w <- .GtkCall("S_gtk_type_name", type, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkAccelGroupActivate <-
function(group, key, modifiers, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 key <- as.integer(key)
	 modifiers  <- mapGdkModifierType(modifiers)

	 w <- .GtkCall("S_gtk_accel_group_activate", group, key, modifiers, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCTreeUnselectRecursive <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_unselect_recursive", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLayoutSetSize <-
function(layout = NULL, width, height, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")
	 width <- as.integer(width)
	 height <- as.integer(height)

	 w <- .GtkCall("S_gtk_layout_set_size", layout, width, height, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListItemSelect <-
function(list.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(list.item, "GtkListItem")

	 w <- .GtkCall("S_gtk_list_item_select", list.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetSetUsize <-
function(widget = NULL, height, width, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 height <- as.integer(height)
	 width <- as.integer(width)

	 w <- .GtkCall("S_gtk_widget_set_usize", widget, height, width, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonSetWrap <-
function(spin.button = NULL, wrap, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")
	 wrap <- as.logical(wrap)

	 w <- .GtkCall("S_gtk_spin_button_set_wrap", spin.button, wrap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListAppend <-
function(clist = NULL, text, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_clist_append", clist, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkNotebookSetShowBorder <-
function(notebook = NULL, show.border, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 show.border <- as.logical(show.border)

	 w <- .GtkCall("S_gtk_notebook_set_show_border", notebook, show.border, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkListItemNewWithLabel <-
function(label, show = TRUE, .flush = TRUE)
{
	 label <- as.character(label)

	 w <- .GtkCall("S_gtk_list_item_new_with_label", label, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkListItem", "GtkItem", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCListSetCellStyle <-
function(clist = NULL, row, column, style, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)
	 gtkCheckInherits(style, "GtkStyle")

	 w <- .GtkCall("S_gtk_clist_set_cell_style", clist, row, column, style, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkAccelGroupDetach <-
function(group, object = NULL, .flush = TRUE)
{
	 gtkCheckInherits(group, "GtkAccelGroup")
	 gtkCheckInherits(object, "GtkObject")

	 w <- .GtkCall("S_gtk_accel_group_detach", group, object, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableCopyClipboard <-
function(editable = NULL, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")

	 w <- .GtkCall("S_gtk_editable_copy_clipboard", editable, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkViewportNew <-
function(hadjustment = NULL, vadjustment = NULL, show = TRUE, .flush = TRUE)
{
	 gtkCheckInherits(hadjustment, "GtkAdjustment", nullOk = TRUE)
	 gtkCheckInherits(vadjustment, "GtkAdjustment", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_viewport_new", hadjustment, vadjustment, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkViewport", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkCListSort <-
function(clist = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")

	 w <- .GtkCall("S_gtk_clist_sort", clist, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEditableClaimSelection <-
function(editable = NULL, claim, time, .flush = TRUE)
{
	 gtkCheckInherits(editable, "GtkEditable")
	 claim <- as.logical(claim)
	 time <- as.integer(time)

	 w <- .GtkCall("S_gtk_editable_claim_selection", editable, claim, time, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerChildType <-
function(container = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")

	 w <- .GtkCall("S_gtk_container_child_type", container, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkItemFactoryParseRcString <-
function(rc.string, .flush = TRUE)
{
	 rc.string <- as.character(rc.string)

	 w <- .GtkCall("S_gtk_item_factory_parse_rc_string", rc.string, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetBackground <-
function(ctree = NULL, node, color, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 gtkCheckInherits(color, "GdkColor")

	 w <- .GtkCall("S_gtk_ctree_node_set_background", ctree, node, color, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHandleBoxSetSnapEdge <-
function(handle.box = NULL, position = GtkPositionType[1], .flush = TRUE)
{
	 gtkCheckInherits(handle.box, "GtkHandleBox")
	 position  <- mapGtkPositionType(position)

	 w <- .GtkCall("S_gtk_handle_box_set_snap_edge", handle.box, position, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetGrabFocus <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_widget_grab_focus", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkToolbarInsertItem <-
function(toolbar = NULL, text, tooltip, tooltip.private = '', icon = NULL, callback = NULL, user.data = NULL, position = -1, .flush = TRUE)
{
	 gtkCheckInherits(toolbar, "GtkToolbar")
	 text <- as.character(text)
	 tooltip <- as.character(tooltip)
	 tooltip.private <- as.character(tooltip.private)
	 gtkCheckInherits(icon, "GtkWidget", nullOk = TRUE)
	 gtkCheckInherits(callback, "GtkCallback", nullOk = TRUE)
	 gtkCheckInherits(user.data, "void", nullOk = TRUE)
	 position <- as.integer(position)

	 w <- .GtkCall("S_gtk_toolbar_insert_item", toolbar, text, tooltip, tooltip.private, icon, callback, user.data, position, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkAdjustmentClampPage <-
function(adjustment = NULL, lower, upper, .flush = TRUE)
{
	 gtkCheckInherits(adjustment, "GtkAdjustment")
	 lower <- as.numeric(lower)
	 upper <- as.numeric(upper)

	 w <- .GtkCall("S_gtk_adjustment_clamp_page", adjustment, lower, upper, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkWidgetEvent <-
function(widget = NULL, event, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")
	 gtkCheckInherits(event, "GdkEvent")

	 w <- .GtkCall("S_gtk_widget_event", widget, event, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressSetFormatString <-
function(progress = NULL, format, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 format <- as.character(format)

	 w <- .GtkCall("S_gtk_progress_set_format_string", progress, format, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeSetViewMode <-
function(tree = NULL, mode = GtkTreeViewMode[1], .flush = TRUE)
{
	 gtkCheckInherits(tree, "GtkTree")
	 mode  <- mapGtkTreeViewMode(mode)

	 w <- .GtkCall("S_gtk_tree_set_view_mode", tree, mode, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCheckMenuItemSetActive <-
function(check.menu.item = NULL, state, .flush = TRUE)
{
	 gtkCheckInherits(check.menu.item, "GtkCheckMenuItem")
	 state <- as.logical(state)

	 w <- .GtkCall("S_gtk_check_menu_item_set_active", check.menu.item, state, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkNotebookSetTabHborder <-
function(notebook = NULL, tab.hborder, .flush = TRUE)
{
	 gtkCheckInherits(notebook, "GtkNotebook")
	 tab.hborder <- as.integer(tab.hborder)

	 w <- .GtkCall("S_gtk_notebook_set_tab_hborder", notebook, tab.hborder, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerUnregisterToplevel <-
function(container = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")

	 w <- .GtkCall("S_gtk_container_unregister_toplevel", container, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEntryGetText <-
function(entry = NULL, .flush = TRUE)
{
	 gtkCheckInherits(entry, "GtkEntry")

	 w <- .GtkCall("S_gtk_entry_get_text", entry, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkAspectFrameSet <-
function(aspect.frame = NULL, xalign, yalign, ratio, obey.child, .flush = TRUE)
{
	 gtkCheckInherits(aspect.frame, "GtkAspectFrame")
	 xalign <- as.numeric(xalign)
	 yalign <- as.numeric(yalign)
	 ratio <- as.numeric(ratio)
	 obey.child <- as.integer(obey.child)

	 w <- .GtkCall("S_gtk_aspect_frame_set", aspect.frame, xalign, yalign, ratio, obey.child, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkMenuNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_menu_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkMenu", "GtkMenuShell", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkButtonSetRelief <-
function(button = NULL, newstyle = GtkReliefStyle[1], .flush = TRUE)
{
	 gtkCheckInherits(button, "GtkButton")
	 newstyle  <- mapGtkReliefStyle(newstyle)

	 w <- .GtkCall("S_gtk_button_set_relief", button, newstyle, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListMoveto <-
function(clist = NULL, row, column, row.align, column.align, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 column <- as.integer(column)
	 row.align <- as.numeric(row.align)
	 column.align <- as.numeric(column.align)

	 w <- .GtkCall("S_gtk_clist_moveto", clist, row, column, row.align, column.align, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkPreviewSetDither <-
function(preview = NULL, dither = GdkRgbDither[1], .flush = TRUE)
{
	 gtkCheckInherits(preview, "GtkPreview")
	 dither  <- mapGdkRgbDither(dither)

	 w <- .GtkCall("S_gtk_preview_set_dither", preview, dither, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTreeNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_tree_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkTree", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkLayoutSetHadjustment <-
function(layout = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_layout_set_hadjustment", layout, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkHBoxNew <-
function(homogeneous = FALSE, spacing = 1, show = TRUE, .flush = TRUE)
{
	 homogeneous <- as.logical(homogeneous)
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_hbox_new", homogeneous, spacing, PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHBox", "GtkBox", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkHPanedNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_hpaned_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkHPaned", "GtkPaned", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkDragSourceUnset <-
function(widget = NULL, .flush = TRUE)
{
	 gtkCheckInherits(widget, "GtkWidget")

	 w <- .GtkCall("S_gtk_drag_source_unset", widget, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCalendarUnmarkDay <-
function(calendar = NULL, day, .flush = TRUE)
{
	 gtkCheckInherits(calendar, "GtkCalendar")
	 day <- as.integer(day)

	 w <- .GtkCall("S_gtk_calendar_unmark_day", calendar, day, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkLabelSetLineWrap <-
function(label = NULL, wrap, .flush = TRUE)
{
	 gtkCheckInherits(label, "GtkLabel")
	 wrap <- as.logical(wrap)

	 w <- .GtkCall("S_gtk_label_set_line_wrap", label, wrap, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkRangeDrawSlider <-
function(range = NULL, .flush = TRUE)
{
	 gtkCheckInherits(range, "GtkRange")

	 w <- .GtkCall("S_gtk_range_draw_slider", range, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEventBoxNew <-
function(show = TRUE, .flush = TRUE)
{

	 w <- .GtkCall("S_gtk_event_box_new", PACKAGE='RGtk', .flush = .flush)
	 class(w) <- c("GtkEventBox", "GtkBin", "GtkContainer", "GtkWidget", "GtkObject")
	 if(show)
	   gtkWidgetShow(w)
	 return(w)

}
 

gtkMenuBarSetShadowType <-
function(menu.bar = NULL, type = GtkShadowType[1], .flush = TRUE)
{
	 gtkCheckInherits(menu.bar, "GtkMenuBar")
	 type  <- mapGtkShadowType(type)

	 w <- .GtkCall("S_gtk_menu_bar_set_shadow_type", menu.bar, type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkTipsQuerySetCaller <-
function(tips.query = NULL, caller = NULL, .flush = TRUE)
{
	 gtkCheckInherits(tips.query, "GtkTipsQuery")
	 gtkCheckInherits(caller, "GtkWidget")

	 w <- .GtkCall("S_gtk_tips_query_set_caller", tips.query, caller, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLayoutGetHadjustment <-
function(layout = NULL, .flush = TRUE)
{
	 gtkCheckInherits(layout, "GtkLayout")

	 w <- .GtkCall("S_gtk_layout_get_hadjustment", layout, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCTreeSortNode <-
function(ctree = NULL, node, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")

	 w <- .GtkCall("S_gtk_ctree_sort_node", ctree, node, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gdkAtomName <-
function(atom, .flush = TRUE)
{
	 gtkCheckInherits(atom, "GdkAtom")

	 w <- .GtkCall("S_gdk_atom_name", atom, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkProgressConfigure <-
function(progress = NULL, value, min, max, .flush = TRUE)
{
	 gtkCheckInherits(progress, "GtkProgress")
	 value <- as.numeric(value)
	 min <- as.numeric(min)
	 max <- as.numeric(max)

	 w <- .GtkCall("S_gtk_progress_configure", progress, value, min, max, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkLabelSetJustify <-
function(label = NULL, jtype = GtkJustification[1], .flush = TRUE)
{
	 gtkCheckInherits(label, "GtkLabel")
	 jtype  <- mapGtkJustification(jtype)

	 w <- .GtkCall("S_gtk_label_set_justify", label, jtype, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCheckMenuItemToggled <-
function(check.menu.item = NULL, .flush = TRUE)
{
	 gtkCheckInherits(check.menu.item, "GtkCheckMenuItem")

	 w <- .GtkCall("S_gtk_check_menu_item_toggled", check.menu.item, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkBoxReorderChild <-
function(box = NULL, child = NULL, pos, .flush = TRUE)
{
	 gtkCheckInherits(box, "GtkBox")
	 gtkCheckInherits(child, "GtkWidget")
	 pos <- as.integer(pos)

	 w <- .GtkCall("S_gtk_box_reorder_child", box, child, pos, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkStatusbarPush <-
function(statusbar = NULL, context.id, text, .flush = TRUE)
{
	 gtkCheckInherits(statusbar, "GtkStatusbar")
	 context.id <- as.integer(context.id)
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_statusbar_push", statusbar, context.id, text, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkTableSetRowSpacing <-
function(table = NULL, row, spacing, .flush = TRUE)
{
	 gtkCheckInherits(table, "GtkTable")
	 row <- as.integer(row)
	 spacing <- as.integer(spacing)

	 w <- .GtkCall("S_gtk_table_set_row_spacing", table, row, spacing, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetPixmap <-
function(clist = NULL, row, col, pixmap, mask = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row <- as.integer(row)
	 col <- as.integer(col)
	 gtkCheckInherits(pixmap, "GdkPixmap")
	 gtkCheckInherits(mask, "GdkBitmap", nullOk = TRUE)

	 w <- .GtkCall("S_gtk_clist_set_pixmap", clist, row, col, pixmap, mask, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCTreeNodeSetText <-
function(ctree = NULL, node, column, text, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)
	 text <- as.character(text)

	 w <- .GtkCall("S_gtk_ctree_node_set_text", ctree, node, column, text, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetVadjustment <-
function(clist = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_clist_set_vadjustment", clist, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkEventsPending <-
function(.flush = TRUE)
{

	 w <- .GtkCall("S_gtk_events_pending", PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkFrameSetLabelAlign <-
function(frame = NULL, xalign, yalign, .flush = TRUE)
{
	 gtkCheckInherits(frame, "GtkFrame")
	 xalign <- as.numeric(xalign)
	 yalign <- as.numeric(yalign)

	 w <- .GtkCall("S_gtk_frame_set_label_align", frame, xalign, yalign, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkContainerSetFocusVadjustment <-
function(container = NULL, adjustment = NULL, .flush = TRUE)
{
	 gtkCheckInherits(container, "GtkContainer")
	 gtkCheckInherits(adjustment, "GtkAdjustment")

	 w <- .GtkCall("S_gtk_container_set_focus_vadjustment", container, adjustment, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gTKOBJECTUNSETFLAGS <-
function(object = NULL, flags, .flush = TRUE)
{
	 gtkCheckInherits(object, "GtkObject")
	 flags  <- mapGtkWidgetFlags(flags)

	 w <- .GtkCall("S_GTK_OBJECT_UNSET_FLAGS", object, flags, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetUseDragIcons <-
function(clist = NULL, use.icons, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 use.icons <- as.logical(use.icons)

	 w <- .GtkCall("S_gtk_clist_set_use_drag_icons", clist, use.icons, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkFontSelectionDialogGetFontName <-
function(fsd = NULL, .flush = TRUE)
{
	 gtkCheckInherits(fsd, "GtkFontSelectionDialog")

	 w <- .GtkCall("S_gtk_font_selection_dialog_get_font_name", fsd, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCTreeNodeSetShift <-
function(ctree = NULL, node, column, vertical, horizontal, .flush = TRUE)
{
	 gtkCheckInherits(ctree, "GtkCTree")
	 gtkCheckInherits(node, "GtkCTreeNode")
	 column <- as.integer(column)
	 vertical <- as.integer(vertical)
	 horizontal <- as.integer(horizontal)

	 w <- .GtkCall("S_gtk_ctree_node_set_shift", ctree, node, column, vertical, horizontal, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkCListSetSortType <-
function(clist = NULL, sort.type = GtkSortType[1], .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 sort.type  <- mapGtkSortType(sort.type)

	 w <- .GtkCall("S_gtk_clist_set_sort_type", clist, sort.type, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

gtkSpinButtonGetAdjustment <-
function(spin.button = NULL, .flush = TRUE)
{
	 gtkCheckInherits(spin.button, "GtkSpinButton")

	 w <- .GtkCall("S_gtk_spin_button_get_adjustment", spin.button, PACKAGE='RGtk', .flush = .flush)
	 return(w)

}
 

gtkCListSwapRows <-
function(clist = NULL, row1, row2, .flush = TRUE)
{
	 gtkCheckInherits(clist, "GtkCList")
	 row1 <- as.integer(row1)
	 row2 <- as.integer(row2)

	 w <- .GtkCall("S_gtk_clist_swap_rows", clist, row1, row2, PACKAGE='RGtk', .flush = .flush)
	 invisible(return(w))

}
 

