/*	toolbar.h
	Copyright (C) 2006-2007 Mark Tyler and Dmitry Groshev

	This file is part of rgbPaint.

	rgbPaint is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	rgbPaint is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with rgbPaint in the file COPYING.
*/


#include <gtk/gtk.h>


//	DEFINITIONS


#define TOTAL_PALETTE_COLUMNS 2
#define TOTAL_PALETTE_ROWS 10
#define TOTAL_PALETTE_BUTTONS (TOTAL_PALETTE_COLUMNS * TOTAL_PALETTE_ROWS)

#define TOTAL_BRUSH_COLUMNS 2
#define TOTAL_BRUSH_ROWS 5
#define TOTAL_BRUSH_BUTTONS (TOTAL_BRUSH_COLUMNS * TOTAL_BRUSH_ROWS)

#define DEFAULT_BRUSH 8


//	Main toolbar buttons
#define MTB_NEW    0
#define MTB_OPEN   1
#define MTB_SAVE   2
#define MTB_CUT    3
#define MTB_COPY   4
#define MTB_PASTE  5
#define MTB_UNDO   6
#define MTB_REDO   7
#define MTB_BRCOSA 8
#define MTB_PAN    9
#define MTB_SAVE_AS   10

#define TOTAL_ICONS_MAIN 10


//	Tools toolbar buttons
#define TTB_PAINT    100
#define TTB_SHUFFLE  101
#define TTB_FLOOD    102
#define TTB_LINE     103
#define TTB_SMUDGE   104
#define TTB_CLONE    105
#define TTB_SELECT   106
#define TTB_POLY     107
#define TTB_GRAD     108
#define TTB_LASSO    109
#define TTB_TEXT     110
#define TTB_ELLIPSE  111
#define TTB_FELLIPSE 112
#define TTB_OUTLINE  113
#define TTB_FILL     114
#define TTB_SELFV    115
#define TTB_SELFH    116
#define TTB_SELRCW   117
#define TTB_SELRCCW  118

#define DEFAULT_TOOL_ICON TTB_SELECT
#define PAINT_TOOL_ICON TTB_PAINT

#define TTB_0 TOTAL_SETTINGS
#define TOTAL_ICONS_TOOLS 19

//	Settings toolbar buttons
#define SETB_CONT 0
#define SETB_OPAC 1
#define SETB_TINT 2
#define SETB_TSUB 3
#define SETB_CSEL 4
#define SETB_MASK 5
#define TOTAL_ICONS_SETTINGS 6
#define SETB_GRAD 6
#define TOTAL_SETTINGS 7

//	GLOBAL VARIABLES


GtkWidget *icon_buttons[TOTAL_ICONS_TOOLS];
GdkCursor *m_cursor[32];		// My mouse cursors
GdkCursor *move_cursor;

char *svg_dir;				// Location of SVG icons

//	GLOBAL PROCEDURES

void toolbar_init(GtkWidget *vbox_main);	// Set up the widgets to the vbox
void toolbar_palette_init(GtkWidget *box);	// Set up the palette area
int toolbar_stamp_init(GtkWidget *box);		// Set up the stamps buttons
void toolbar_palette_refresh();			// Populate palette buttons with colours
void toolbar_zoom_update();			// Update the zoom combos to reflect current zoom

void toolbar_select_select_tool();
void toolbar_select_paint_tool();

