/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "ScaleFramebuffer.h"
#include <stdlib.h>
#include <string.h>

namespace rfb {

ScaleFramebuffer::ScaleFramebuffer( Framebuffer & _fb, int _width, int _height )
    {
      fb = &_fb;
      width = _width;
      height = _height;
      pixelFormat = fb->pixelFormat;
      bytesPerLine = (pixelFormat.bits_per_pixel >> 3) * width;
      data = (unsigned char*) malloc( bytesPerLine * height );
    }


void ScaleFramebuffer::update( unsigned int _x,
                         unsigned int _y,
               		 unsigned int _w,
		         unsigned int _h
	               )
{
      _w = (fb->width * (_w + _x ) + width - 1) / width;
      _h = (fb->height * (_h + _y ) + height - 1) / height;
      _x = fb->width * _x / width;
      _y = fb->height * _y / height;
      _w -= _x;
      _h -= _y;
      unsigned int x, y;
      for ( y = _y; y < _y + _h; y++ ) {
          int sy0 = (y * height) / fb->height;
//          int dy1 = (y * height + fb->height/2) % fb->height;
          int sy1 = ((y+1) * height) / fb->height - 1;
//          int dy0 = fb->height - dy1;

          for ( x = _x; x < _x + _w; x++ ) {
              int sx0 = (x * width) / fb->width;
//              int dx1 = (x * width + fb->width/2) % fb->width;
              int sx1 = ((x+1) * width) / fb->width - 1;
//              int dx0 = fb->width - dx1;
              
              int r0, g0, b0; getPixel(sx0,sy0,r0,g0,b0,255);
              int r1, g1, b1; getPixel(sx0,sy1,r1,g1,b1,255);
              int r2, g2, b2; getPixel(sx1,sy0,r2,g2,b2,255);
              int r3, g3, b3; getPixel(sx1,sy1,r3,g3,b3,255);

              int r = (r0+r1+r2+r3) / 4;
              int g = (g0+g1+g2+g3) / 4;
              int b = (b0+b1+b2+b3) / 4;
              fb->putPixel(x,y,r,g,b,255);
          }
      }

      fb->update( _x, _y, _w, _h );
}

void ScaleFramebuffer::copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY
                         )
{
    Framebuffer::copyRect( _destX, _destY, _width, _height, _srcX, _srcY );
    update( _destX, _destY, _width, _height );
}


}
