/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef _hexonet_rfb_h_
#define _hexonet_rfb_h_

namespace rfb {


typedef unsigned char CARD8;

class CARD16
{
 public:
  CARD16( unsigned int _value = 0 );
  operator unsigned int() const {
    return (value[0] << 8) | value[1];
  }

  CARD16& operator=( unsigned int other );
  CARD8 value[2];
};


class CARD32
{
 public:
  CARD32( unsigned int _value = 0 );
  operator unsigned int() const {
    return (value[0] << 24) | (value[1] << 16) | (value[2] << 8) | value[3];
  }
  
  CARD32& operator=( unsigned int other );
  CARD8 value[4];
};



#define RFB_PROTOCOL_VERSION "RFB 003.003\n"

#define RFB_ENCODING_RAW          0
#define RFB_ENCODING_COPYRECT     1
#define RFB_ENCODING_RRE          2
#define RFB_ENCODING_CORRE        4
#define RFB_ENCODING_HEXTILE      5

#ifdef RFB_PROTOCOL_EXTENSION
#define RFB_ENCODING_EXTENSION  255
#endif // RFB_PROTOCOL_EXTENSION


#define RFB_MAX_ENCODINGS 63

typedef struct {
  CARD32 count;
  CARD32 encoding[RFB_MAX_ENCODINGS];
} Encodings;


typedef struct {
  CARD8  bits_per_pixel;
  CARD8  depth;
  CARD8  big_endian_flag;
  CARD8  true_colour_flag;
  CARD16 red_max;
  CARD16 green_max;
  CARD16 blue_max;
  CARD8  red_shift;
  CARD8  green_shift;
  CARD8  blue_shift;
  CARD8  padding2[3];
} PixelFormat;


typedef struct {
  CARD8  message_type;
  CARD8 padding[3];
  PixelFormat pixelFormat;
} MessagePixelFormat;


typedef CARD8 ProtocolVersion[13];



typedef struct {
  CARD32 authentication_scheme;
  CARD8  challenge[16];
  CARD32 status;
} ServerAuthentication;


typedef struct {
  CARD8 shared_flag;
} ClientInitialisation;


typedef struct {
   CARD16 framebuffer_width;
   CARD16 framebuffer_height;
   PixelFormat server_pixel_format;
   CARD32 name_length;
   CARD8 *name_string;
} ServerInitialisation;



struct SetPixelFormat {
  CARD8 padding[3];
  PixelFormat pixelFormat;
};

struct SetEncodings {
  CARD8  padding;
  CARD16 number_of_encodings;
};



struct FramebufferUpdateRequest {
  CARD8  incremental;
  CARD16 x_position;
  CARD16 y_position;
  CARD16 width;
  CARD16 height;
};

typedef struct {
  CARD8  message_type;
  struct FramebufferUpdateRequest framebufferUpdateRequest;
} MessageFramebufferUpdateRequest;

struct KeyEvent {
 CARD8  down_flag;
 CARD8  padding[2];
 CARD32 key;
};

typedef struct {
  CARD8  message_type;
  struct KeyEvent keyEvent;
} MessageKeyEvent;

struct PointerEvent {
 CARD8  button_mask;
 CARD16 x_position;
 CARD16 y_position;
};

typedef struct {
  CARD8  message_type;
  struct PointerEvent pointerEvent;
} MessagePointerEvent;


class Data //: public Message
{
 public:
//  virtual unsigned int getMessageSize();
//  virtual unsigned char* getMessageDataPointer();

  struct {
   CARD8  message_type;
   CARD32 length;
   CARD8  *data; 
  } data;
};



typedef struct {
 CARD8  padding;
 CARD16 number_of_rectangles;
} FramebufferUpdate;


typedef struct {
   CARD8 message_type;
   FramebufferUpdate framebufferUpdate;
} MessageFramebufferUpdate;


typedef struct {
   CARD16 x_position;
   CARD16 y_position;
   CARD16 width;
   CARD16 height;
   CARD32 encoding_type;
} Rectangle;




class State
{
 protected:
  State();

 public:
  virtual ~State();

  virtual void update();
};




} // namespace rfb

#endif //_hexonet_rfb_h_
