// 
// $Id: qaregexplanguage.cpp,v 1.1 2000/06/12 10:53:28 amos-cvs Exp $
//
// Implementation of QaRegExpLanguage class
//
// Jan Borsodi <jb@ez.no>
// Created on: <12-Jun-2000 12:17:32 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.


#include "qaregexplanguage.hpp"
#include <qstring.h>
#include <qobject.h>

/*!
  \class QaRegExpLanguage qaregexplanguage.hpp
  \brief
  \author <a href="mailto:jb@ez.no">Jan Borsodi</a>
  \date Enter current date here

*/

/*!
  Default constructor
*/

QaRegExpLanguage::QaRegExpLanguage()
{
}

/*!
  Destroys the object
*/

QaRegExpLanguage::~QaRegExpLanguage()
{
}

/*!
  Converts the RegExp to a plain form, that is without special \'s etc..
*/

QString QaRegExpLanguage::fromPlainText( const QString &s, bool, MatchType )
{
    QString str;
    unsigned int i = 0;
    bool bracket = false;
    bool negated = false;
//    ( i = s.find( "\\", i ) ) != -1 )
    for ( i = 0; i < s.length(); i++ )
    {
        QChar c2 = s.at( i );
        if ( bracket )
        {
            if ( c2 == ']' )
            {
                bracket = false;
                negated = false;
                str += c2;
            }
            else if ( c2 == '^' )
            {
                negated = true;
                str += c2;
            }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == "t" )
                        str += "\t";
                    else if ( c == "n" )
                        str += "\n";
                    else if ( c == "r" )
                        str += "\r";
                    else if ( c == "f" )
                        str += "\f";
                    else if ( c == "d" )
                        str += "0-9";
                    else if ( c == "D" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += "0-9";
                    }
                    else if ( c == "w" )
                        str += characters();
                    else if ( c == "W" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += characters();
                    }
                    else if ( c == 'c' )
                        str += nonCapitalCharacters();
                    else if ( c == 'C' )
                        str += capitalCharacters();
                    else if ( c == 'i' )
                        str += wordCharacters();
                    else if ( c == "s" )
                        str += " \t\n\r\f";
                    else if ( c == "S" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += " \t\n\r\f";
                    }
                    else if ( c == "]" )
                        str += "\\]";
                    else if ( c == "\\" )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else
                str += c2;
        }
//\a<(class|public|private|protected|typename|signals|slots)>
        else
        {
            if ( c2 == '[' )
            {
                bracket = true;
                negated = false;
                str += c2;
            }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == 't' )
                        str += "\t";
                    else if ( c == 'n' )
                        str += "\n";
                    else if ( c == 'r' )
                        str += "\r";
                    else if ( c == 'f' )
                        str += "\f";
                    else if ( c == 'd' )
                        str += "[0-9]";
                    else if ( c == 'D' )
                        str += "[^0-9]";
                    else if ( c == 'w' )
                        str += QString( "[" ) + characters() + QString( "]" );
                    else if ( c == 'W' )
                        str +=  QString( "[^" ) + characters() + QString( "]" );
                    else if ( c == 'c' )
                        str += QString( "[" ) + nonCapitalCharacters() + QString( "]" );
                    else if ( c == 'C' )
                        str += QString( "[" ) + capitalCharacters() + QString( "]" );
                    else if ( c == 'i' )
                        str += QString( "[" ) + wordCharacters() + QString( "]" );
                    else if ( c == 'I' )
                        str += identifiers();
                    else if ( c == 's' )
                        str += "[ \t\n\r\f]";
                    else if ( c == 'S' )
                        str += "[^ \t\n\r\f]";
//                    else if ( c == "]" )
//                        str += "\\]";
                    else if ( c == '\\' )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else
                str += c2;
        }
    }
    return str;
}

QString QaRegExpLanguage::wordCharacters() const
{
    return QString( "%10-9" ).arg( characters() );
}

QString QaRegExpLanguage::characters() const
{
    return nonCapitalCharacters() + capitalCharacters();
}

QString QaRegExpLanguage::capitalCharacters() const
{
    return QString( QObject::tr( "A-Z" ) );
}

QString QaRegExpLanguage::nonCapitalCharacters() const
{
    return QString( QObject::tr( "a-z" ) );
}

QString QaRegExpLanguage::identifiers() const
{
    return QString( "[%1][%2_0-9]" ).arg( characters() ).arg( characters() );
}

