// 
// $Id$
//
// Implementation of QaQtLanguage class
//
// Jan Borsodi <jb@ez.no>
// Created on: <06-Sep-2000 18:19:51 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.


#include "qaqtlanguage.hpp"

#include <qregexp.h>

/*! \file qaqtlanguage.cpp
  Implementation of QaQtLanguage class
*/

/*!
  \class QaQtLanguage qaqtlanguage.hpp
  \brief
  \author <a href="mailto:jb@ez.no">Jan Borsodi</a>
  \date Enter current date here

*/

/*!
  Default constructor
*/

QaQtLanguage::QaQtLanguage()
    : QaRegExpLanguage()
{
}

/*!
  Destroys the object
*/

QaQtLanguage::~QaQtLanguage()
{
}

/*!
  Converts the RegExp to a plain form, that is without special \'s etc..
*/

QString QaQtLanguage::fromPlainText( const QString &s, bool code, MatchType type )
{
    QRegExp num_reg1( "^[0-9]+$" );
    QRegExp num_reg2( "^[0-9]+,$" );
    QRegExp num_reg3( "^[0-9]+,[0-9]+$" );
    QRegExp num_reg4( "^,[0-9]+$" );
    QString str;
    int i = 0;
//      int subexpr = 0;
    bool bracket = false;
    bool negated = false;
    int bracket_start = -1;
    int bracket_end = -1;
//    ( i = s.find( "\\",i ) ) != -1 )
    for ( i = 0; i < (int)s.length(); i++ )
    {
        QChar c2 = s.at( i );
        if ( bracket )
        {
            if ( c2 == ']' )
            {
                bracket = false;
                negated = false;
                str += c2;
                bracket_end = str.length();
            }
            else if ( c2 == '^' )
            {
                negated = true;
                str += c2;
            }
            else if ( c2 == '"' && code )
            {
                str += "\\";
                str += c2;
            }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < (int)s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == "t" )
                        str += "\\\\t";
                    else if ( c == "n" )
                        str += "\\\\n";
                    else if ( c == "r" )
                        str += "\\\\r";
                    else if ( c == "f" )
                        str += "\\\\f";
                    else if ( c == "d" )
                        str += "\\\\d";
                    else if ( c == "D" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += "\\\\d";
                    }
                    else if ( c == "w" )
                        str += characters();
                    else if ( c == "W" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += characters();
                    }
                    else if ( c == 'c' )
                        str += nonCapitalCharacters();
                    else if ( c == 'C' )
                        str += capitalCharacters();
                    else if ( c == 'i' )
                        str += wordCharacters();
                    else if ( c == "s" )
                        str += "\\\\s";
                    else if ( c == "S" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += "\\\\s";
                    }
                    else if ( c == "]" )
                        str += "\\\\]";
                    else if ( c == "\\" )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else
                str += c2;
        }
        else
        {
            if ( c2 == '[' )
            {
                bracket = true;
                negated = false;
                bracket_start = str.length();
                str += c2;
            }
            else if ( c2 == '{' )
            {
                ++i;
                int end = s.find( '}', i );
                if ( end != -1 )
                {
                    if ( end > i )
                    {
                        QString s_tmp = s.mid( i, end - i );
                        if ( num_reg1.match( s_tmp ) == 0 ) // Match {a}
                        {
                            int val = s_tmp.toInt();
                            if ( bracket_start >= 0 && bracket_end >= 0 && bracket_end >= bracket_start )
                            {
                                if ( val == 0 )
                                {
                                    str = str.mid( 0, bracket_start );
                                }
                                else
                                {
                                    for ( int cnt = 1; cnt < val; ++cnt )
                                        str += str.mid( bracket_start, bracket_end - bracket_start );
                                }
                            }
                            i = end;
                        }
                        else if ( num_reg2.match( s_tmp ) == 0 ) // Match {a,}
                        {
                            int val = s_tmp.mid( 0, s_tmp.length() - 1 ).toInt();
                            if ( bracket_start >= 0 && bracket_end >= 0 && bracket_end >= bracket_start )
                            {
                                if ( val == 0 )
                                {
                                    str += "*";
                                }
                                else if ( val == 1 )
                                {
                                    str += "+";
                                }
                                else
                                {
                                    for ( int cnt = 2; cnt < val; ++cnt )
                                        str += str.mid( bracket_start, bracket_end - bracket_start );
                                    str += str.mid( bracket_start, bracket_end - bracket_start );
                                    str += "+";
                                }
                            }
                            i = end;
                        }
                        else if ( num_reg3.match( s_tmp ) == 0 ) // Match {a,b}
                        {
                            int comma_place = s_tmp.find( ',', 0 );
                            int min_val = s_tmp.mid( 0, comma_place ).toInt();
                            int max_val = s_tmp.mid( comma_place + 1 ).toInt();
                            if ( min_val == 0 )
                                str += "?";
                            if ( bracket_start >= 0 && bracket_end >= 0 && bracket_end >= bracket_start )
                            {
                                for ( int cnt = 1; cnt < min_val; ++cnt )
                                    str += str.mid( bracket_start, bracket_end - bracket_start );
                                for ( int cnt = min_val; cnt < max_val; ++cnt )
                                    str += str.mid( bracket_start, bracket_end - bracket_start ) + "?";
                            }
                            i = end;
                        }
                        else if ( num_reg4.match( s_tmp ) == 0 ) // Match {,b}
                        {
                            int comma_place = s_tmp.find( ',', 0 );
                            int max_val = s_tmp.mid( comma_place + 1 ).toInt();
                            str += "?";
                            if ( bracket_start >= 0 && bracket_end >= 0 && bracket_end >= bracket_start )
                            {
                                for ( int cnt = 0; cnt < max_val - 1; ++cnt )
                                    str += str.mid( bracket_start, bracket_end - bracket_start ) + "?";
                            }
                            i = end;
                        }
                        else // Match {}
                        {
                            str += "*";
                            --i;
                        }
                    }
                    else
                    {
                        str += "{}";
                        i = end;
                    }
                }
                else
                {
                    str += "{";
                    --i;
                }
            }
            // Qt doesn't support sub expressions yet so no need to check
//              else if ( c2 == '(' )
//              {
//                  subexpr = 1;
//                  bracket_start = str.length();
//              }
            else if ( c2 == '"' && code )
            {
                str += "\\";
                str += c2;
            }
            else if ( c2 == '\\' )
            {
                bracket_start = str.length();
                i++;
                if ( i < (int)s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == 't' )
                        str += "\\\\t";
                    else if ( c == 'n' )
                        str += "\\\\n";
                    else if ( c == 'r' )
                        str += "\\\\r";
                    else if ( c == 'f' )
                        str += "\\\\f";
                    else if ( c == 'd' )
                        str += "\\\\d";
                    else if ( c == 'D' )
                        str += "[^\\\\d]";
                    else if ( c == 'w' )
                        str += QString( "[" ) + characters() + QString( "]" );
                    else if ( c == 'W' )
                        str +=  QString( "[^" ) + characters() + QString( "]" );
                    else if ( c == 'c' )
                        str += QString( "[" ) + nonCapitalCharacters() + QString( "]" );
                    else if ( c == 'C' )
                        str += QString( "[" ) + capitalCharacters() + QString( "]" );
                    else if ( c == 'i' )
                        str += QString( "[" ) + wordCharacters() + QString( "]" );
                    else if ( c == 'I' )
                        str += identifiers();
                    else if ( c == 's' )
                        str += "\\\\s";
                    else if ( c == 'S' )
                        str += "[^\\\\s]";
//                    else if ( c == "]" )
//                        str += "\\]";
                    else if ( c == '\\' )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c2;
                        str += c;
                    }
                    bracket_end = str.length();
                }
                else
                {
                    str += c2;
                    str += c2;
                }
            }
            else
            {
                bracket_start = str.length();
                str += c2;
                bracket_end = str.length();
            }
        }
    }
    if ( code )
    {
        if ( type == QaRegExpLanguage::Multiple )
        {
            str = QString( ".match( \"%1\", 0 ) != -1 " ).arg( str );
        }
        else if ( type == QaRegExpLanguage::Multiple )
        {
            str = QString( ".match( \"%1\", 0 ) != -1 " ).arg( str );
        }
        else
        {
            str = QString( ".match( \"%1\", 0 ) != -1 " ).arg( str );
        }
    }
    return str;
}
