#!/usr/bin/env ruby
# Make for rdtool.
# Copyright (C) 2004 MoonWolf <moonwolf@moonwolf.com>
require 'rbconfig'
require 'optparse'

bindir     = Config::CONFIG['bindir']
sitelibdir = Config::CONFIG['sitelibdir']
racc       = nil

opt = OptionParser.new

opt.on('--bindir')     {|v| bindir     = v }
opt.on('--sitelibdir') {|v| sitelibdir = v }
opt.on('--with-racc')  {|v| racc       = v }

opt.parse!(ARGV)

racc ||= `which racc`.chomp
rd2 = File.join(File.dirname(File.expand_path(__FILE__)),'bin','rd2')

# Parser make
STDERR.puts "racc rd/rdblockparser.ry"
system(racc, 'lib/rd/rdblockparser.ry')

STDERR.puts "racc rd/rdinlineparser.ry"
system(racc, 'lib/rd/rdinlineparser.ry')

# Document make
STDERR.puts "rd2 README.rd"
open('README.html','w') {|f|
  f.write `#{rd2} README.rd`
}

STDERR.puts "rd2 README.rd.ja"
open('README.ja.html','w') {|f|
  f.write `#{rd2} README.rd.ja`
}
