#include "rcui.h"
 
static GnomeUIInfo file1_menu_uiinfo[] =
{
  GNOMEUIINFO_MENU_NEW_ITEM (N_("_New"), NULL, on_new1_activate, NULL),
  GNOMEUIINFO_MENU_OPEN_ITEM (on_open1_activate, NULL),
  GNOMEUIINFO_MENU_SAVE_ITEM (on_save1_activate, NULL),
  GNOMEUIINFO_MENU_SAVE_AS_ITEM (on_save_as1_activate, NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM (on_quit1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo degrees1_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Degrees"),
    NULL,
    (gpointer) on_degrees1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Radians"),
    NULL,
    (gpointer) on_radians1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo angle_unit1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_RADIOITEMS, NULL, NULL, degrees1_uiinfo,
    NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,
    (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo edit1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_SUBTREE, N_("Angle unit"),
    NULL,
    angle_unit1_menu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};


static GnomeUIInfo view1_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Variables and functions"),
    NULL,
    (gpointer) on_variables1_activate, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, "gtk-find",
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo help1_menu_uiinfo[] =
{
  GNOMEUIINFO_HELP ("rcalc"),
  GNOMEUIINFO_MENU_ABOUT_ITEM (on_about1_activate, NULL),
  GNOMEUIINFO_END
};

static GnomeUIInfo mainw_menubar_uiinfo[] =
{
  GNOMEUIINFO_MENU_FILE_TREE (file1_menu_uiinfo),
  GNOMEUIINFO_MENU_EDIT_TREE (edit1_menu_uiinfo),
  GNOMEUIINFO_MENU_VIEW_TREE (view1_menu_uiinfo),
  GNOMEUIINFO_MENU_HELP_TREE (help1_menu_uiinfo),
  GNOMEUIINFO_END
};

static void mainw_add_columns (GtkTreeView *treeview)
{
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

  renderer = gtk_cell_renderer_toggle_new ();
  column = gtk_tree_view_column_new_with_attributes ("",
                                                   renderer,
                                                   "active", RUN_COLUMN,
                                                   NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Name"),
                                                   renderer,
                                                   "text", NAME_COLUMN,
                                                   NULL);
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Expression"),
                                                   renderer,
                                                   "text", EXPR_COLUMN,
                                                   NULL);
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  
  renderer = gtk_cell_renderer_text_new ();
  column = gtk_tree_view_column_new_with_attributes (_("Value"),
                                                   renderer,
                                                   "text", VALUE_COLUMN,
                                                   NULL);
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);	
}

GtkWidget*
create_main_window (void)
{
  GtkWidget *main_window;
  GtkWidget *mainw_bbdock;
  GtkWidget *mainw_toolbar;
  GtkIconSize tmp_toolbar_icon_size;
  GtkWidget *toolbar_newb;
  GtkWidget *toolbar_openb;
  GtkWidget *toolbar_saveb;
  GtkWidget *toolbar_item1;
  GtkWidget *toolbar_vseparator1;
  GtkWidget *toolbar_cleanb;
  GtkWidget *mainw_vbox;
  GtkWidget *mainw_sw;
  GtkWidget *mainw_treeview;
  GtkWidget *mainw_linebbox;
  GtkWidget *mainw_RMVbutton;
  GtkWidget *mainw_upb;
  GtkWidget *image2;
  GtkWidget *mainw_downb;
  GtkWidget *image3;
  GtkWidget *mainw_linestateb;
  GtkWidget *alignment1;
  GtkWidget *hbox2;
  GtkWidget *image8;
  GtkWidget *label1;
  GtkWidget *mainw_vseparator1;
  GtkWidget *mainw_linecombo;
  GtkWidget *mainw_hbox;
  GtkWidget *mainw_promptlbl;
  GtkWidget *mainw_entry;
  GtkWidget *mainw_combo_box_entry;
  GtkWidget *mainw_bottomsw;
  GtkWidget *mainw_bottomtextview;
  GtkAccelGroup *accel_group;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  accel_group = gtk_accel_group_new ();

  main_window = gnome_app_new ("rcalc", _("rcalc"));

  mainw_bbdock = GNOME_APP (main_window)->dock;
  gtk_widget_show (mainw_bbdock);

  /*gnome_app_create_menus (GNOME_APP (main_window), mainw_menubar_uiinfo);*/
  gnome_app_create_menus_with_data  (GNOME_APP (main_window), mainw_menubar_uiinfo, 
      GTK_OBJECT(main_window));

  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (degrees1_uiinfo[ui_params.angle_unit].widget), TRUE);

  mainw_toolbar = gtk_toolbar_new ();
  gtk_widget_show (mainw_toolbar);
  gnome_app_add_toolbar (GNOME_APP (main_window), GTK_TOOLBAR (mainw_toolbar), "mainw_toolbar",
                                BONOBO_DOCK_ITEM_BEH_EXCLUSIVE,
                                BONOBO_DOCK_TOP, 1, 0, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (mainw_toolbar), GTK_TOOLBAR_ICONS);
  tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (mainw_toolbar));

  toolbar_newb = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-new");
  gtk_widget_show (toolbar_newb);
  gtk_container_add (GTK_CONTAINER (mainw_toolbar), toolbar_newb);
  gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_newb), tooltips, _("New rcalc session"), NULL);

  toolbar_openb = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-open");
  gtk_widget_show (toolbar_openb);
  gtk_container_add (GTK_CONTAINER (mainw_toolbar), toolbar_openb);
  gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_openb), tooltips, _("Open session file"), NULL);

  toolbar_saveb = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-save");
  gtk_widget_show (toolbar_saveb);
  gtk_container_add (GTK_CONTAINER (mainw_toolbar), toolbar_saveb);
  gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_saveb), tooltips, _("Save session"), NULL);

  toolbar_item1 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolbar_item1);
  gtk_container_add (GTK_CONTAINER (mainw_toolbar), toolbar_item1);

  toolbar_vseparator1 = gtk_vseparator_new ();
  gtk_widget_show (toolbar_vseparator1);
  gtk_container_add (GTK_CONTAINER (toolbar_item1), toolbar_vseparator1);

  toolbar_cleanb = (GtkWidget*) gtk_tool_button_new_from_stock ("gtk-clear");
  gtk_widget_show (toolbar_cleanb);
  gtk_container_add (GTK_CONTAINER (mainw_toolbar), toolbar_cleanb);
  gtk_tool_item_set_tooltip (GTK_TOOL_ITEM (toolbar_cleanb), tooltips, _("Remove undefined lines"), NULL);

  mainw_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (mainw_vbox);
  gnome_app_set_contents (GNOME_APP (main_window), mainw_vbox);

  mainw_sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (mainw_sw);
  gtk_box_pack_start (GTK_BOX (mainw_vbox), mainw_sw, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mainw_sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  mainw_linebbox = gtk_hbox_new (FALSE, 3);
  gtk_widget_show (mainw_linebbox);
  gtk_box_pack_start (GTK_BOX (mainw_vbox), mainw_linebbox, TRUE, TRUE, 0);

  mainw_RMVbutton = gtk_button_new_from_stock ("gtk-remove");
  gtk_widget_show (mainw_RMVbutton);
  gtk_box_pack_start (GTK_BOX (mainw_linebbox), mainw_RMVbutton, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, mainw_RMVbutton, _("Remove line"), NULL);

  mainw_upb = gtk_button_new ();
  gtk_widget_show (mainw_upb);
  gtk_box_pack_start (GTK_BOX (mainw_linebbox), mainw_upb, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, mainw_upb, _("Move up"), NULL);

  image2 = gtk_image_new_from_stock ("gtk-go-up", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image2);
  gtk_container_add (GTK_CONTAINER (mainw_upb), image2);

  mainw_downb = gtk_button_new ();
  gtk_widget_show (mainw_downb);
  gtk_box_pack_start (GTK_BOX (mainw_linebbox), mainw_downb, FALSE, FALSE, 0);
  gtk_tooltips_set_tip (tooltips, mainw_downb, _("Move down"), NULL);

  image3 = gtk_image_new_from_stock ("gtk-go-down", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image3);
  gtk_container_add (GTK_CONTAINER (mainw_downb), image3);

  mainw_linestateb = gtk_button_new ();
  gtk_widget_show (mainw_linestateb);
  gtk_box_pack_start (GTK_BOX (mainw_linebbox), mainw_linestateb, FALSE, FALSE, 0);

  alignment1 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (mainw_linestateb), alignment1);

  hbox2 = gtk_hbox_new (FALSE, 2);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (alignment1), hbox2);

  image8 = gtk_image_new_from_stock ("gtk-stop", GTK_ICON_SIZE_BUTTON);
  gtk_widget_show (image8);
  gtk_box_pack_start (GTK_BOX (hbox2), image8, FALSE, FALSE, 0);

  label1 = gtk_label_new_with_mnemonic (_("(In)activate"));
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, FALSE, 0);

  mainw_vseparator1 = gtk_vseparator_new ();
  gtk_widget_show (mainw_vseparator1);
  gtk_box_pack_start (GTK_BOX (mainw_linebbox), mainw_vseparator1, TRUE, TRUE, 0);

  mainw_linecombo = gtk_combo_box_new_text ();
  gtk_widget_show (mainw_linecombo);
  gtk_box_pack_start (GTK_BOX (mainw_linebbox), mainw_linecombo, TRUE, TRUE, 0);
  gtk_combo_box_append_text (GTK_COMBO_BOX (mainw_linecombo), _("Insert at end"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (mainw_linecombo), _("Insert before"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (mainw_linecombo), _("Insert after"));
  gtk_combo_box_append_text (GTK_COMBO_BOX (mainw_linecombo), _("Replace"));

  mainw_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (mainw_hbox);
  gtk_box_pack_start (GTK_BOX (mainw_vbox), mainw_hbox, FALSE, FALSE, 0);

  mainw_promptlbl = gtk_label_new (_("rcalc> "));
  gtk_widget_show (mainw_promptlbl);
  gtk_box_pack_start (GTK_BOX (mainw_hbox), mainw_promptlbl, FALSE, FALSE, 0);

  /*mainw_entry = gnome_entry_new (NULL);*/
  /*mainw_combo_box_entry = gtk_combo_box_entry_new_text ();*/
  mainw_combo_box_entry = gtk_combo_box_entry_new_with_model (GTK_TREE_MODEL(ui_stores.history),
    0);
  gtk_widget_show (mainw_combo_box_entry);
  gtk_box_pack_start (GTK_BOX (mainw_hbox), mainw_combo_box_entry, TRUE, TRUE, 0);
  gtk_widget_set_size_request (mainw_combo_box_entry, 381, -1);
  GTK_WIDGET_SET_FLAGS (mainw_combo_box_entry, GTK_CAN_FOCUS);
  /*gnome_entry_set_max_saved (GNOME_ENTRY (mainw_entry), 20);*/

  mainw_entry = GTK_BIN (mainw_combo_box_entry)->child;
  
  g_signal_connect(G_OBJECT(mainw_entry), "key_press_event",
					 G_CALLBACK(on_mainw_entry_key_press_cb), GTK_OBJECT (main_window));

  mainw_bottomsw = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (mainw_bottomsw);
  gtk_box_pack_start (GTK_BOX (mainw_vbox), mainw_bottomsw, FALSE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mainw_bottomsw), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  mainw_bottomtextview = gtk_text_view_new ();
  gtk_widget_show (mainw_bottomtextview);
  gtk_container_add (GTK_CONTAINER (mainw_bottomsw), mainw_bottomtextview);
  gtk_widget_set_size_request (mainw_bottomtextview, -1, 110);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (mainw_bottomtextview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (mainw_bottomtextview), FALSE);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (mainw_bottomtextview)), _("Welcome to rcalc."), -1);

  /********************* HERE ************************/
  mainw_treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (ui_stores.mainw_store));
  gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (mainw_treeview), TRUE);
  gtk_widget_show (mainw_treeview);
  gtk_container_add (GTK_CONTAINER (mainw_sw), mainw_treeview);
  gtk_widget_set_size_request (mainw_treeview, -1, 360);
  
  mainw_add_columns(GTK_TREE_VIEW(mainw_treeview));
  
#if 0
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (mainw_treeview));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
  g_signal_connect (G_OBJECT (select), "changed",
                  G_CALLBACK (on_mainw_tree_selection_changed),
                  GTK_OBJECT (main_window));
#endif
  
  g_signal_connect (G_OBJECT (mainw_treeview), "cursor-changed",
                  G_CALLBACK (on_mainw_tree_cursor_changed),
                  GTK_OBJECT (main_window));                
                                       
  gtk_widget_set_sensitive (mainw_RMVbutton, FALSE);
  gtk_widget_set_sensitive (mainw_upb, FALSE);
  gtk_widget_set_sensitive (mainw_downb, FALSE);
  gtk_widget_set_sensitive (mainw_linestateb, FALSE);
  gtk_widget_set_sensitive (mainw_linecombo, FALSE);
  
  gtk_widget_grab_focus (mainw_entry);
  /*gtk_editable_set_position (0, mainw_combo_entry);*/
  
  gtk_combo_box_set_active (GTK_COMBO_BOX(mainw_linecombo), RCUI_INSERT_END);
  /********************* HERE ************************/	

  g_signal_connect ((gpointer) main_window, "destroy",
                    G_CALLBACK (on_main_window_destroy),
                    NULL);
  g_signal_connect ((gpointer) toolbar_newb, "clicked",
                    G_CALLBACK (on_toolbar_newb_clicked),
                    GTK_OBJECT (main_window));
  g_signal_connect ((gpointer) toolbar_openb, "clicked",
                    G_CALLBACK (on_toolbar_openb_clicked),
                    GTK_OBJECT (main_window));
  g_signal_connect ((gpointer) toolbar_saveb, "clicked",
                    G_CALLBACK (on_toolbar_saveb_clicked),
                    GTK_OBJECT (main_window));
  g_signal_connect ((gpointer) toolbar_cleanb, "clicked",
                    G_CALLBACK (on_toolbar_cleanb_clicked),
                    GTK_OBJECT (main_window));
  g_signal_connect ((gpointer) mainw_RMVbutton, "clicked",
                            G_CALLBACK (on_mainw_RMVbutton_clicked),
                            GTK_OBJECT (main_window));
  g_signal_connect ((gpointer) mainw_upb, "clicked",
                    G_CALLBACK (on_mainw_upb_clicked),
                    NULL);
  g_signal_connect ((gpointer) mainw_downb, "clicked",
                    G_CALLBACK (on_mainw_downb_clicked),
                    NULL);
  g_signal_connect ((gpointer) mainw_linestateb, "clicked",
                    G_CALLBACK (on_mainw_linestateb_clicked),
                    NULL);
  g_signal_connect ((gpointer) mainw_linecombo, "changed",
                    G_CALLBACK (on_mainw_linecombo_changed),
                    NULL);
  g_signal_connect ((gpointer) mainw_entry, "activate",
                            G_CALLBACK (on_mainw_entry_activate),
                            GTK_OBJECT (main_window));

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (main_window, main_window, "main_window");
  GLADE_HOOKUP_OBJECT (main_window, mainw_bbdock, "mainw_bbdock");
  GLADE_HOOKUP_OBJECT (main_window, mainw_menubar_uiinfo[0].widget, "file1");
  GLADE_HOOKUP_OBJECT (main_window, file1_menu_uiinfo[0].widget, "new1");
  GLADE_HOOKUP_OBJECT (main_window, file1_menu_uiinfo[1].widget, "open1");
  GLADE_HOOKUP_OBJECT (main_window, file1_menu_uiinfo[2].widget, "save1");
  GLADE_HOOKUP_OBJECT (main_window, file1_menu_uiinfo[3].widget, "save_as1");
  GLADE_HOOKUP_OBJECT (main_window, file1_menu_uiinfo[4].widget, "separator1");
  GLADE_HOOKUP_OBJECT (main_window, file1_menu_uiinfo[5].widget, "quit1");
  GLADE_HOOKUP_OBJECT (main_window, mainw_menubar_uiinfo[1].widget, "edit1");
  GLADE_HOOKUP_OBJECT (main_window, edit1_menu_uiinfo[0].widget, "preferences1");
  GLADE_HOOKUP_OBJECT (main_window, mainw_menubar_uiinfo[2].widget, "view1");
  GLADE_HOOKUP_OBJECT (main_window, view1_menu_uiinfo[0].widget, "variables1");
  GLADE_HOOKUP_OBJECT (main_window, mainw_menubar_uiinfo[3].widget, "help1");
  GLADE_HOOKUP_OBJECT (main_window, help1_menu_uiinfo[1].widget, "sommaire1");
  GLADE_HOOKUP_OBJECT (main_window, help1_menu_uiinfo[2].widget, "about1");
  GLADE_HOOKUP_OBJECT (main_window, mainw_toolbar, "mainw_toolbar");
  GLADE_HOOKUP_OBJECT (main_window, toolbar_newb, "toolbar_newb");
  GLADE_HOOKUP_OBJECT (main_window, toolbar_openb, "toolbar_openb");
  GLADE_HOOKUP_OBJECT (main_window, toolbar_saveb, "toolbar_saveb");
  GLADE_HOOKUP_OBJECT (main_window, toolbar_item1, "toolbar_item1");
  GLADE_HOOKUP_OBJECT (main_window, toolbar_vseparator1, "toolbar_vseparator1");
  GLADE_HOOKUP_OBJECT (main_window, toolbar_cleanb, "toolbar_cleanb");
  GLADE_HOOKUP_OBJECT (main_window, mainw_vbox, "mainw_vbox");
  GLADE_HOOKUP_OBJECT (main_window, mainw_sw, "mainw_sw");
  GLADE_HOOKUP_OBJECT (main_window, mainw_treeview, "mainw_treeview");
  GLADE_HOOKUP_OBJECT (main_window, mainw_linebbox, "mainw_linebbox");
  GLADE_HOOKUP_OBJECT (main_window, mainw_RMVbutton, "mainw_RMVbutton");
  GLADE_HOOKUP_OBJECT (main_window, mainw_upb, "mainw_upb");
  GLADE_HOOKUP_OBJECT (main_window, image2, "image2");
  GLADE_HOOKUP_OBJECT (main_window, mainw_downb, "mainw_downb");
  GLADE_HOOKUP_OBJECT (main_window, image3, "image3");
  GLADE_HOOKUP_OBJECT (main_window, mainw_linestateb, "mainw_linestateb");
  GLADE_HOOKUP_OBJECT (main_window, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (main_window, hbox2, "hbox2");
  GLADE_HOOKUP_OBJECT (main_window, image8, "image8");
  GLADE_HOOKUP_OBJECT (main_window, label1, "label1");
  GLADE_HOOKUP_OBJECT (main_window, mainw_vseparator1, "mainw_vseparator1");
  GLADE_HOOKUP_OBJECT (main_window, mainw_linecombo, "mainw_linecombo");
  GLADE_HOOKUP_OBJECT (main_window, mainw_hbox, "mainw_hbox");
  GLADE_HOOKUP_OBJECT (main_window, mainw_promptlbl, "mainw_promptlbl");
  GLADE_HOOKUP_OBJECT (main_window, mainw_entry, "mainw_entry");
  GLADE_HOOKUP_OBJECT (main_window, mainw_combo_box_entry, "mainw_combo_box_entry");
  GLADE_HOOKUP_OBJECT (main_window, mainw_bottomsw, "mainw_bottomsw");
  GLADE_HOOKUP_OBJECT (main_window, mainw_bottomtextview, "mainw_bottomtextview");
  GLADE_HOOKUP_OBJECT_NO_REF (main_window, tooltips, "tooltips");

  gtk_widget_grab_focus (mainw_entry);
  gtk_window_add_accel_group (GTK_WINDOW (main_window), accel_group);

  return main_window;
}
